//͸
//  Program .....: Nmonths                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
// Function...: nMonths()                                   
// Syntax.....: x = nMonths(<exp1>, <exp2>)                 
// ...... Calculates the number of months between two dates 
//

Function nMonths(par1, par2)

    local recent, prior, ret_val, y_diff


    if valtype(par1) # 'D' .or. valtype(par2) # 'D'
      Return( 0 )

    Endif

    recent := MAX( par1, par2)
    prior  := MIN( par1, par2)


    y_diff := Year(recent) - Year(prior)

    if y_diff = 0
        ret_val := month(recent) - Month(prior)

    else
        ret_val := 12 - month(prior) + month(recent) + ((y_diff - 1) * 12)

    Endif

    if Day(recent) - Day(prior) < 0
      ret_val--

    Endif

Return( ret_val )
