/*

  Replacement Code for @...Prompt MESSAGE Menu to   construct

  Highlights quick key

  quick key defined as first non-space character   ( clipper default )
                       character following '&'     ( windows API     )

  eg.
       @10,10 Prompt " o&Ption 1 "
       @11,10 Prompt " Option 2 "
       @12,10 Prompt " option &3 "

       Menu to x

*/


#define MENU_SIZE   5

#define MENU_ROW    1
#define MENU_COL    2
#define MENU_PROMPT 3
#define MENU_MESS   4
#define MENU_KEY    5

#define MENU_QUICK  '&' //change this and re-compile MENU.PRG if you need to
                      // use character other than the ampersand.



#include "Inkey.ch"
#include "Setcurs.ch"

STATIC aPrompts := {}
STATIC cQuickColor := NIL


FUNC SetQuick(cColor)

  IF cColor==NIL
     IF cQuickColor==NIL
        RETURN SetColor()
     ELSE
        RETURN cQuickColor
     END
  ELSE
     cQuickColor := cColor
  END

RETURN NIL  



FUNC __AtPrompt(nRow,nCol,cPrompt,cMsg)

  * This places the prompts on the screen and adds them to an array declared
  * STATIC at the top of this code.

  IF cQuickColor == NIL
    cQuickColor := Setcolor()
  END
  IF Empty(cMsg)
     cMsg := ''
  END
  PromptSay(nRow,nCol,cPrompt,SetColor(),SetQuick(),MENU_QUICK)
  Aadd(aPrompts,{nRow,nCol,cPrompt,cMsg,QuickKey(cPrompt)})

RETURN NIL


FUNC __MenuTo(bVarblock,cVarName)

  * that routine that does the keystroke handling and displays the
  * highlighted menu action
  Local nKey:=0,nCurrent:=0,nWidemess:=0,nNumprompts:=Len(aPrompts)
  Local cScreen,nRow,cPrompt,nCol,cMsg,nCount,nRetval:=0, done := .f., keyBlock
  

  * set cursor off, color to background color
  Local cSaveColor  := SetColor(BarColor(SetColor()))
  Local iSaveCursor := SetCursor(SC_NONE)

  * check the get-set block sent for a valid variable, set to one if necessary
   nCurrent := Eval(bVarblock)
   if nCurrent == 0
     nCurrent := 1
   endif

  * find the widest message, store in nWidemess
  aEval(aPrompts,{|x| nWidemess := Max(nWidemess,LEN(x[MENU_MESS]))})

  DO WHILE .T.
     * get the row, col, prompt, and message from the list..
     nRow    := aPrompts[nCurrent,MENU_ROW]
     nCol    := aPrompts[nCurrent,MENU_COL]
     cPrompt := aPrompts[nCurrent,MENU_PROMPT]
     cMsg    := aPrompts[nCurrent,MENU_MESS]

     * save the current choice in normal color
     cScreen := SaveScreen(nRow,nCol,nRow,nCol+Len(cPrompt))

     * Highlight the current choice
     prompt_hilite(nrow,ncol,cprompt)

     * draw the current message if on, checking SET MESSAGE and CENTER
     IF Set(_SET_MESSAGE) # 0
        IF Set(_SET_MCENTER)
           @ Set(_SET_MESSAGE),(MaxCol()/2) - (nWideMess/2) ;
             SAY Padc(cMsg,nWidemess)
        ELSE
           @ Set(_SET_MESSAGE),0 SAY Padl(cMsg,nWidemess)
        END
     END

     IF ! DONE
       ** Do the keypause...
       nKey=Ncc_K_Wait(0)

       * UnHighlight the current choice using RestScreen()
       RestScreen(nRow,nCol,nRow,nCol+Len(cPrompt),cScreen)
     ELSE
       nKey := K_RETURN
     END

     * the big switch...
     DO CASE
       CASE (keyBlock := setkey(nKey)) # NIL
          eval( keyBlock, procname(2),procline(2),cVarName )

       CASE nKey==K_HOME
          nCurrent := 1

       CASE nKey==K_END
          nCurrent := nNumprompts

       CASE (nKey==K_UP .OR. nKey==K_LEFT)
          IF nCurrent > 1
             nCurrent--
          ELSE
             IF Set(_SET_WRAP)
                nCurrent := nNumprompts
             END
          END

       CASE (nKey==K_DOWN .OR. nKey==K_RIGHT)
          IF nCurrent < nNumprompts
             nCurrent++
          ELSE
             IF Set(_SET_WRAP)
                nCurrent := 1
             END
          END

       CASE nKey==5001
          nRetVal := nKey
          exit

       CASE nKey==K_ESC
          EXIT

       CASE nKey==K_ENTER
          nRetval := nCurrent
          EXIT

       OTHERWISE
          * other keys - check for a match against the list of Quick keys
          * saved when prompt list was created.
          FOR nCount=1 TO nNumprompts
             IF Upper(Chr(nKey))=Upper(Substr(aPrompts[nCount,MENU_KEY],1,1))
                nCurrent := nCount
                EXIT
             END
          NEXT

          * user pressed a char key and it matched..
          IF nCount<nNumprompts+1
             nRetval := nCount
             done := .t.
          END

     ENDCASE

  ENDDO

  * release the prompt list
  aPrompts := {}
  * restore the color and cursor
  SetColor(cSaveColor)
  SetCursor(iSaveCursor)
  * return the value

RETURN nRetval



STATIC FUNC BarColor(CoAttrib)

  * returns the second color in the dBase list: if dBase setting is
  * W+/B,N/W returns 'N/W'

RETURN SUBSTR(coattrib,AT(",",coattrib)+1)



STATIC FUNC QuickKey(cPrompt)

  * finds either the key specified as the Quick key with the MENU_QUICK
  * character, or the first non-blank character (clipper default)
  IF ! MENU_QUICK $ cPrompt
     RETURN Upper(Substr(cPrompt,notblank(cPrompt),1))
  ELSE
     RETURN Upper(SUBSTR(cPrompt,AT(MENU_QUICK,cPrompt)+1))
  END
return (NIL)


STATIC FUNC PromptSay(nRow,nCol,cString,cNormal,cHighlight)

  * places the prompt on the screen, highlighting the Quick key in the
  * QuickCOLOR
  Local nPlace
  Local nRowSave          := NIL
  Local nColSave          := NIL
  Local cSavecolor        := Setcolor(cNormal)

  * display String in normal color without Ampersands
  @ nRow,nCol SAY Strtran(cString,MENU_QUICK,'')

  nRowSave := row()          // save row
  nColSave := col()          // save column

  * Check for the ampersand
  IF MENU_QUICK $ cString
     nPlace := AT(MENU_QUICK,cString)
  ELSE
     nPlace := notblank(cString)
  END
  SetColor(cHighlight)
  @ nRow,nCol+nPlace-1 SAY Substr(Strtran(cString,MENU_QUICK,''),nPlace,1)
  Setcolor(cSavecolor)
  Setpos(nRowSave,nColSave)

RETURN NIL



STATIC FUNC prompt_hilite(nrow,ncol,cstring)
  Local nPlace
  Local nRowSave          := NIL
  Local nColSave          := NIL
  Local cSavecolor        := Setcolor()

  * display String in normal color without Ampersands
  @ nRow,nCol SAY Strtran(cString,MENU_QUICK,'')

  nRowSave := row()          // save row
  nColSave := col()          // save column

  * Check for the ampersand
  IF MENU_QUICK $ cString
     nPlace := AT(MENU_QUICK,cString)
  ELSE
     nPlace := notblank(cString)
  END

  SetColor(barcolor(SetQuick()))
  @ nRow,nCol+nPlace-1 SAY Substr(Strtran(cString,MENU_QUICK,''),nPlace,1)
  SetColor(cSavecolor)
  Setpos(nRowSave,nColSave)

RETURN NIL



STATIC FUNC NOTBLANK( cString )
  local len, i, ret_val

  len     := len(cString)
  ret_val := 0

  FOR i = 1 to len
    IF subs(cString,i,1) # ' '
      ret_val := i
      EXIT
    END

  NEXT

RETURN ret_val
