;
; Clock for Clipper S87 and 5.0
;
;

extrn  __parl:far
extrn  __parni:far

pushall     macro
            push   bp
            mov    bp,sp
            pushf
            push   ax
            push   bx
            push   cx
            push   dx
            push   si
            push   di
            push   es
            push   ds
            endm

popall      macro
            pop    ds
            pop    es
            pop    di
            pop    si
            pop    dx
            pop    cx
            pop    bx
            pop    ax
            popf
            pop    bp
            endm



dgroup      group    _DATA

my_text     segment  byte public 'CODE'
            assume   cs:my_text,ds:dgroup,es:dgroup


horiz_retrace    equ    00000001b
tick_per_minute  equ    1556h
tick_per_second  equ    005bh
min_per_hour     equ    003ch
sec_per_min      equ    003ch
istrue           equ    0001h
isfalse          equ    0000h
color_begin      equ    0b800h
color_6845       equ    03d4h
mono_begin       equ    0b000h
mono_6845        equ    03b4h
bytes_per_row    equ    00a0h   ; 160   80*2


bios             segment        at  0040h
                 org            006ch
timer_low        label          word
                 org            006eh
timer_high       label          word
                 org            0070h
timer_ofl        label          byte
bios             ends


_data            segment        byte public 'DATA'
datastart        equ            $
display          label          dword
video_offset     dw             0000h
video_begin      dw             0000h
video_port       dw             0000h
clock_on         db             00h
blink            dw             3ah
tickcount        db             8
attr             db             ?
row              db             ?
col              db             ?
current_hr       label          word
                 db             '   '
current_min      label          word
                 db             '   m'
;current_sec      label          word
;                 db             '00'
time_size        equ            $ - current_hr
datasize         equ            $ - datastart
_data            ends

nextint1ch       LABEL          dword
int1choffset     dw             0000h
int1chsegment    dw             0000h
clipdata         dw             0000h

                 public         autoclock
autoclock        proc           far
                 pushall
                 cld
                 mov            ax,0040h
                 mov            ds,ax
                 assume         ds:bios
                 mov            ax,timer_high
                 mov            dx,timer_low
                 mov            ds,clipdata
                 assume         ds:dgroup
                 mov            bx,dx
                 mov            cx,00005h
                 mul            cx
                 xchg           ax,bx
                 mul            cx
                 add            dx,bx
                 mov            cx,tick_per_minute
                 div            cx
                 push           dx
                 xor            dx,dx
                 mov            cx,min_per_hour
                 div            cx

storehour:
                 aam
                 or             ax,3030h
                 xchg           ah,al
                 mov            current_hr,ax
                 mov            ax,dx
                 aam
                 or             ax,3030h
                 cmp            ah,36h
                 jnz            storeminutes
                 mov            ax,3539h

storeminutes:
                 xchg           ah,al
                 mov            current_min,ax
                 xor            dx,dx
                 pop            ax
                 mov            cx,tick_per_second
                 div            cx

setupregisters:
                 les            di,display
                 lea            si,current_hr
                 mov            dx,video_port
                 add            dx,0006h
                 mov            bh,attr           ;  Attribute of clock

                 inc            tickcount
                 cmp            tickcount,9
                 jne            d_cont

                 mov            tickcount,0
                 cmp            blink,3ah
                 je             blink_is_on

blink_is_off:
                 mov            blink,3ah     ; blink
                 jmp            d_cont

blink_is_on:
                 mov            blink,20h     ; no blink


d_cont:
                 push           ax
                 xor            ax,ax
                 mov            al,30h        ; '0'
                 cmp            [si],al       ; check if time = 0_:
                 je             chk_00

                 xor            ax,ax
                 mov            ah,[si]       ; move hour to ax
                 mov            al,[si+1]     ;
                 cmp            ax,3132h      ; check if time = 12:
                 je             make_pm

                 cmp            ax,3132h      ; compare again
                 jl             fix_time      ; if less than 12 fix up time

                 cmp            ax,3230h      ; 20
                 jl             regular

                 cmp            ax,3232h      ; 22
                 jl             fix_20_up

                 sub            ax,3132h
                 aam
                 xor            ax,3030h
                 mov            ah,31h
                 jmp            cont2


fix_20_up:
                 sub            ax,3228h      ; sub 28 from time
                 jmp            cont1

regular:
                 sub            ax,3132h      ; subtract 12 from time


cont1:
                 aam
                 xor            ax,3030h
                 mov            ah,20h        ; ' '

cont2:
                 mov            [si],ah
                 mov            [si+1],al

                 jmp            make_pm

fix_time:

                 cmp            ah,31h        ; '1'
                 je             no_tuch       ; dont touch

                 xor            ax,ax         ; else
                 mov            al,20h        ; ' '
                 mov            [si],al       ; change 0 to space

no_tuch:
                 jmp            make_am

chk_00:
                 cmp            [si+1],al     ; '0'
                 je             make_12_am    ; = 00: so it is 12 'am'

                 xor            ax,ax
                 mov            al,20h        ; ' '
                 mov            [si],al       ; else
                 jmp            make_am       ; < 10 am . change 0 to space

make_12_am:
                 xor            ax,ax
                 mov            ax,3132h      ; '12'
                 mov            [si],ah
                 mov            [si+1],al
                 jmp            make_am       ; 'am'

make_am:
                 xor            ax,ax
                 mov            ax,61h        ; a - am
                 mov            [si+5],al
                 jmp            h_done

make_pm:
                 xor            ax,ax
                 mov            ax,70h        ; p - pm
                 mov            [si+5],al

h_done:
                 xor            ax,ax
                 mov            ax,blink
                 mov            [si+2],al
                 pop            ax

                 mov            cx,time_size

displayclock:
                 mov            bl,[si]
                 call           screenwrite
                 inc            si
                 loop           displayclock

autoclockend:
                 popall
                 jmp            cs:nextint1ch


screenwrite      proc           near
                 in             al,dx
                 test           al,01h
                 jnz            screenwrite

waitforretrace:
                 in             al,dx
                 test           al,01h
                 jz             waitforretrace
                 mov            ax,bx
                 stosw
                 ret
screenwrite      endp
autoclock        endp


                 public         asmclock
asmclock         proc           far
                 pushall

                 cld                                ; Param #1 (  1 = on
                 mov            ax,0001h            ;             0 = off )
                 push           ax
                 call           __parl
                 add            sp,02h
                 or             ax,ax
                 jz             jmp_tmp

                 cld                                ; Param #2 ( row )
                 mov            ax,0002h
                 push           ax
                 call           __parni
                 add            sp,02h
                 mov            row,al

                 cld                                ; Param #3 ( col )
                 mov            ax,0003h
                 push           ax
                 call           __parni
                 add            sp,02h
                 mov            col,al

                 xor            ax,ax               ; set cursor position
                 mov            ah,2h
                 mov            bh,0h
                 mov            dl,col
                 mov            dh,row
                 int            10h

                 xor            ax,ax               ; read at cursor position
                 mov            ah,8h
                 mov            bh,0
                 int            10h
                 mov            attr,ah
                 jmp            cont


jmp_tmp:
                 jmp            clockoff

cont:
                 cmp            clock_on,istrue
                 jz             myclockend
                 mov            ax,351ch
                 int            21h
                 mov            cs:int1choffset,bx
                 mov            cs:int1chsegment,es
                 mov            cs:clipdata,ds
                 mov            clock_on,istrue
                 mov            ah,0fh
                 int            10h
                 mov            dx,mono_6845
                 mov            bx,mono_begin
                 cmp            al,07h
                 jz             clockonvideo
                 mov            dx,color_6845
                 mov            bx,color_begin

clockonvideo:
                 mov            video_begin,bx
                 mov            video_port,dx

                 xor            bx,bx
                 xor            ax,ax
                 mov            bl,col
                 shl            bx,01h
                 mov            al,row
;                 xchg           ah,al
;                 xor            ah,ah
                 mov            cx,bytes_per_row
                 imul           cx
                 add            bx,ax
                 mov            video_offset,bx

                 lea            dx,autoclock
                 push           cs
                 pop            ds
                 mov            ax,251ch
                 int            21h
                 jmp            myclockend

clockoff:
                 cmp            clock_on,istrue
                 jnz            myclockend
                 mov            clock_on,isfalse
                 lds            dx,cs:nextint1ch
                 mov            ax,251ch
                 int            21h

myclockend:
                 popall
                 ret
asmclock         endp
my_text          ends
end
