/*********************************************
*                                            *
*      +-------------------------------+     *
*      |  Program..: Keybd_stat()      |     *
*      |  Syntax...: keybd_Stat(<exp>) |     *
*      +-------------------------------+     *
*                                            *
*         <exp>  -  <Keypressed>             *
*           0         Right-Shift            *
*           1         Left-Shift             *
*           2         Ctrl                   *
*           3         Alt                    *
*           4         Scroll                 *
*           5         Num                    *
*           6         Caps                   *
*           7         Ins                    *
*                                            *
**********************************************/


#include "c:\clipper5\include\extend.h"
#include <stdio.h>


#define KEY_STAT   0x417  /* Current keybd status bits. */


CLIPPER keybd_stat()
{
    /* Input and return Parameters */

    int p_look;
    int p_return;

    /* Mempeek hold an integer from anywhere in memory. */

    unsigned far *mempeek;

    if (ISNUM(1))
    {
        p_look  = _parni(1);
    }
    else
    {
        p_look  = 0;
    }

    /* Look at appropriate area based on what was asked for */

    if (p_look != -1)
    {
        mempeek = (int *) KEY_STAT;
        p_return = ((( *(mempeek) >> p_look) & 1) ? 1:0);
    }
    else
    {
        p_return = -1;
    }

    _retni(p_return);

}
/* eof alt.c */
