//͸
//  Program .....: Winbox                                
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

**
* Function...: WinBox
* Syntax.....: WinBox(<exp1>,<exp2>,<exp3>,<exp4>,<exp5>,<exp6>,<exp7>,<exp8>)
*
*          <exp1>  ..  <exp4>  ===  Border Coordinates  numeric
*                <exp5>        ===  Delay factor numeric
*                <exp6>        ===  Number (1 .. 5) or Character string
*                <exp7>        ===  .t. ,.f. for shadow
*                <exp8>        ===  .t. ,.f. for explode
**

static Screen := {}

Function WinBox(t, l , b, r, delay, frame, shadow, explode)

   local nRow := row(), nCol := Col()


   t := if( t == NIL, 0       , t )
   l := if( l == NIL, 0       , l )
   b := if( b == NIL, maxrow(), b )
   r := if( r == NIL, maxcol(), r )
   shadow  := if( shadow == NIL, .f., shadow )
   explode := if( explode == NIL, .f., explode )
   delay   := if( delay == NIL, 0.02, delay )
   frame   := if( frame == NIL, 1, frame )

   delay := 0.00
   if explode
     explode(t, l, b, r, delay, frame)
   else
     pop(t, l, b, r, frame)
   endif

   if valtype(shadow) = 'L'
     if shadow .and. b < maxrow() .and. r < maxcol()-1
       shadow(t, l, b, r)
     Endif
   Endif

   setpos( nRow, nCol )

Return( if(explode,len( Screen ),NIL) )


STATIC Function pop(a_1,a_2,a_3,a_4,a_5)

    local a_box


    if valtype(a_5) = 'N'
      if     a_5 == 1
        a_box := 'Ŀ '
      elseif a_5 == 2
        a_box := 'ͻȺ '
      elseif a_5 == 3
        a_box := 'ķӺ '
      elseif a_5 == 4
        a_box := '͸Գ '
      elseif a_5 == 5
        a_box := ' '
      endif
    else
      a_box := a_5
    endif

    @a_1,a_2,a_3,a_4 box a_box

Return( NIL )


STATIC Function explode(t,l,b,r,delay,frame)

    local i                        , ;
          startrow                 , ;
          startcol                 , ;
          t1                       , ;
          l1                       , ;
          b1                       , ;
          r1                       , ;
          a_Box                    , ;
          x                        , ;
          delayflag := 1           , ;
          row := row()             , ;
          col := col()



    delay := if(delay == NIL, 0.05, delay )
    frame := if(frame == NIL, 1, frame )

    if valtype(frame) = 'N'
      if     frame == 1
        a_box := 'Ŀ '
      elseif frame == 2
        a_box := 'ͻȺ '
      elseif frame == 3
        a_box := 'ķӺ '
      elseif frame == 4
        a_box := '͸Գ '
      elseif frame == 5
        a_box := ' '
      endif
    else
      a_box := frame
    endif

    aadd(screen, str(t,2) + str(l,2) + str(b+1,2) + str(r+2,2) + str(delay,4,2) + ;
                 if(valtype(frame)=='N', str(frame,9),pad(frame,9,' ') ) + ;
                 savescreen(t,l,b+1,r+2) ;
        )

    startrow := t+int((b-t)/2)
    startcol := l+int((r-l)/2)

    t1 := startrow
    l1 := startcol
    b1 := startrow
    r1 := startcol

    while .t.
      t1 := if( t1 > t , max(t,t1-1), t )
      l1 := if( l1 > l , max(l,l1-2), l )
      b1 := if( b1 < b , min(b,b1+1), b )
      r1 := if( r1 < r , min(r,r1+2), r )

      @t1,l1,b1,r1 box a_box

      if delayflag == 1
        x := seconds()+delay
        while seconds() < x ; end
        delayflag := 0
      endif
      delayflag++

      if t1 == t .and. l1 == l .and. b1 == b .and. r1 == r
        exit
      endif

    enddo

    setpos( row,col )

Return( NIL )


Function implode( winHandle )

    local i                        , ;
          stoprow                  , ;
          stopcol                  , ;
          t                        , ;
          l                        , ;
          b                        , ;
          r                        , ;
          t1                       , ;
          l1                       , ;
          b1                       , ;
          r1                       , ;
          delay                    , ;
          frame                    , ;
          a_box                    , ;
          x                        , ;
          delayflag := 1           , ;
          row := row()             , ;
          col := col()


    if winHandle == NIL .or. winHandle < 1 .or. winHandle > len(screen) .or. ;
       screen[winHandle] == NIL
      Return( NIL )
    endif

    t     := val(subs(screen[winHandle],1,2))
    l     := val(subs(screen[winHandle],3,2))
    b     := val(subs(screen[winHandle],5,2))
    r     := val(subs(screen[winHandle],7,2))
    delay := val(subs(screen[winHandle],9,4))
    frame := subs(screen[winHandle],13,9)
    frame := if(val(frame) == 0, frame, val(frame) )

    if valtype(frame) = 'N'
      if     frame == 1
        a_box := 'Ŀ '
      elseif frame == 2
        a_box := 'ͻȺ '
      elseif frame == 3
        a_box := 'ķӺ '
      elseif frame == 4
        a_box := '͸Գ '
      elseif frame == 5
        a_box := ' '
      endif
    else
      a_box := frame
    endif

    stoprow := t+int((b-t)/2)
    stopcol := l+int((r-l)/2)

    t1 := t
    l1 := l
    b1 := b
    r1 := r

    while .t.
      restscreen(t,l,b,r,subs(screen[winHandle],22))
      t1 := if( t1 > stoprow , stoprow, min(stoprow,t1+1) )
      l1 := if( l1 > stopcol , stopcol, min(stopcol,l1+2) )
      b1 := if( b1 < stoprow , stoprow, max(stoprow,b1-1) )
      r1 := if( r1 < stopcol , stopcol, max(stopcol,r1-2) )

      @t1,l1,b1,r1 box a_box

      if delayflag == 1
        x := seconds()+delay
        while seconds() < x ; end
        delayflag := 0
      endif
      delayflag++

      if t1 == stoprow .and. l1 == stopcol .and. b1 == stoprow .and. r1 == stopcol
        exit
      endif

    enddo

    restscreen(t,l,b,r,subs(screen[winHandle],22))

    screen[winHandle] := NIL
    if winHandle == len( screen )
      adel( screen, winHandle )
      asize( screen, winHandle - 1 )
    endif
    setpos( row,col )

Return( NIL )
