//͸
//  Program .....: Nccvwdbf                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
// Class dViewDBF 
//


#include "class(y).ch"
#include "inkey.ch"
#include "Nccview.ch"
#include "dbstruct.ch"

#define MAX_LN_LEN  250
#define FORWARD     1
#define BACKWARD   -1


    create class dViewDBF  from NccViewit                //

       instvar  HeadLine                                 //
       instvar  TopLine                                  //
       instvar  CompiledLine                             //
       instvar  PositionChanged                          //
       instvar  Width                                    //
       instvar  cCount                                   //
       instvar  LastFieldDisplayed                       //

       method   BuildLine                                //
       method   LineFill                                 //


     export:

       instvar  Head
       instvar  HeadSep
       instvar  ColSep
       instvar  LeftPosition                             //
       instvar  Structure                                //
       instvar  Headings                                 //
       instvar  WorkArea

       method   Left            =  dvbLeft               //
       method   Right           =  dvbRight              //
       method   PanEnd                                   //
       method   PanHome                                  //
       method   Activate                                 //
       method   StandardKeys                             //
       method   RefreshAll                               //

       method   RecInfo                                  //
       method   DBFline                                  //

    EndClass



    constructor new( top, left, bottom, right, xWorkArea ), ;
                new( top, left, bottom, right )

       local y := {}, x, hold1, hold2

       hold1 := Select()
       Select ( xWorkArea )
       x := dbstruct()
       Select ( hold1 )

       aeval( x, {|a| aadd(y, a[DBS_NAME]) } )

       ::LeftPosition        :=  1
       ::Head                :=  ""
       ::HeadSep             :=  ""
       ::ColSep              :=  ""
       ::HeadLine            :=  ''
       ::TopLine             :=  ''
       ::CompiledLine        :=  ''
       ::PositionChanged     :=  .f.
       ::Width               :=  0
       ::cCount              :=  0
       ::LastFieldDisplayed  :=  .f.
       ::Structure           :=  x
       ::Headings            :=  y
       ::workarea            :=  if( xWorkArea == NIL, Select(), xWorkArea )

       ::DataBlock           :=  { |lDisplay| ::DBFline(lDisplay) }
       Hold1                 :=  ::super:SkipBlock
       ::SkipBlock           :=  { |n,x,y| y := Select()             , ;
                                           dbSelectar( ::workarea )  , ;
                                           x := eval(Hold1,n)        , ;
                                           dbSelectar( y )           , ;
                                           x := x                      ;
                                 }
       Hold2                 :=  ::StatusBlock
       ::StatusBlock         :=  { |n| if(::CurrentStatus # DVIEW_REFRESHING, ;
                                            ::RecInfo(),'' ;
                                         ), ;
                                         eval(hold2,n) ;
                                 }
       ::super:UseStyle      :=  .t.

Return


    //Ŀ
    // Activate 
    //
    method procedure activate

    local xArea := Select()


    Select ( ::workarea )
    ::PositionChanged := .t.
    ::BuildLine( FORWARD )
    ::super:Activate()
    Select ( xArea )

Return


    //Ŀ
    // StandardKeys 
    //
    method Function StandardKeys( nKey )

    local lProcessed := .t., xArea := select()

    nKey := if( valtype(nKey) # 'N', 0, nKey )

    Do Case
      Case nKey == K_LEFT;       ::Left()
      Case nKey == K_RIGHT;      ::Right()
      Case nKey == K_CTRL_HOME;  ::PanHome()
      Case nKey == K_CTRL_END;   ::PanEnd()
      Otherwise;                 lProcessed := ::super:StandardKeys( nKey )
    EndCase

Return( lProcessed )


    //Ŀ
    // Refresh browse 
    //
    method procedure RefreshAll

    local xArea := Select()


    Select ( ::workarea )
    ::PositionChanged := .t.
    ::BuildLine( FORWARD )
    ::super:RefreshAll()
    Select ( xArea )

return


    //Ŀ
    // Move Left 
    //
    method procedure dvbLeft

    local xArea := Select()


    Select ( ::workarea )
    IF ::LeftPosition # 1 .or. ::PositionChanged
      if ::LeftPosition # 1
        ::LeftPosition--
      end
      ::PositionChanged := .t.
      ::BuildLine( FORWARD )
      ::super:RefreshAll()

    ELSE
     ::RefreshCurrent()

    END
    Select ( xArea )

Return


    //Ŀ
    // Move Right 
    //
    method procedure dvbRight

    local xArea := Select()


    Select ( ::workarea )
    IF ::LeftPosition # len( ::Structure ) .and. ! ::LastFieldDisplayed
      if ::LeftPosition # len( ::Structure )
        ::LeftPosition++
      endif
      ::PositionChanged := .t.
      ::BuildLine( FORWARD )
      ::super:RefreshAll()

    ELSE
     ::RefreshCurrent()

    END
    Select ( xArea )

Return


    //Ŀ
    // Pan End 
    //
    method procedure PanEnd

    local xArea := Select()


    Select ( ::workarea )
    IF ::LeftPosition # len( ::Structure ) .and. ! ::LastFieldDisplayed
      ::LeftPosition++
      ::PositionChanged := .t.
      ::LeftPosition := ::BuildLine( BACKWARD )
      ::BuildLine( FORWARD )
      ::super:RefreshAll()

    ELSE
     ::RefreshCurrent()

    END
    Select ( xArea )

Return


    //Ŀ
    // Pan Home 
    //
    method procedure PanHome

    local xArea := Select()


    Select ( ::workarea )
    if ::LeftPosition # 1 .or. ::PositionChanged
      ::LeftPosition := 1
      ::PositionChanged := .t.
      ::BuildLine( FORWARD )
      ::super:RefreshAll()

    ELSE
     ::RefreshCurrent()

    Endif
    Select ( xArea )

Return


    //Ŀ
    // Build Line 
    //
    method Function BuildLine( nDirection )

    LOCAL loop_start, loop_end, loop_step, i, ;
          xbeg, xend, s_len, x_len, right, left, dh, df
    local xArea := Select()


    Select ( ::workarea )

    right    := ::RightColumn
    left     := ::LeftColumn

    IF nDirection == 1
      loop_start := ::LeftPosition
      loop_end   := len( ::Structure )
      loop_step  := 1

    ELSE
      loop_start := len( ::Structure )
      loop_end   := 1
      loop_step  := -1

    END

    ::CompiledLine := ""
    ::HeadLine     := ''
    ::TopLine      := ''
    ::Width        := 0
    ::cCount       := 0

    For i = loop_start to loop_end step loop_step

      dh  := ::Headings[i]
      dF  := ::Structure[i,DBS_NAME]

      x_len := max(if( ::Structure[i,DBS_TYPE] == 'L',;
                       ::Structure[i,DBS_LEN]+2,;
                       ::Structure[i,DBS_LEN];
                     ),;
                     len(dh);
                  )

      IF ::Width + x_len + len( ::ColSep ) > right-left+1 .and. ;
         ! empty(::CompiledLine)
        i--
        exit

      END

      xbeg := ''
      xend := ''

      IF x_len > ::Structure[i,DBS_LEN]
        xbeg  := "padr("
        s_len := ltrim(str(x_len))
        xend  := ","+s_len+",[ ])"

      END

      DO CASE
        CASE ::Structure[i,DBS_TYPE] == 'M'

          IF len(::CompiledLine) + len(xbeg+"[  <memo>  ]"+xend) > MAX_LN_LEN
            i--
            exit

          END

           ::LineFill(x_len, dh, nDirection)

          IF nDirection == 1
            ::CompiledLine += xbeg + "dvb_m()" + xend

          ELSE
            ::CompiledLine := xbeg + "dvb_m()" + xend + ::CompiledLine

          END

        CASE ::Structure[i,DBS_TYPE] == 'N'

          IF len(::CompiledLine) + len(xbeg + "str(" + dF + ")" + xend) > MAX_LN_LEN
            i--
            exit

          END

          ::LineFill(x_len, dh, nDirection)

          IF nDirection == 1
            ::CompiledLine += xbeg + "dvb_s(" + dF + ")" + xend

          ELSE
            ::CompiledLine := xbeg + "dvb_s(" + dF + ")" + xend + ::CompiledLine

          END

        CASE ::Structure[i,DBS_TYPE] == 'D'

          IF len(::CompiledLine) + len(xbeg + "dtoc(" + dF + ")" + xend) > MAX_LN_LEN
            i--
            exit

          END

          ::LineFill(x_len, dh, nDirection)

          IF nDirection == 1
            ::CompiledLine += xbeg + "dvb_d(" + dF + ")" + xend

          ELSE
            ::CompiledLine := xbeg + "dvb_d(" + dF + ")" + xend + ::CompiledLine

          END

        CASE ::Structure[i,DBS_TYPE] == 'L'

          IF len(::CompiledLine) + len(xbeg + "if(" + dF + ",'.T.','.F.')" + xend) > MAX_LN_LEN
            i--
            exit

          END

          ::LineFill(x_len, dh, nDirection)

          IF nDirection == 1
            ::CompiledLine += xbeg + "dvb_l(" + dF + ")" + xend

          ELSE
            ::CompiledLine := xbeg + "dvb_l(" + dF + ")" + xend + ::CompiledLine

          END

        OTHERWISE

          IF len(::CompiledLine) + len(xbeg + dF + xend) > MAX_LN_LEN
            i--
            exit

          END

          ::LineFill(x_len, dh, nDirection)

          IF nDirection == 1
            ::CompiledLine += xbeg + dF + xend

          ELSE
            ::CompiledLine := xbeg + dF + xend + ::CompiledLine

          END

      END

      ::cCount := 1

    NEXT

    ::TopLine := padr(subs(::TopLine,1,len(::TopLine)-(len(::HeadSep))), ;
                 ::RightColumn-::LeftColumn + 1, ::Head )

    Select ( xArea )

    IF nDirection == 1
      ::LastFieldDisplayed  := ( i >= len(::Structure) )
      ::CompiledLine  := &("{ || " + ::CompiledLine + "}")

    ELSE
      ::LastFieldDisplayed := .t.
      Return( i+2 )

    END


Return( NIL )


    //Ŀ
    // Line Filler 
    //
    method procedure LineFill(x_len, dh, nDirection)

    local left, right
    right := ::RightColumn
    left  := ::LeftColumn

    ::Width += x_len

    IF nDirection = 1
      ::HeadLine += padr(dh,min(x_len,right-left+1),' ')+;
                        if(x_len >=right-left+;
                        len( ::ColSep ),'',space( len( ::ColSep ) ))
      ::TopLine  += padr(::Head,min(x_len,right-left+1),::Head)+;
                        if(x_len >=right-left+;
                        len( ::HeadSep ),'',::HeadSep)

      IF ::cCount # 0
        ::CompiledLine += "+[" + ::ColSep + "]+"
        ::Width        += len( ::ColSep )

      END

    ELSE
      ::HeadLine := padr(dh,min(x_len,right-left+1),'-')+;
                        if(x_len >=right-left+;
                        len( ::HeadSep ),'',space( len( ::HeadSep ) ))+;
                         ::HeadLine
      ::TopLine  := padr(::Head,min(x_len,right-left+1),::Head)+;
                        if(x_len >=right-left+;
                        len( ::HeadSep ),'', ::HeadSep )+ ::TopLine

      IF ::cCount # 0
         ::CompiledLine := "+[" + ::ColSep + "]+" + ::CompiledLine
         ::Width        += len( ::ColSep )

      END

    END

Return


    //Ŀ
    // Display Line 
    //
    method Function DBFline(lDisplay)

    LOCAL xh, xArea := select(), xRec := recno()

    Select ( ::workarea )
    xh := setcolor()
    IF ::PositionChanged

      @ ::TopRow-2, ::LeftColumn say ;
         padr(::HeadLine, ::RightColumn - ::LeftColumn + 1, ' ')
      @ ::TopRow-1, ::LeftColumn say ;
         replicate(::Head,::RightColumn-::LeftColumn+1)

      ::PositionChanged := .f.

      @ ::TopRow-1,::LeftColumn say ::TopLine
      setcolor(xh)
      setpos( ::CurrentRow, ::LeftColumn )

    END

    if ! lDisplay
      dbGoBottom()
      dbSkip(1)
    endif

    @ ::CurrentRow, ::LeftColumn say ;
     padr(eval( ::CompiledLine ), ::RightColumn - ::LeftColumn + 1, ' ')

    dbGoto( xRec )

    Select ( xArea )

Return( '' )


    //Ŀ
    // Record Info 
    //
    method procedure RecInfo

    LOCAL xh := setcolor()
    local xArea := Select()


    Select ( ::workarea )

    NccMesg(if(deleted(),'Deleted',space(9)),;
         ::TopRow-3,'center,'+str(::LeftColumn)+','+str(::RightColumn)+['];
        )

    IF recno() > reccount()
      @ ::TopRow-3, ::LeftColumn     say space(18)
      @ ::TopRow-3, ::RightColumn-6  say " Empty "

    ELSE
      @ ::TopRow-3, ::LeftColumn     say ;
       'Record:'+padr(ltrim(str(recno(),5))+'/'+ltrim(str(reccount(),5)),11,' ')

    END

    setcolor(xh)

    IF ::LeftPosition # 1
      @ ::TopRow-1, ::LeftColumn say ''

    END

    IF ::LeftPosition # len( ::Structure ) .and. ! ::LastFieldDisplayed
      @ ::TopRow-1, ::RightColumn-1 say ''

    END
    Select ( xArea )

Return


    //Ŀ
    // Memo item 
    //
    Function dvb_m()
Return( if(eof(), space(10), [  <memo>  ]) )


    //Ŀ
    // String item 
    //
    Function dvb_s(x_d)
Return( if(eof(), space(len(Str(x_d))), str(x_d)) )


    //Ŀ
    // Logical item 
    //
    Function dvb_l(x_d)
Return( if(eof(), space(3), if(x_d, [.T.],[.F.])) )


    //Ŀ
    // Date item 
    //
    Function dvb_d(x_d)
Return( if(eof(), space(8), dtoc(x_d)) )
