//͸
//  Program .....: Nccscrvb                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
// Scroll Vertical Bar  
//

#include "class(y).ch"



    create class NccVBar

      instvar   Screen                          //
      instvar   Hidden                          //
      instvar   Current                         //

    export:

      instvar   TopRow                          //
      instvar   LeftColumn                      //
      instvar   BottomRow                       //
      instvar   nOnBar                          //
      instvar   RightColumn                     //
      instvar   Bar100                          //
      instvar   StandardColor                   //
      instvar   InverseColor                    //

      method    Hide                            //
      method    Show                            //
      method    Activate                        //
      method    Update                          //
      method    ReDraw                          //

    endclass


    constructor new( Top, Left, Bottom, Right, Bar100 )

    ::TopRow            :=  Top
    ::LeftColumn        :=  Left
    ::BottomRow         :=  Bottom
    ::RightColumn       :=  Right
    ::Bar100            :=  Bar100
    ::Hidden            :=  .t.
    ::Current           :=  0
    ::nOnBar            :=  0
    ::StandardColor     :=  Setcolor()
    ::InverseColor      :=  SetColor()

Return


    //Ŀ
    // Avtivate Bar 
    //
    method Function Activate( x )

    ::Show(x)

Return( NIL )


    //Ŀ
    // Show Bar 
    //
    method Function Show( x )

    if ! ::Hidden
      Return( NIL )
    endif

    ::Hidden := .f.
    ::Screen := savescreen( ::TopRow, ::LeftColumn, ::BottomRow, ::RightColumn )
    ::nOnBar := 0
    ::Update( x )

Return( NIL )


    //Ŀ
    // Hide Bar 
    //
    method procedure Hide

    if ::Hidden
      Return
    endif

    ::Hidden := .t.
    Restscreen( ::TopRow, ::LeftColumn, ::BottomRow, ::RightColumn, ::Screen )

Return


    //Ŀ
    // Redisplay Bar 
    //
    method procedure ReDraw

    ::nOnBar := 0
    ::Update()

Return


    //Ŀ
    // Update bar 
    //
    method Function Update( x )

    local i, where, cColor := SetColor(), row := row(), col := col()

    if x == NIL
      x := ::current
    else
      ::current := x
    endif

    if ::Hidden
      Return( NIL )
    endif

    if x <= 1
      where := 1
    elseif x >= ::Bar100
      where := ( ::BottomRow - ::TopRow -1 )
    else
      where := max(1, int( ( x * ( ::BottomRow - ::TopRow -1 ) )/ ::Bar100 ))
    endif

    SetColor( ::StandardColor )

    DispBegin()
    if ::nOnBar == 0

      @ ::TopRow, ::RightColumn say ''
      for i = 1 to ( ::BottomRow - ::TopRow -1 )
        if i == where
          SetColor( ::InverseColor )
          @ ::TopRow + i, ::RightColumn say ''
          SetColor( ::StandardColor )
        else
          @ ::TopRow + i, ::RightColumn say ''
        endif
      Next
      @ ::BottomRow, ::RightColumn say ''

    elseif ::nOnBar # where

      @ ::TopRow + ::nOnBar, ::RightColumn say ''
      SetColor( ::InverseColor )
      @ ::TopRow + where   , ::RightColumn say ''

    endif
    DispEnd()
    ::nOnBar := where

    SetColor( cColor )
    setpos( row, col )

Return( NIL )
