//͸
//  Program .....: Nccmesg                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "set.ch"

**
* Function...: NccMesg()
* Syntax.....: NccMesg(<string>,<row>,<col>[,<color>][,<wait>][,<'bell'>][,<'save_scrn'>])
*              <col> - Column or "Center" or
*                      "Center,"+str(lc)+","+str(rc)+' " ' ==>- var? are string variables
*                      "Center,00,80"     ==> "center,00,80"
*              <color> - color variable
**

Function NccMesg( string, row, m_col, xcolor, xwait, xbell, xsave_scrn )

    local keypress, ret_color, check, tmp, cursor_stat, l_col, r_col


    string     := if(valtype(string)#'C','',string)
    row        := if(valtype(row)#'N',0,row)
    xbell      := if(valtype(xbell)#'C','',xbell)
    xsave_scrn := if(valtype(xsave_scrn)#'C','',xsave_Scrn)
    ret_color  := SETCOLOR()


    if UPPER(xsave_scrn) == "SAVE_SCRN"
      check := SAVESCREEN(row, 00, row, maxcol())

    Endif


    if UPPER(xbell) == "BELL"
      ?? Chr(7)

    Endif

    if xcolor # nil
      setcolor(xcolor)

    Endif

    if VALTYPE(m_col) == "N"
      @ row, m_col SAY string

    else
      if "CENTER" $ UPPER(m_col)
        if Len(m_col) > 6
          tmp   := 7 + AT(',', Substr(m_col,8))
          l_col := ltrim(Substr(m_col,8,tmp - 8))
          r_col := ltrim(Substr(m_col,tmp+1))
          if Substr(l_col,1,1) $ "0123456789"
            l_col  := Val(l_col)

          else
            l_col := 0

          Endif

          if Substr(r_col,1,1) $ "0123456789"
            r_col := Val(r_col)

          else
            l_col := maxcol()

          Endif

        else
          l_col := 0
          r_col := maxcol()

        Endif

        @ row, int(l_col+(r_col-l_col-min(r_col-l_col,LEN(string)))/2+.5) SAY ;
               subs(string,1,r_col-l_col)

      endif

    endif

    setcolor(ret_color)

    if VALTYPE(xwait) == 'N'
      cursor_stat := Set( _SET_CURSOR,0 )
      inkey(xwait)
      Set( _SET_CURSOR, cursor_stat )

    endif

    if UPPER(xsave_scrn) == "SAVE_SCRN"
      RESTSCREEN(row, 00, row, maxcol(), check)

    endif

Return( NIL )
