//͸
//  Program .....: Nccmemo                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

**
* Function...: NccMemo()
* Syntax.....: NccMemo(field,tr,tc,br,bc,"header","footer","line_width","key to save changes")
**

MEMVAR  tr,tc,br,bc,ins_on,xkey, ret_val

FUNCTION NccMemo(xField,tr,tc,br,bc,xHeader,xFooter,xWidth,xKey)
local xTemp,xMemo, ret_val

if PCOUNT() # 9
  Retu NIL
Endif

xmemo=savescreen(00,00,24,79)
WinBox(tr, tc, br, bc, 1, 2)
@ br-2, tc+1 SAY REPLICATE(CHR(196), bc - tc -1)
ins_on := .F.
RET_VAL := 0
if ! Empty(xHeader)
  NccMesg(xHeader, tr, "Center,tc,bc",2)

endif

if ! Empty(xFooter)
  NccMesg(xFooter, br,"Center,tc,bc",2)

Endif  

xtemp = MEMOEDIT(&xField., tr+1, tc+1, br-3, bc-1,.t.,"Ncc_e_memo",xWidth)

IF Ret_val = 23
  REPLACE &xField. WITH xTemp

ENDIF
restscreen(00,00,24,79,xMemo)

Retu NIL

*-*-*-*-*-*-*-*-*
Function Ncc_e_memo(mode, line, col)
local keypress,s_scrn, ret_val, ins_on

ret_val := 0
keypress := Lastkey()

if nextkey() = 0
  @ br-1,bc-19 say "Line: " + padr(ltrim(str(line)),4,' ')
  @ br-1,bc-8  say "Col: "  + padr(ltrim(str(col+1)),3,' ')
endif

Do Case
  Case mode = 3 .or. mode = 0
      ins_on := READINSERT()
      @ br-1,tc+1 say if(ins_on, "<Insert>   ", "<Overwrite>")

  Case keypress = 23
      * Ctrl-W...disable
      Ret_val := 32

  Case keypress = xkey
      *  Save key
      @ br-1,tc+1 say space(11)
      NccMesg("<Saving>",br-1,tc+1,3,1)
      Ret_val := 23

  Case keypress = 22
      * Ins
      ins_on := .not. ins_on
      @ br-1,tc+1 say if(ins_on, "<Insert>   ", "<Overwrite>")
      ret_val := 22

  Case keyPress = 27
      if mode = 1
        ret_val := 27
      else
        * Esc
        s_scrn := savescreen(br-1,tc+1,br-1,tc+1+11)
        @ br-1,tc+1 say space(11)
        NccMesg("Abort (Y/N)",br-1,tc+1,3)
        if keyExit("YN") = "Y"
          Ret_Val := 27
        else
          Ret_val := 32
        Endif
        restscreen(br-1,tc+1,br-1,tc+1+11,s_scrn)
      endif

EndCase

Return( ret_val )

