//͸
//  Program .....: Nccdir                                
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "Directry.ch"

Function DirPick(dfl, tr, lc)

    LOCAL xret, xm1, xm2, xmin, xzx, xfl


    xret := LoadDir(dfl, tr, lc)

    xm1 := at('*',dfl)
    xm2 := at('?',dfl)

    if ( xm1 # 0 .and. xm2 # 0 )
      xmin := min(xm1,xm2)

    elseif ( xm1 == 0 )
      xmin := xm2

    else
      xmin := xm1

    endif

    xzx := rat('\',dfl)

    if ( xzx # 0 )
      xmin := min(xmin,xzx+1)

    else
      xzx := rat(':',dfl)

      if ( xzx # 0 )
        xmin := min(xmin,xzx+1)

      else
        dfl := ''
        xmin := 1

      endif
    endif

    xret := subs(dfl,1,xmin-1) + xret
    if ( '<dir>' $ xret )
      if ! (':' $ xret)
        xret := '\' + xret

      endif

      if ( empty(dfl) )
        xret :=  '\'+curdir()+'\' + xret

      endif

      while ( ( xm1 := at( '\\', xret )) # 0 )
        xret := subs( xret, 1,xm1-1 ) + subs( xret, xm1+1 )
      enddo
      xmin := subs(xret,at('<dir>',xret)-1,1)
      xret := subs(xret,1,at('<dir>',xret)-1)
      if ( '..' $ xret )
        xm1  := RIGHT( xret, LEN( xret ) - RAT( "\", xret ) )
        xret := LEFT( xret, RAT( "\", xret ) - 1 )
        xret := LEFT( xret, RAT( "\", xret ) )
        if ( empty(xret) )
          xret := subs( dfl,1, at( ':', dfl ) )
        endif

      elseif ( '.' $ xmin )
        xret := subs(xret,1,len(xret)-1)

      else
        xret += '\'

      endif

      xret += '*.*'
      dfl  := xret

    endif

Return( xret )


STATIC Function LoadDir( v_str, tr, lc )

    LOCAL all_files, scrn, fx, fc, tst, ;
          x := 0, ;
          xs := 0, ;
          v_dir := {}


    tr := if(tr==NIL,04,tr)
    lc := if(lc==NIL,26,lc)

    all_files := directory(v_str,"D")

    if ( tst := len(all_files) ) # 0
      scrn := savescreen(tr,lc,min(maxrow()-4,10+tst),lc+32+2)
      WinBox(tr,lc,min(maxrow()-5,9+tst),lc+32,0,4,.t.)

      NccMesg('Loading files',-1+min(maxrow()-5,9+tst),"center,"+str(lc)+","+str(lc+32)+")")
      AEVAL(all_files, { |dbf_file| aadd(v_dir, padr(dbf_file[F_NAME],15)+ ;
                        IF( subs( dbf_file[F_ATTR],1, 1 ) == "D", "  <dir>    ", ;
                        padl(transform(dbf_file[F_SIZE], "99,999,999"),11)));
                        , x++ })

      NccMesg('Sorting files',-1+min(maxrow()-5,9+tst),"center,"+str(lc)+","+str(lc+32)+")")
      asort(v_dir)

      fc := ltrim(str(x))
      xs := arraydsp( ;
              v_dir,'Select a File','Number of Files: '+;
              fc,tr+3,lc+2,-3+min(maxrow()-5,9+tst),lc+32-3,0,0,,, ;
              { |o| dView_MouseReader(o,;
                       tr+3,lc+2,-3+min(maxrow()-5,9+tst),lc+32-3 ;
                                     )  ;
              } ;
                    )

      restscreen(tr,lc,min(maxrow()-4,10+tst),lc+32+2,scrn)

    endif

    if xs # 0
      Return( trim(subs(v_dir[xs],1,12)) + subs(v_dir[xs],18,5) )

    endif

Return( '' )
