/*
 * File......: POPUPCAL.PRG
 */

#include "inkey.ch"

#define K_MINUS    45
#define K_EQUAL    61
#define K_PLUS	   43
#define pDate	   "D"
#define pNumeric   "N"
#define pLogical   "L"
#define pArray	   "A"
#define pLine1a    "   " + CHR( 26 ) + " "
#define pLine1b    "Day"
#define pLine2a    "PgUp/PgDn"
#define pLine2b    "Month"
#define pLine3a    "  +   -"
#define pLine3b    "Year"
#define pLine4a    "   "
#define pLine4b    "Select Day"
#define pCalWidth  23  // Overall width of calendar, excluding shadow
#define pCalHeight 15  // Overall height of calendar, excluding shadow
#define pSBar	   "Ŀ"
#define pBold	   ""

// Set up manifest constants to access the window colors array
#define pC_Border  1   // Color of calendar border
#define pC_Title   2   // Color of month title
#define pC_DOW	   3   // Color of days of week header
#define pC_AnyDate 4   // Color of any unselected date
#define pC_SelDate 5   // Color of selected date
#define pC_InfoBox 6   // Color of info box
#define pC_PageBox 7   // Color of calendar page box
#define pC_Info    8   // Color of info text


//

FUNCTION NccCal()

LOCAL cOldColor := SETCOLOR(), cOldCursor := setcursor()
Local SCREEN2, nDate2

// SET ESCAPE ON
// SETCANCEL(.F.)
screen2 := SaveScreen( 02,00,24,79 )
// SETCOLOR( "W+/BG+")
nDate2 := NccCalend()
setcolor(cOldColor)
setcursor( cOldCursor )

RestScreen( 02,00,24,79,SCREEN2 )
RETURN( NIL )

**************************************************************

FUNCTION NccCalend(dInitDate,nTopRow,nLeftCol,lShadow,aColors)

#translate VALIDATE(<x>, <y>, <z>)  =>	;
	   IF( <x> = NIL, <z>, IF( VALTYPE(<x>) != <y>, <z>, <x> ))

LOCAL lExit	   := .f.
LOCAL lNewMonth    := .f.
LOCAL bChkMonth    := ;
	  {|D,nD|MONTH(D)==MONTH(D+nD) .AND. YEAR(D)==YEAR(D+nD)}
LOCAL nLastKey, dWorkDate, nLastDOM, cMonth, nFirstDOW
LOCAL nDay, nMonth, nYear, cYear, nScrn_loc, nDayNumber, cDay
LOCAL i, k

LOCAL aRow := {}, aCol := {}

dInitDate := VALIDATE( dInitDate, pDate,    NIL)
nTopRow   := VALIDATE( nTopRow,   pNumeric, NIL)
nLeftCol  := VALIDATE( nLeftCol,  pNumeric, NIL)
lShadow   := VALIDATE( lShadow,   pLogical, NIL)
aColors   := VALIDATE( aColors,   pArray,   NIL)

dInitDate := IF( dInitDate = NIL, DATE(), dInitDate)
lShadow   := IF( lShadow = NIL, .f., lShadow)

IF nTopRow = NIL

   nTopRow = IF(ROW() < MAXROW()/2, MAXROW()-pCalHeight-3, 3)
   ELSE
   nTopRow = IF(nTopRow > MAXROW()-pCalHeight-1, ;
		MAXROW()-pCalHeight-3, nTopRow)

ENDIF

IF nLeftCol = NIL

   nLeftCol = IF(COL() < MAXCOL()/2, MAXCOL()-pCalWidth-4, 2)
   ELSE
   nLeftCol = IF(nLeftCol > MAXCOL()-pCalWidth-2, ;
		 MAXCOL()-pCalWidth-4, nLeftCol)

ENDIF

IF !ISCOLOR()

   aColors := { 'W/N', 'W+/N', 'W/N', 'N/W', 'W+/N', 'N/W', ;
		   'N/W', 'W/N' }
   ELSE

   IF aColors = NIL

       aColors := { 'RB/B', 'W+/B', 'W/B', 'W+/N+', 'W+/BG+',;
		    'W+/N+','W/N+', 'W/B' }

   ENDIF

ENDIF

dWorkDate  := dInitDate  // hold the calling date in case user
			 // escapes from this routine.

// define X/Y coordinates of calendar proper


FOR k = 1 TO 6

   FOR i = 1 TO 7

      AADD( aRow, k + nTopRow + 3)    // First row is nTopRow + 4
      AADD( aCol, (3*i-1) + nLeftCol) // First col is nLeftCol + 3

   NEXT

NEXT

// Draw Background calendar
DISPBEGIN()    // Use this function to "snap" the calendar
	       // onto the screen
SETCOLOR( aColors[pC_Info] )

WinBox(nTopRow, nLeftCol, nTopRow+pCalHeight, nLeftCol+pCalWidth,,5,.t.)


// @ nTopRow,nLeftCol CLEAR TO nTopRow+pCalHeight,nLeftCol+pCalWidth

@ nTopRow+11,nLeftCol+12 SAY pLine1b
@ nTopRow+12,nLeftCol+12 SAY pLine2b
@ nTopRow+13,nLeftCol+12 SAY pLine3b
@ nTopRow+14,nLeftCol+12 SAY pLine4b

// boxshadow( nTopRow, nLeftCol, nTopRow+pCalHeight,nLeftCol+pCalWidth )

SETCOLOR( aColors[pC_DOW] )
@ nTopRow+3,nLeftCol+3 SAY "S M  T  W  T  F  S" // days of the week

SETCOLOR( aColors[pC_InfoBox] )
@ nTopRow+11,nLeftCol+2 CLEAR TO nTopRow+14,nLeftCol+10
@ nTopRow+11,nLeftCol+2 SAY pLine1a
@ nTopRow+12,nLeftCol+2 SAY pLine2a
@ nTopRow+13,nLeftCol+2 SAY pLine3a
@ nTopRow+14,nLeftCol+2 SAY pLine4a

SETCOLOR( aColors[pC_Border] )
@ nTopRow, nLeftCol, nTopRow+pCalHeight, nLeftCol+pCalWidth BOX pBold
@ nTopRow+2, nLeftCol+1, nTopRow+10, nLeftCol+pCalWidth-1   BOX pSBar

DISPEND()

// Start of major program loop
DO WHILE !lExit

   // Day, Month, Year, first day, last day of month data

   nMonth     := MONTH(dWorkDate)
   nYear      := YEAR(dWorkDate)
   cYear      := STR(nYear)
   nDay       := DAY(dWorkDate)
   nLastDOM   := _FTLASTDAY(nMonth,nYear) // the day number of the
				       // last day in this month
   nFirstDOW  := DOW(CTOD(STR(nMonth,2)+'/01/'+cYear))
   nDayNumber := 0

   IF !lNewMonth // Redraw calendar if MORE than a day select occurs.

      SETCOLOR( aColors[pC_Title] )
      cMonth := CMONTH(dWorkDate) + ' ' + cYear
      @ nTopRow+1,nLeftCol+1 SAY SPACE(pCalWidth-2)
      @ nTopRow+1,nLeftCol+1 SAY SPACE((pCalWidth-LEN(cMonth))/2)+cMonth

      SETCOLOR( aColors[pC_PageBox] )
      @ nTopRow+4,nLeftCol+2 CLEAR TO nTopRow+9,nLeftCol+pCalWidth-2

   ENDIF

   DISPBEGIN()	// If key response is an issue (on slow machines)
		// remove this function.  With it in, the changes
		// "snap" onto the screen, but it does slightly
		// delay response.
   SETCOLOR( aColors[pC_AnyDate] )
   FOR nScrn_loc = nFirstDOW TO (nFirstDOW + nLastDOM - 1)

      cDay = STR(++nDayNumber,2)

      IF nDayNumber = DAY(dWorkDate) // Test for selected date &
				     // change color

	   SETCOLOR( aColors[pC_SelDate] )
	   @ aRow[nScrn_loc],aCol[nScrn_loc] SAY cDay
	   SETCOLOR( aColors[pC_AnyDate] )
	   LOOP

      ENDIF

      @ aRow[nScrn_loc],aCol[nScrn_loc] SAY cDay

   NEXT
   DISPEND()

   DO WHILE .T.  // Use this loop to prevent nonsense keys
		 // from redrawing the calendar.

     INKEY(0)
     nLastKey  := LASTKEY()
     lNewMonth := .F.  // Assume that user will change calendar month

     DO CASE

       CASE nLastKey == K_RIGHT 	// increase by one day
	 lNewMonth := EVAL(bChkMonth,dWorkDate,1)
	 dWorkDate++

       CASE nLastKey == K_LEFT		// decrease by one day
	 lNewMonth := EVAL(bChkMonth,dWorkDate,-1)
	 dWorkDate--

       CASE nLastKey == K_UP		// increase by seven days
	 lNewMonth := EVAL(bChkMonth,dWorkDate,-7)
	 dWorkDate := dWorkDate-7

       CASE nLastKey == K_DOWN		// decrease by seven days
	 lNewMonth := EVAL(bChkMonth,dWorkDate,7)
	 dWorkDate := dWorkDate+7

       CASE nLastKey == K_HOME		// Home key
	 dWorkDate := DATE()

       CASE nLastKey == K_ESC .OR. nLastKey == K_ENTER // Exit
	 lExit := .T.

       CASE nLastKey == K_PGUP		// page-up key	- back one month
	 nMonth--

	 IF nMonth < 1
	   nMonth := 12
	   nYear--
	 ENDIF

	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear)

       CASE nLastKey == K_MINUS 	// " - " - back one year
	 dWorkDate := _FTMAKDATE(nMonth,nDay,--nYear)

       CASE nLastKey == K_PGDN		// page-down key - ahead one month

	 IF ++nMonth > 12
	   nMonth := 1
	   nYear++
	 ENDIF

	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear)

       CASE nLastKey == K_EQUAL .OR. nLastKey == K_PLUS
					// "= " - ahead one year
	 dWorkDate := _FTMAKDATE(nMonth,nDay,++nYear)

       OTHERWISE
	 LOOP

     ENDCASE

     EXIT

   ENDDO

ENDDO

// Let's get out of here!

// return the date the user selected, or the calling date
// if user exited with Escape.

RETURN IF(nLastKey==K_ESC,dInitDate,dWorkDate)

/*************
*
*   Function _FTLASTDAY --> Returns last day of month as an integer
*/

STATIC FUNCTION _FTLASTDAY(nMonth,nYear)
LOCAL nLastDate

nLastDate := CTOD(STR(nMonth,2)+'/27/'+STR(nYear))

DO WHILE nMonth == MONTH(++nLastDate)
ENDDO

RETURN DAY(--nLastDate)

/*************
*
*    Function _FTMAKDATE --> Returns date as a string
*
*
*  Receives integers of the month day and year and returns
*  a composite date.
*  If day in month is greater than the true numbers in the
*  month it returns the last day.
*/

STATIC FUNCTION _FTMAKDATE(nMonth,nDay,nYear)
LOCAL dDate

dDate := CTOD(STR(nMonth,2)+'/'+STR(nDay,2)+'/'+STR(nYear))

IF dDate == CTOD(" / / ")
   dDate := CTOD(STR(nMonth,2)+'/'+STR(_FTLASTDAY(nMonth,nYear),2)+ ;
	     '/'+STR(nYear))
ENDIF

RETURN (dDate)
