//͸
//  Program .....: Get_str                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

***
* Function...: get_str()
* Syntax.....: <var> := get_str([<exp1>][,<exp2>][,<exp3>])
*               ....Simulate a READ
*             <exp1> - Number of Characters to Read...default 10
*             <exp2> - Type of input to accept...eg. [N]umeric [A]lpha [F] Dos File...default is all ['']
*             <exp3> - Display input...'S'...default is to hide
***

#include "inkey.ch"

Function get_str(num, c_type, to_echo)

    local az, ztest, sr, sc, xc, xr, stop, start, i


    ztest := ""

    xr := row()
    xc := col()
    sr := xr
    sc := xc
    start := .T.

    if valtype(num) # 'N'
      num := 10                   && Default Max = 10

    endif

    if c_type == NIL
        c_type := ""           && Accept All

    elseif Empty(c_type)
        c_type := ""           && Accept All

    endif

    if to_echo == NIL
      to_echo := ""               && Hide

    endif

    STOP := sc + num - 1          && Visual Stop

    Do While .T.
      az := inkey(0)

      Do Case
        Case az < 1 .or. az > 255
            LOOP

        Case Chr(az) $ chr(22)+chr(7)+chr(4)+chr(3)+chr(24)+chr(6)+chr(1)+chr(5)+chr(18)+chr(19)+chr(9)
            LOOP

        Case az == K_ESC
            ztest := ''
            exit

        Case az == K_ENTER
            exit

        Case az == K_BS

            xc := MAX(sc, xc)
            @ xr, xc say ' '
            @ xr, xc say ''

            if xc > sc
              xc--
            else
              start := .T.
            Endif

            if xc - sc < num           && Backspace
              ztest := subs(ztest, 1, len(ztest) - 1)

            Endif

        Otherwise

          if len(ztest) < num                 && accept only required string length

            if type_chk(az, c_type)
              if start
                start := .F.

              elseif xc < STOP
                xc++

              Endif

              ztest += CHR(az)

              if ! EMPTY(to_echo) .and. UPPER(to_echo) == 'S'
                @ xr, xc say Chr(az)

              else
                @ xr, xc say "*"

              endif

            endif

         endif

      EndCase

    Enddo

    @ sr, sc-1 say ''

Return( ztest )


**
* Function...: Type_chk()
* Syntax.....: Type_chk(<exp1>,<exp2>)
*              Checks if <exp1> is of type <exp2>
**

STATIC Function type_chk(var, chk_type)

    Do Case
      Case UPPER(chk_type) == "N"                  // 0..9
        Return( chr(var) $ '0123456789' )

      Case UPPER(chk_type) == "A"                  // a..z,  A..Z, _, space
        Return( (var >= 65 .and. var <= 90) .or. ;
                (var >= 97 .and. var <= 122) .or. ;
                 var = 32 .or. var = 95 ;
              )

      Case UPPER(chk_type) == "F"                  // a..z,  A..Z, _, 0123456789
        Return( (var >= 65 .and. var <= 90) .or. ;
                (var >= 97 .and. var <= 122) .or. ;
                 var = 95 .or. chr(var) $ '0123456789' ;
              )

      Case Empty(chk_type)                         // All
        Return( .T. )

      Otherwise                                    // ???
        Return( .F. )

    EndCase

Return( NIL )
