//͸
//  Program .....: G_Index                               
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "set.ch"
#include "inkey.ch"
#include "fileio.ch"


#define BUFFER   250


//Ŀ
// Recreate Index file 
//

Function g_indexOne()

    local xh := setcolor(), nSel := 0, scrn := savescreen(), lscrn, ;
          n := WinIndexFiles(), xTop, refresh := .f.


    setColor( popup_color() )

    xTop := int(((maxrow()/2) - 4 ))

    While .t.
      nSel := arraydsp( n, ;
                       'Select index file to recreate', ;
                       '.' ;
                       ,xTop,04,xTop+09,71, ;
                       nSel, ;
                       min( 9, if(nSel==0,0,nSel-1)), ;
                       .t., ;
                       , ;
                       { |o| NccMesg( space(67), o:BottomRow+2,'center'), ;
                             NccMesg( ltrim(trim(indexkey(o:CurrentItem))),;
                                   o:BottomRow+2, 'center,04,71' ), ;
                             dView_MouseReader(o,xTop,04,xTop+09,71) ;
                       } ;
                      )
      if nSel == 0
        exit
      endif

      lscrn := savescreen( xTop+11,3,xTop+15,75 )
      if indexcreate( n[nSel], indexkey(nSel) )
        AttachIndexFiles( n )
        refresh := .t.
      endif
      restscreen( xTop+11,3,xTop+15,75,lscrn )

    enddo
    restscreen(,,,,scrn)
    setcolor( xh )
    WinObj():Refresh := refresh

Return( NIL )


//Ŀ
// Recreate Index files 
//
Function g_reindex()

    local n := winIndexFiles(), i, nx := {}, o, scrn := savescreen(), ;
          xh := setcolor(), xTop, GetList := {}, Mouse := MouseSys()


    for i = 1 to len(n)
      aadd( nx, ltrim(trim(indexkey(i))) )
    next

    set inde to

    xTop := int(((maxrow()/2) - 1 ))

    setcolor( popup_color() )
    WinBox(xTop,03,xTop+7,73,0,4,.t.)
    o := NccViewit():New( xTop+1, 04, xTop+6, 72 )
    o:userslot    := 1
    o:StatusBlock := { || "" }
    o:datablock   := { || n[ o:userslot ] }
    o:whileblock  := { || o:userslot <= len(n) }
    o:Skipblock   := { |n| skipper(o,n) }

    o:Activate()

    set inte off

    for i = 1 to len(n)
      keyboard chr(K_ENTER)
      indexcreate(n[i],nx[i])
      if inkey() == K_ESC
        keyboard ''
        ?? chr(7)
        setcolor( message_color() )
        @maxrow(),00
        xTop := ' '
        @maxrow(),00 say 'Abort rest of index files (Y/N) ' Get xTop ;
                                                            pict '!' ;
                                                            valid xTop $ 'YN'
        Set Cursor On
        Read
        Set Cursor Off
        setcolor( popup_color() )
        if lastkey() # K_ESC .and. xTop == 'Y'
          Exit
        else
          @maxrow(),00 say space(maxcol()+1) color message_color()
        endif
      endif
      if i # len(n)
        o:Down()
      endif
    next

    set inte on

    AttachindexFiles( n )
    ?? chr(7)
    @maxrow(),00 say padc('Press any key ...', maxcol()+1, ' ' ) color message_color()

    Mouse:ClearButtons()
    Mouse:Show()
    While Mouse:Button == 0 .and. Mouse:Ascii == 0
      Mouse:Update()
    Enddo
    Mouse:Hide()
    restscreen(,,,,scrn)
    Setcolor( xh )

Return( NIL )



static func skipper( o, n )

   local nActualSkipped := 0, nDirection := if(n>0,1,-1)

   if n == 0
     Return 0
   endif

   while nActualSkipped # n
     if nDirection == 1
       o:userslot++
       if ! o:While()
         o:userslot--
         exit
       endif
       nActualSkipped++
     else
       o:userSlot--
       if ! o:While()
         o:userslot++
         exit
       endif
       nActualSkipped--
     endif
   enddo

Return( nActualSkipped )



//Ŀ
// Shut down index files 
//
Function g_indexclose()

   @maxrow(),00 say padc( 'Closing Index files...',maxcol()+1,' ') color message_color()
   WinIndexfiles(, {""} )
   AttachIndexfiles( WinIndexfiles() )
   inkey(1)
   WinObj():RefreshAll()
   @maxrow(),00 say space(maxcol()+1) color message_Color()

Return( NIL )

//Ŀ
// Open Index file 
//
Function g_indexopen()

    local i_file := "*.NTX" + space( BUFFER-5 ), Bar := MenuSys(), nPos, ;
          scrn, xh := setcolor(), sCursor := Set( _SET_CURSOR ), GetList := {}, n


    scrn   := savescreen(maxrow()-5,03,maxrow()-1,36)
    setColor( popup_color() )
    WinBox(maxrow()-5,03,maxrow()-2,34,0,4,.t.)
    @ maxrow()-4,04 say 'Open Index #' + ;
      ltrim(trim(str(if( empty(winindexfiles()[1]), 1, len(winindexfiles())+1) ))) + ;
      ""
    @ maxrow()-3,04 say 'File:' get i_file pict '@KS23'

    set cursor on
    READ
    set(_SET_CURSOR,sCursor)
    setcolor( xh )

    IF lastkey() == K_ESC
      restscreen(maxrow()-5,03,maxrow()-1,36,scrn)
      setcolor(xh)
      Return( NIL )

    END

    i_file := ltrim(trim(i_file))

    while  '?' $ i_file .or. '*' $ i_file
      setcolor( popup_color() )
      i_file := DirPick( i_file,,44 )
      SetColor( xh )
    enddo

    IF lastkey() == K_ESC
      restscreen(maxrow()-5,03,maxrow()-1,36,scrn)
      setcolor(xh)
      Return( NIL )

    END

    i_file := ltrim(trim(i_file))

    nPos := Rat( ".", i_file )

    i_file := SUBSTR(i_file, 1, nPos-1)

    IF file(i_file) .or. file(i_file+'.NTX')
      i_file := uppe(i_file)
      i_file := if( subs(i_file,-4) # '.NTX', i_file + '.NTX', i_file )
      n := WinIndexFiles()
      if ascan( n, i_file ) # 0
        @maxrow(),0 say padc('Index file already opened... Press any key to continue',maxcol()+1,' ') ;
                    color message_color()
        inkey(0)
        @maxrow(),0 say space(maxcol()+1) ;
                    color message_color()
      elseif ! OpenIndex( i_file )
        @maxrow(),0 say padc('Invalid expression in index:  Possibly the incorrect index file',maxcol()+1,' ') ;
                    color message_color()
        inkey(0)
        @maxrow(),0 say space(maxcol()+1) ;
                    color message_color()
      else
        if Empty( n[1] )
          n[1] := i_file
        else
          aadd( n, i_file )
        endif
        WinIndexFiles( , n )
        AttachIndexFiles( n )
        WinObj():Refresh := .t.
      endif
    else
      @maxrow(),0 say padc('File not found !!!  Press any key', maxcol()+1, ' ' ) color message_color()
      inkey(0)
      @maxrow(),0 say space(80) color message_color()
    endif

    restscreen(maxrow()-5,03,maxrow()-1,36,scrn)
    setcolor(xh)

Return( NIL )



//Ŀ
//  Open Requested Index File  
//
Function OpenIndex( x )

Return( ! ( "U" $ type( RawIndexOpen( x ) ) ) )


//Ŀ
// Return Index Expression From File 
//
STATIC Function RawIndexOpen( x )

    LOCAL ret_val      , ;
          handle       , ;
          buffer


    ret_val := '!@#$%^&*()'
    handle  := fopen( x, FO_READ+FO_SHARED )

    IF handle # -1
      buffer := space(BUFFER)
      fseek(handle,22,0)

      IF fread(handle,@buffer,BUFFER) == BUFFER
        if at(chr(0),buffer) # 0
          ret_val := subs(buffer,1,at(chr(0),buffer)-1)
        else
          ret_val := trim(buffer)
        endif

      END

      fclose(handle)

    END

Return( ret_val )


//Ŀ
//  Attach Index file list to Open Database 
//
Function AttachIndexfiles(x)

    local errorObj


    BEGIN SEQUENCE

      Set index to
      aeval( x, { |y| DBSETINDEX( y ) } )

    END SEQUENCE

Return( NIL )


//Ŀ
// Index Order 
//
Function g_indexorder()

    local scrn := savescreen(), nSel, x, temp, i, cColor := setColor(), xTop


    xTop := int(((maxrow()/2)-4))
    setColor( popup_color() )
    nSel := arraydsp( WinIndexfiles(), ;
                     'Select file to make current controlling index', ;
                     '.' ;
                     ,xTop,04,xTop+09,71, ;
                     0, ;
                     0, ;
                     .t., ;
                     , ;
                     { |o| NccMesg( space(67), o:BottomRow+2,'center'), ;
                           NccMesg( ltrim(trim(indexkey(o:CurrentItem))),;
                                 o:BottomRow+2, 'center,04,71' ), ;
                           dView_MouseReader(o,xTop,04,xTop+09,71) ;
                     } ;
                    )
    if nSel # 0
      x    := WinIndexfiles()
      temp := x[nSel]
      for i = nSel to 2 step -1
        x[i] := x[i-1]
      next
      x[1] := temp
      WinIndexfiles( , x )
      AttachIndexfiles( x )
    Endif
    restscreen(,,,,scrn)
    SetColor( cColor )
    WinObj():RefreshAll()

Return( NIL )



//Ŀ
// Create Index 
//
Function g_indexcreate()

    local i_file := "*.NTX" + space( BUFFER-5 ), scrn, xh := setcolor(), ;
          sCursor := Set( _SET_CURSOR ), GetList := {}, n, xTop


    xTop := int(((maxrow()/2)+7))
    scrn   := savescreen(xTop,03,xTop+4,79)
    setColor( popup_color() )
    WinBox(xTop,03,xTop+3,34,0,4,.t.)
    @ xTop+1,04 say 'Index Create ' + ;
      ltrim(trim(str(if( empty(winindexfiles()[1]), 1, len(winindexfiles())+1) )))
    @ xTop+2,04 say 'File:' get i_file pict '@KS23'

    set cursor on
    READ
    set(_SET_CURSOR,sCursor)
    setcolor( xh )

    IF lastkey() == K_ESC .or. empty(i_file)
      restscreen(xTop,03,xTop+4,79,scrn)
      setcolor(xh)
      Return( NIL )

    END

    i_file := uppe( trim(i_file) )
    i_file := if( subs(i_file,-4) # '.NTX', i_file + '.NTX', i_file )
    if indexcreate(i_file)
      n := WinIndexfiles()
      if empty(n[1])
        n[1] := i_file
      else
        aadd( n , i_file )
      endif
      WinIndexfiles( , n )
      WinObj():refresh := .t.
    endif
    AttachIndexFiles( WinIndexFiles() )

    restscreen(xTop,03,xTop+4,79,scrn)
    setcolor(xh)

Return( NIL )



//Ŀ
// Create Index 
//
Function indexCreate( x, y )

    LOCAL cCursor := Set( _SET_CURSOR )  , ;
          ret_val := .f.                 , ;
          sColor  := SetColor()          , ;
          GetList := {}                  , ;
          xTop

    priv  expr

    xTop := int(((maxrow()/2)+7))
    y    := if( y == NIL, '', y )
    expr := subs( y + space(BUFFER), 1, BUFFER)

    setcolor( popup_color() )
    WinBox(xTop,03,xTop+3,73,0,4,.t.)
    @ xTop+1,5 say 'Index Expression for file: ' + x
    @ xTop+2,5 get expr pict '@s67'
    Set Cursor on
    read
    Set( _SET_CURSOR, cCursor )

    expr := ltrim(trim(expr))

    setcolor( message_color() )
    if ! (lastkey() == K_ESC .or. Empty(expr))
      if ! ('U' $ type(expr) .or. 'M' $ type(expr))
        @maxrow(),00 say Padc('< ...Creating Index... >',maxcol()+1,' ')
        index on &expr. to (x)
        ret_val := .t.
      else
        @maxrow(),00 say padc("< Illegal Expression ... Press any key >",maxcol()+1,' ')
        inkey(0)
      endif
    endif
    @maxrow(), 00
    setColor( sColor )

Return( ret_val )


