* Program: Fallguy.prg
* Author:  Greg Lief
* Version: Clipper Summer '87
*
* Placed into the Public Domain.
*
* Syntax:  Fallguy (<row>, <column>, <message>, [<delay>])
*
FUNCTION Fallguy
PARAMETERS mrow, mcol, msg, delay
IF PCOUNT() > 2           && First 3 parameters MUST be passed!
   PRIVATE trow, tcol, save_it, hold_on
   FOR tcol = mcol TO mcol + LEN(msg) - 1
      IF SUBSTR(msg, tcol - mcol + 1, 1) != CHR(32)
         FOR trow = 0 TO mrow
            * Save screen coordinate about to be erased.
            save_it = SAVESCREEN(trow, tcol, trow, tcol)
            * Draw falling letter at that location.
            @ trow, tcol SAY SUBSTR(msg, tcol - mcol + 1, 1)
            IF PCOUNT() < 4      && Default: use sound
               IF trow % 3 = 0   && only at every 3rd row.
                  TONE(6000 - trow * 125, 1)
               ENDIF
            ELSE
               FOR hold_on = 1 TO delay
               NEXT
            ENDIF
            IF trow < mrow
               * Restore affected portion of screen.
               RESTSCREEN(trow, tcol, trow, tcol, save_it)
            ENDIF
         NEXT
      ELSE                && No point in drawing a falling space.
         @ mrow, tcol SAY CHR(32)
      ENDIF
   NEXT
ENDIF
RETURN(0)

* EOF: Fallguy.prg
