* Program: HELP.PRG
* Author:  Don L. Powells
* Version: Clipper Summer 87
* Notes:   Database file: HELP.DBF
*          Index files:   HELP.NTX
*          Routine to display user-defined help screens
* Copyright (c) 1988 Nantucket Corp.

* Prevent recursive calling
SET KEY 28 TO

PARAMETERS call_prg, line_num, input_var
helpscrn = SAVESCREEN(8,20,18,59)
wkarea = SELECT()
SELECT 0
USE Help
IF FILE("HELP.NTX")
   SET INDEX TO Help     && Index Key: Proc+STR(Line)+Get_var
ELSE
   INDEX ON (Proc + STR(Line) + Get_var) to Help
ENDIF

* Draw Help Display Box
@ 8,20 TO 18,59
@ 8,52 SAY CHR(24) + " PgUp"     && 24 is UpArrow
@ 18,52 SAY CHR(25) + " PgDn"       && 25 is DnArrow
CENTER(8,"Help Screen")
CENTER(18,"Press <ESC> when Done")
* Clear the screen inside the Display Box
SCROLL(9,21,17,58,0)

* Ensure that the call_prg and input_var are 10 chars long
*   so that they will match the index key value and dbf
sought = IIF(LEN(call_prg) < 10, call_prg +;
         SPACE(10 - LEN(call_prg)),SUBSTR(call_prg,1,10)) +;
         str(line_num) + IIF(LEN(input_var) < 10, input_var +;
         SPACE(10 - LEN(input_var)),SUBSTR(input_var,1,10))
SEEK sought
IF FOUND()
   MEMOEDIT(Help_memo,9,21,17,58,.F.)   && Display message
ELSE
   nohelp = CHR(13) + CHR(10) + CHR(13) + CHR(10) +;
            "No Help is available at this point." + CHR(13) +;
             CHR(10) + "Use Alt-F1 to"+;
            " add a Help message here."
   MEMOEDIT(nohelp,9,21,17,58,.F.)    && Display nohelp
ENDIF
USE
* Reselect the original work area
SELECT (WKAREA)
* Restore the original screen contents
RESTSCREEN(8,20,18,59,helpscrn)
SET KEY 28 TO HELP
RETURN

