************************************************************************
* MX_TEST
*
* written by Luis M. Ambriz, CIS: 72611,2045
*
* compile: Use the COMPILE batch file to see this demo
*
* created:  04/07/1991
*
* version:  1.0
*
* purpose: This routine will display a running cursor in front of text
*          as its drawn on the screen.  Syntax is provided in the 
*          function itself. I have not tested it under Clipper 5.0. 
*          Any suggestions or improvements (Possible array parameters)
*          would be greatly appreciated....
*          
*          I place this Code into the public domain and ask that any
*          changes or modifications to this code be documented within the
*          code so that I or anyone else could view its evolution.
*          
************************************************************************
*
*       Now for the legal stuff:
*                                  Disclaimer
*                                  ----------
*           The author(s) of this set of routines believe that they will
*        perform their stated purpose. No warranty of any kind, expressed
*        or implied, including without limitation, any warranties of 
*        merchantability and/or fitness for a particular purpose is made.
*        The author shall not be held liable for any damages to data, 
*        property, lost profits, lost savings, or other incidental or
*        consequential damages, whether direct, indirect, or special, arising
*        out of your use or inability to use these routines. 
*
*        That was a mouthful!
*
************************************************************************
*       Now on with the show:
*

Clear
setcolor("w+/n")
@ 0,0 say replicate("",2000)                       && Draw the screen
SET COLOR TO

* 
* Draw two simple boxes on screen....
* 
@ 3, 8,10,71 BOX "͸Գ "
@13, 8,21,71 BOX "ķӺ "

* 
* Type text into the first box....Opening forward
* 
mx_tty("Example of typed text for display...", 5,10, 20,.T.) 
mx_tty("using the standard defaults for viewing ", 6,10, 20,.T.) 
mx_tty("and running at the its default value", 7,10, 20,.T.) 
mx_tty("of 20", 8,10, 20,.T.) 
mx_tty("Interesting................", 8,10, 20,.T.) 

@ 23,00 SAY ""                             && Place cursor somewhere  
INKEY(.5)                                  && Wait a half a second

* 
* Type text into the first box....Opening forward
* 
mx_tty("This text is set at 30 slowed down ",14,10, 30,.T.) 
mx_tty("This text is set at ..40 even slower ",15,10, 40,.T.) 
mx_tty("This text is set at ....55 getting too slow",16,10, 55,.T.) 
mx_tty("This text is set at ......70 oh boy is this slow",17,10, 70,.T.) 
mx_tty("This text is set at .......100 very slow",18,10, 100,.T.) 
mx_tty("This text is set at ..........120 too slow",19,10, 120,.T.) 
mx_tty("This text is set at ............150 painfully slow",20,10, 150,.T.) 

@ 23,00 SAY ""                            && Place cursor somewhere  
INKEY(3)                                  && Wait 3 seconds

* 
* ReDraw the top box on screen....
* 
@ 3, 8,10,71 BOX "͸Գ "

mx_tty("Now the test display will vary in ", 5,10, 20,.T.) 
mx_tty("the speed setting while closing the lines", 6,10, 20,.T.) 
mx_tty("slowing down", 7,10, 20,.T.) 
mx_tty("Interesting................", 8,10, 20,.T.) 

* 
* Type text into the first box....closing backwards
* for obvious reasons it must be closed in the opposite
* order that it was opened..
* 
mx_tty("This text is set at ............150 painfully slow",20,10, 150,.F.) 
mx_tty("This text is set at ..........120 too slow",19,10, 120,.F.) 
mx_tty("This text is set at .......100 very slow",18,10, 100,.F.) 
mx_tty("This text is set at ......70 oh boy is this slow",17,10, 70,.F.) 
mx_tty("This text is set at ....55 getting too slow",16,10, 55,.F.) 
mx_tty("This text is set at ..40 even slower ",15,10, 40,.F.) 
mx_tty("This text is set at 30 slowed down ",14,10, 30,.F.) 

@ 23,00 SAY ""                             && Place cursor somewhere  
INKEY(.5)                                  && Wait a half a second

* 
* ReDraw the top box on screen....
* 
@ 3, 8,10,71 BOX "͸Գ "

mx_tty("Now the test display will vary in ", 5,10, 20,.T.) 
mx_tty("the speed setting while closing the lines", 6,10, 20,.T.) 
mx_tty("speeding up", 7,10, 20,.T.) 
mx_tty("Interesting................", 8,10, 20,.T.) 

* 
* Type text into the first box....Opening forward
* 
mx_tty("This text is set at ...........20 regular",14,10, 20,.T.) 
mx_tty("This text is set at .........15 faster",15,10, 15,.T.) 
mx_tty("This text is set at .......10 even faster",16,10, 10,.T.) 
mx_tty("This text is set at ......5 fast",17,10, 5,.T.) 
mx_tty("This text is set at .....0 Fastest",18,10, 0,.T.) 

@ 23,00 SAY ""                            && Place cursor somewhere  
INKEY(3)                                  && Wait 3 seconds

* 
* Close both windows..
* 
mx_tty("This text is set at .....0 Fastest",18,10, 0,.F.) 
mx_tty("This text is set at ......5 fast",17,10, 5,.F.) 
mx_tty("This text is set at .......10 even faster",16,10, 10,.F.) 
mx_tty("This text is set at .........15 faster",15,10, 15,.F.) 
mx_tty("This text is set at ...........20 regular",14,10, 20,.F.) 

mx_tty("Interesting................", 8,10, 20,.F.) 
mx_tty("speeding up", 7,10, 20,.F.) 
mx_tty("the speed setting while closing the lines", 6,10, 20,.F.) 
mx_tty("Now the test display will vary in ", 5,10, 20,.F.)

@ 23,00 SAY ""                            && Place cursor somewhere  

CLEAR
mx_tty("Thanks for trying out the MX_TTY function by Luis M. Ambriz",;
       23,0,20,.T.)
INKEY(1)                                  && Wait 1 second
mx_tty("Thanks for trying out the MX_TTY function by Luis M. Ambriz",;
       23,0,20,.F.)

RETURN                                      && Outta Here'


* MX_TTY
****************************************************************************
*     FUNCTION: mx_tty
*   
*   PARAMETERS: 1. typed_out   Messaged to be Typed
*               2. tyRow       Starting Row 
*               3. tyCol       Starting Column 
*               4. tdelay      Delay time Usually 20
*               5. ttyDir      Direction .T. = OPEN .F. = CLOSE
*
*       SYNTAX: mx_tty( [your message] , 9, 20, .T. )
*
*       Function requires Parameters 1, 2 and 3.
*
FUNC mx_tty
****************************************************************************
   PARA typed_out,tyRow,tyCol,tdelay,ttyDir
   IF PCOUNT() < 3                          && Test for the basic parameters
       RETURN ""                            && or outta here...
   ENDIF
   IF TYPE("ttyDir")="U"                    && Set a few defaults
      ttyDir=.T.
   ENDIF
   IF TYPE("tdelay")="U"                    && Set a few defaults
      tdelay=20
   ENDIF
   out_text=LEN(typed_out)                  && Get the length for NEXT
   SET CURSOR OFF                           && Turn off the cursor
   IF ttyDir                                && If true will open line
        * 
        *   I have chosen the ASCII CHR(219) for the lead character
        *   although the "<", "", "" or any other valid ASCII character
        *   can be substituted....
        * 
        FOR x = 1 TO out_text
            @ tyRow,tyCol SAY SUBSTR(typed_out,1,x)+""
            FOR x_tty = 1 TO tdelay
            NEXT
        NEXT
        * 
        *   The line must be redrawn for the last time to clear the 
        *   leading cursor block...
        * 
        @ tyRow,tyCol SAY (typed_out)+" "
    ELSE                                    && Else will close line
        @ tyRow,tyCol SAY (typed_out)
        tty_back=out_text
        * 
        *   I think this can be improved here....any suggestions?
        *   This will draw the line backwards and seem to contract
        * 
        FOR x = 1 TO out_text
            @ tyRow,tyCol SAY SUBSTR(typed_out,1,tty_back)+""
            FOR x_tty = 1 TO tdelay
            NEXT
            @ tyRow,tyCol+tty_back SAY SPACE(1)
            tty_back=tty_back-1
        NEXT
        * 
        *   The line must be redrawn for the last time to clear the 
        *   line and the cursor block...
        * 
        @ tyRow,tyCol SAY SPACE(2)
    ENDIF                                    
    SET CURSOR ON                            && Turn back on the cursor
    RETURN ""                                && Return a null value
                                             && Although It should test
                                             && for proper completion
                                             && ie: RETURN(.T.)
