* MUSIC.PRG
* Copied from Reference(CLIPPER) newsletter:
* VOLUME II, NUMBER 3, March 1988 by:
* Gary L. Cota on 1/2/89
*
***************************************
* Establish the operating environment *
***************************************
CLEAR ALL
CLOSE ALL
SET BELL       OFF
SET COLOR TO   GR+/B,B+/W,B+/W,BG+/B
SET CONFIRM    ON
SET CURSOR     OFF
SET DELETED    ON
SET DELIMITER  OFF
SET ECHO       OFF
SET EXACT      OFF
SET EXCLUSIVE  ON
SET INTENSITY  ON
SET MESSAGE TO 2
SET SAFETY     OFF
SET SCOREBOARD OFF
SET TALK       OFF
SET WRAP       ON
*
NOTES()         && Install notes array
*
CLEAR
*
mtempo = 3      && Default duration
mrecord = .F.   && Flag for recording mode
mstring = ""    && Initialize mstring
*
@ 01,00 TO 04,79 DOUBLE
@ 05,00 TO 17,79
@ 18,00 TO 20,79
@ 02,03 SAY "MUSIC"
@ 02,60 SAY "Reference(CLIPPER)"
@ 03,03 SAY "Version 1.0"
@ 03,54 SAY "Pinnacle Publishing, Inc."
@ 06,08 SAY "MUSIC generator and playground for CLIPPER Programmers"
@ 08,08 SAY "   Lowest octave:  Type CTRL  then A, B, C, D, E, F, or G"
@ 09,08 SAY "   Middle octave:  Type            a, b, c, d, e, f, or g"
@ 10,08 SAY "  Highest octave:  Type SHIFT then A, B, C, D, E, F, or G"
@ 11,08 SAY "    Record notes:  Type R or r (this is a toggle key)"
@ 12,08 SAY "  Playback notes:  Type P or P (ESC to stop playback)"
@ 13,08 SAY " Change duration:  Type T or t (then follow prompt)"
@ 14,08 SAY "     Save to mem:  Type S or s (then follow prompt)"
@ 16,08 SAY "    Quit Program:  Type ESC or Q or q"
*
DO WHILE INKEY()<>27
   IF mrecord
      mchg_cir = SETCOLOR("N/W")
      @ 24,73 SAY "RECORD"
      SETCOLOR(mchg_cir)
   ELSE
      @ 24,73
   ENDIF
   *
   @ 19,01 SAY "Playback " + mstring
   mx = INKEY(0)
   *
   DO CASE
      CASE mx=27 .OR. (mx=113 .OR. mx=81)
         * Quit
         @ 23,00 SAY ""
         SET CURSOR ON
         EXIT
         *
      CASE mx=80 .OR. mx=112
         * P/p = Playback
         mchg_cir=SETCOLOR("N/W")
         SET CURSOR OFF
         @ 24,64 SAY "PLAYBACK"
         SETCOLOR(mchg_cir)
         PLAYBACK(mstring,mtempo)
         @ 24,64 SAY SPACE(8)
         SET CURSOR ON
         LOOP
         *
      CASE mx=84 .OR. mx=116
         * T/t = Duration
         @ 24,01 SAY "New duration (18 = 1 second) " GET mtempo PICTURE "999" RANGE 1,90
         SET CURSOR ON
         READ
         SET CURSOR OFF
         @ 24,01 SAY SPACE(50)
         LOOP
         *
      CASE mx=82 .OR. mx=114
         * R/r = mrecord
         mrecord=IF(mrecord,.F.,.T.)     && Toggle
         mstring=""
         @ 19,01 SAY "Playback "+SUBSTR(mstring+SPACE(65),1,65)
         LOOP
         *
      CASE mx=83 .OR. mx=115
         * S/s = Save
         IF mrecord
            * Must be mrecording
            mfile=SPACE(8)
            @ 24,01 SAY "Memory variable filename (MUS extension) " GET mfile PICTURE "@!"
            SET CURSOR ON
            READ
            SET CURSOR OFF
            IF LEN(TRIM(mfile))<>0
               SAVE TO &mfile..MUS ALL LIKE mstring
            ENDIF
            @ 24,01 SAY SPACE(50)
         ENDIF
         LOOP
         *
      CASE (mx>=65 .AND. mx<=71) .OR. (mx>=97 .AND. mx<=103)
         TONE(GETTONE(CHR(mx)),mtempo)
         *
      CASE mx>=1 .AND. mx<=7
         mx=mx+128
         TONE(GETTONE(CHR(mx)),mtempo)
         *
      OTHERWISE
         * Reject key, loop
         LOOP
   ENDCASE
   *
   IF mrecord
      * Add to mstring
      IF LEN(mstring)<65
         * Arbitrary limit
         mstring=mstring+CHR(mx)
      ENDIF
   ELSE
      @ ROW(),COL() SAY CHR(mx)
   ENDIF
ENDDO main control loop
CLEAR
QUIT
*
*
**********************
* System UDFs follow *
**********************
*
*
FUNCTION NOTES
   PUBLIC NOTES[21]
   notes[01] = [   131]
   notes[02] = [   147]
   notes[03] = [   165]
   notes[04] = [   185]
   notes[05] = [   196]
   notes[06] = [   220]
   notes[07] = [   247]
   notes[08] = [c   261]
   notes[09] = [d   293]
   notes[10] = [e   329]
   notes[11] = [f   349]
   notes[12] = [g   392]
   notes[13] = [a   440]
   notes[14] = [b   493]
   notes[15] = [C   523]
   notes[16] = [D   587]
   notes[17] = [E   659]
   notes[18] = [F   698]
   notes[19] = [G   784]
   notes[20] = [A   880]
   notes[21] = [B   988]
RETURN("")
*
*
*
FUNCTION GETTONE
   PARAMETER note
RETURN(VAL(SUBSTR(notes[ascan(notes,note)],5,3)))
*
*
*
FUNCTION PLAYBACK
   PARAMETER melody, duration
   PRIVATE mi
   FOR mi = 1 TO LEN(mstring)
      TONE(GETTONE(SUBSTR(melody,mi,1)),duration)
      IF INKEY()=27
         EXIT
      ENDIF
   NEXT
RETURN("")
*
*
*



