* (c) Copyright 1994 Dwayne Childers
* FREEWARE

#INCLUDE "CLASS(Y).CH"
#INCLUDE "ARTFUL.CH"
#DEFINE ARRAYWIDTH 40			&& Width of reports picklist.


CREATE CLASS MULTIRPT

PROTECTED:
VAR aRptAry
VAR aTags
VAR nRptCount
VAR nRptsSele 

EXPORT:
VAR lWait
METHOD INIT
METHOD RPTSSELE
METHOD RPTSRUN

END CLASS



METHOD init()

self:lWait := .F.
self:aRptAry := RPTGETLIST()
self:aTags := {}
self:aTags:size := LEN( self:aRptAry )
AFILL( self:aTags, .F. )
self:nRptCount := LEN( self:aTags )

RETURN self


METHOD RPTSSELE

LOCAL aNameAry := {}, nSelect := SELECT()
FOR nCounter=1 TO LEN( self:aRptAry )
	AADD( aNameAry, self:aRptAry[ nCounter, 1 ] )
NEXT
APAD( aNameAry, ARRAYWIDTH )
STATUSLINE( MIDDLE( "<SPACE>-Toggle selection <Ctrl T>-Tag all <Ctrl U>-Untag all <ENTER>-Execute" ) )
self:nRptsSele := T_MENU( aNameAry, self:aTags, ,5, ( MAXCOL()-ARRAYWIDTH)/2 )
@ MAXROW(), 0 CLEAR TO MAXROW(), MAXCOL()
FOR nCounter=1 TO LEN( self:aTags )
	IF self:aTags[ nCounter ] =.F.
		self:aRptAry:DELETEAT( nCounter )
		aNameAry:DELETEAT( nCounter )
		self:aTags:DELETEAT( nCounter )
		nCounter--
	ENDIF
NEXT
self:aRptAry:size := self:nRptsSele
aNameAry:size := self:nRptsSele
self:aTags:size := self:nRptsSele
SELECT( nSelect )

RETURN self


METHOD RPTSRUN

LOCAL cRptMsg, cRunCmd, cBatFile := TEMPEXTNAME( AACURPATH(), ".BAT" )
LOCAL cBatLine, nHandle, cJobFile
nHandle := FCREATE( cBatFile )
SCRAPFILES( cBatFile )
WRITELINE( nHandle, "@ECHO OFF" )
WRITELINE( nHandle, "CLS" )
FOR nCounter=1 TO LEN( self:aRptAry )
	aRecord := GETSTDSPEC( self:aRptAry[ nCounter, 2 ] )
	cJobFile := AAJOBCREATE( aRecord, .F. )
	SCRAPFILES( cJobFile )
	cRptMsg := "Printing "+TRIM( self:aRptAry[ nCounter, 1 ] )+", "+ ;
				"Report "+LTRIM( STR( nCounter ) )+" of "+ ;
				LTRIM( STR( LEN( self:aRptAry ) ) )
	cRunCmd := "RRUN "+cJobFile
	IF self:lWait
		WRITELINE( nHandle, "@ECHO "+"Ready to start "+cRptMsg )
		WRITELINE( nHandle, "PAUSE" )
	ELSE
		WRITELINE( nHandle, "@ECHO " +cRptMsg )
	ENDIF
	WRITELINE( nHandle, cRunCmd )
NEXT
FCLOSE( cBatFile )
IF self:nRptsSele > 0
	SWAPPER( cBatFile )
ENDIF

RETURN self

