// multiget.prg
// by Stephen L. Woolstenhulme

// placed in the public domain.  use it where it helps.  modify it to your
// heart's content.  take all the credit, if you like.  tell your users you
// wrote it!  and best of all, improve on it as you see best.
// then give something back to the community, so all may benefit.

// (hooWeeya, what a righteous speech! <g>)

#include "inkey.ch"
#include "getexit.ch"

function multiget()
   local getlist := {}
   local aGets := {}
   local i
   local nActiveScrn := 1
   local cAbort := 'N'
   local lChanged := .f.
   local cScrn := savescreen( 0, 0, maxrow(), maxcol() )
   
   set confirm on
   set scoreboard off
   
   readexit(.t.)  // let arrow keys get from one page to the next, too.

   // let's allow F10 to exit the GETs.

   setkey( K_F10, { || getactive():exitstate := GE_WRITE } )
   
   // create a series of ten GETs for each of three screens.
   
   for i := 1 to 9
      aadd( aGets, 'Screen 1, Item ' + str( i, 3 ) )
   next

   for i := 1 to 9
      aadd( aGets, 'Screen 2, Item ' + str( i, 3 ) )
   next

   for i := 1 to 9
      aadd( aGets, 'Screen 3, Item ' + str( i, 3 ) )
   next

   // establish the screen.

   setcolor( 'w+/b, r/w ,,, n/w' )
   cls
   @ 1, 1 say 'This is a snazzy multi-page GET example:'
   @ 2, 0 say replicate( '', maxcol() + 1 )
   @ maxrow()-1, 0 say replicate( '', maxcol() + 1 )
   @ maxrow(), 1         say 'PgDn:Next Page'
   @ maxrow(), col() + 2 say 'PgUp:Prior Page'
   @ maxrow(), col() + 2 say 'F10:Save'
   @ maxrow(), col() + 2 say 'Esc:Abort'

   // start the GET loop here.
   
   do while ! lastkey() == K_ESC .and. ;  // Esc, F10, ^W exit the reads.
            ! lastkey() == K_F10 .and. ;
            ! lastkey() == K_CTRL_W
      if nActiveScrn == 1
         @  7, 3 say 'GET #1 from Screen 1..:' get aGets[1]
         @  8, 3 say 'GET #2 from Screen 1..:' get aGets[2]
         @  9, 3 say 'GET #3 from Screen 1..:' get aGets[3]
         @ 10, 3 say 'GET #4 from Screen 1..:' get aGets[4]
         @ 11, 3 say 'GET #5 from Screen 1..:' get aGets[5]
         @ 12, 3 say 'GET #6 from Screen 1..:' get aGets[6]
         @ 13, 3 say 'GET #7 from Screen 1..:' get aGets[7]
         @ 14, 3 say 'GET #8 from Screen 1..:' get aGets[8]
         @ 15, 3 say 'GET #9 from Screen 1..:' get aGets[9]
      endif

      if nActiveScrn == 2
         @  7, 3 say 'GET #1 from Screen 2..:' get aGets[10]
         @  8, 3 say 'GET #2 from Screen 2..:' get aGets[11]
         @  9, 3 say 'GET #3 from Screen 2..:' get aGets[12]
         @ 10, 3 say 'GET #4 from Screen 2..:' get aGets[13]
         @ 11, 3 say 'GET #5 from Screen 2..:' get aGets[14]
         @ 12, 3 say 'GET #6 from Screen 2..:' get aGets[15]
         @ 13, 3 say 'GET #7 from Screen 2..:' get aGets[16]
         @ 14, 3 say 'GET #8 from Screen 2..:' get aGets[17]
         @ 15, 3 say 'GET #9 from Screen 2..:' get aGets[18]
      endif

      if nActiveScrn == 3
         @  7, 3 say 'GET #1 from Screen 3..:' get aGets[19]
         @  8, 3 say 'GET #2 from Screen 3..:' get aGets[20]
         @  9, 3 say 'GET #3 from Screen 3..:' get aGets[21]
         @ 10, 3 say 'GET #4 from Screen 3..:' get aGets[22]
         @ 11, 3 say 'GET #5 from Screen 3..:' get aGets[23]
         @ 12, 3 say 'GET #6 from Screen 3..:' get aGets[24]
         @ 13, 3 say 'GET #7 from Screen 3..:' get aGets[25]
         @ 14, 3 say 'GET #8 from Screen 3..:' get aGets[26]
         @ 15, 3 say 'GET #9 from Screen 3..:' get aGets[27]
      endif

      read

      // set a flag to keep track of any changes, so we can override
      // an ESC later on.

      if updated()
         lChanged := .t.
      endif

      // User pressed Page Down.  Get next screen.
      if lastkey() == K_PGDN .or. ;
         lastkey() == K_ENTER .or. ;
         lastkey() == K_DOWN
         nActiveScrn++
         
         // How about letting it wrap?  If DOWN on screen 3, wrap around to 1.
         if nActiveScrn == 4
            nActiveScrn := 1
         endif

      endif

      // User pressed Page Up.  Get prior screen.
      if lastkey() == K_PGUP .or. lastkey() == K_UP
         nActiveScrn--
         
         // How about letting it wrap?  If UP on screen 1, wrap around to 3.
         if nActiveScrn == 0
            nActiveScrn := 3
         endif

      endif

   enddo
   
   if lastkey() == K_ESC .and. lChanged
      @ 21, 3 say 'Abandon Changes ( Y/N )?' ;
              get cAbort ;
              picture '!' ;
              valid cAbort $ 'YN'
      read
   endif

   if cAbort == 'N'
      // Here you can put the values from the GETs back into fields.
   endif
   
   restscreen( 0, 0, maxrow(), maxcol(), cScrn )

return NIL
