; ISEXTEND.ASM
;
; For Clipper '87.  ISEXTEND()
; Returns The amount of Extended Memory Installed
;
; Written By Michael Smith, November 07, 1989.

EXTRN    __RETNI:FAR

_TEXT    SEGMENT BYTE    'CODE'         ; CODE IS THE REQUIRED CLASS
         ASSUME  CS:_TEXT

         PUBLIC   ISExtend

ISExtend PROC      FAR

         PUSH      BP
         MOV       BP,SP

         PUSHF                   ; Need to Get the CPU Type
         XOR       AX,AX         ; First, must be a 386 or 286 to
         PUSH      AX            ; have extended memory.
         POPF
         PUSHF
         POP       AX
         AND       AX,0f000h
         CMP       AX,0f000h
         JZ        NOEXTND

         MOV       AX,08800h     ; Since 286 or 386, get the amount
         INT       015h          ; of Extended installed.
         CMP       AX,00
         JE        NOEXTND
         CMP       AX,08800h
         JE        NOEXTND
         JMP       DONE

NOEXTND:
         MOV       AX,0
DONE:
         PUSH      AX            ; Amount of Extended Memory
         CALL      __RETNI       ; Call Clippers Return Integer
         ADD       SP,2          ; Reset Stack.

         POPF
         POP       BP
         RETF

ISExtend ENDP

_TEXT    ENDS
END
