;**********************************************************************
; CHKDRV.ASM - For Clipper '87:
;
; ChkDrv(int drv) - Returns a Logical (.t. = Drive Ready)
;                   drv - 0=A: 1=B:
;                   This does NOT work for Fixed Disks
; by Michael Smith - November, 1989
;**********************************************************************

PUBLIC             CHKDRV

EXTRN              __RETL:FAR
EXTRN              __PARNI:FAR
EXTRN              __PARINFO:FAR

CODESEG            SEGMENT BYTE    'CODE'  ; CODE IS THE REQUIRED CLASS
                   ASSUME  CS:CODESEG             ;  CODE FOR SUMMER 87

CHKDRV   PROC      FAR

; Clipper Initialization Procedure.
         PUSH      BP
         MOV       BP,SP
         PUSH      DX
         PUSH      CX
         PUSH      SI

         MOV       AX,1          ; See if parameter 1 is numeric
         PUSH      AX
         CALL      __PARINFO
         ADD       SP,2
         CMP       AX,2
         JNE       NODRV         ; if not then return then return .f.
         MOV       AX,1          ; Get the Drive Number
         PUSH      AX
         CALL      __PARNI
         ADD       SP,2
         CMP       AX,2   ; if parm is > 2, then return .f.
         JGE       NODRV
         MOV       DL,AL  ; DL Contains Drive # (0=A...)

         MOV       AX,0401h      ; Verify Drive, 1 Sector
         MOV       CX,0001h      ; Track 0, Sector 1
         MOV       DH,0          ; Side 0
         INT       13H           ; Call BIOS Routine
         JNC       DRV           ; No carry is ok
         MOV       AH,0          ; Reset the disk drive
         INT       13H

NODRV:   MOV       AX,0          ; Return a 0 for .f.
         JMP       RETURN
DRV:     MOV       AX,1

RETURN:  PUSH      AX            ; Return .t. or .f. to Clipper
         CALL      __RETL
         ADD       SP,2

         POP       SI            ; Restore values of registers
         POP       CX
         POP       DX
         POP       BP
         RETF

CODESEG  ENDS
CHKDRV   ENDP
         END
