/* BOXIT.C - BOXIT(t,l,b,r[,Color[, Box_Flag]])                       */
/* by Michael Smith - October, 1989                                   */
/*                                                                    */
/* Draw a box and fill in the specified Color with the specified      */
/* coordinates.  If Box_Flag is included, then will draw a single     */
/* line box instead of a double line box.   Will also draw a shadow   */
/* around the box.                                                    */
/*                                                                    */
/* For Clipper '87.  Change the Attributes of a block of the screen.  */
/* Uses dBase III+ Format Color codes and transforms it to an int     */
/* format.                                                            */
/*                                                                    */
/* Requires _db3clr2int() in HILITE.C                                 */
/*                                                                    */
#include <nandef.h>
#include <extend.h>
#include <clipper.h>

void __atsay(int row, int col, char *string, unsigned __Color) ;
void __my_memset(byte *buffer, byte c, int count) ;

/* Call Routine in HILITE.C to tranform color string to an Int */
extern int __db3clr2int(byte *String, int _length) ;

/* Define Color Codes */
#define BLACK   0
#define BLUE    0x100
#define GREEN   0x200
#define CYAN    0x300
#define RED     0x400
#define MAGENTA 0x500
#define YELLOW  0x600
#define WHITE   0x700
#define BLINK   0x8000                  /* | this for blink */

/* Define Macros for Colors */
#define FORE(x) (x)
#define BACK(x) (0x7000 & ((x)<<4))     /* puts Color into bkgrd bits */
#define HI(x)   ((x) | 0x800)           /* adds hi intensity */

/* Define Screen Address's */
#define MONODMA         0xB000
#define COLORDMA        0xB800
#define MONOCARD        0x03B4

/* Make the Screen Address Global */
unsigned __screenseg=0xB800;

/* Format - Boxit(top, left, bottom, right [, color][, boxflag])  */
CLIPPER Boxit()
{
     int t, l, b, r, vidcard ;
     register int x,w ;
     byte *box_type ;
     unsigned far *scrp;
     unsigned __Color ;
     byte outbuf[81];

   /* Initialize the Screen Segment Variable */
     vidcard = *((int far *) MK_FP(0x40,0x63));
     __screenseg = (vidcard==MONOCARD) ? MONODMA : COLORDMA;

   /* Allocate memory to hold the Box Type String */
     box_type = _exmgrab(11) ;

   /* Must be at least 4 parameters */
     if (PCOUNT < 4) return ;

   /* Get the Parameters from Clipper */
     t = _parni(1) ;
     l = _parni(2) ;
     b = _parni(3) ;
     r = _parni(4) ;

   /* if a sixth parm is passed, then use a single box */
     if (PCOUNT == 6) strcpy(box_type,"Ŀ ") ;
     else strcpy(box_type,"ͻȺ ") ;

   /* if the 5th parm is character, then set the colors using it */
   /* else default to W+/R                                       */
     if (!ISCHAR(5)) __Color = HI(WHITE)|BACK(RED) ;
     else  __Color = __db3clr2int(_parc(5),_parclen(5)) ;

   /* Check Top, Left, Right, & Bottom for valid numbers */
     if (t < 0 || t > 24 || l < 0 || l > 80 || r < 0 || r > 80 || b < 0 || b > 24) return ;

/*   atbox(t,l,b,r,box_type) ; */
     w=r-l+1;

     outbuf[0]=box_type[0];        /* top left char */
     if(w>2) __my_memset(outbuf+1,box_type[1],w-2); /* top line */
     outbuf[w-1]=box_type[2];      /* top right char */
     outbuf[w]=0;
     __atsay(t,l,outbuf,__Color);          /* out */

     if(box_type[8])               /* fill char? */
       { outbuf[0]=box_type[7];
         if(w>2) __my_memset(outbuf+1,box_type[8],w-2);
         outbuf[w-1]=box_type[3];
         for(x=t+1; x<b; x++)
           __atsay(x,l,outbuf,__Color);
       }
     else                          /* nope */
       { outbuf[0]=box_type[7]; outbuf[1]=0;
         for(x=t+1; x<b; x++)
           __atsay(x,l,outbuf,__Color);
         outbuf[0]=box_type[3]; outbuf[1]=0;
         for(x=t+1; x<b; x++)
           __atsay(x,r,outbuf,__Color);
       }

     outbuf[0]=box_type[6];        /* top left char */
     if(w > 2) __my_memset(outbuf+1,box_type[5],w-2); /* top line */
     outbuf[w-1]=box_type[4];      /* top right char */
     outbuf[w]=0;
     __atsay(b,l,outbuf,__Color);          /* out */

/* Place Shadow on bottom of box */
     if (b <= 23)
     {
          x = 0 ;
          for(scrp=MK_FP(__screenseg,(((b+1)*160)+((l+1)<<1)));
              (x <= r - l - 1);
              x++,scrp++)
              *scrp=(WHITE|(*scrp&0xff)) ;
     }

/* Place Shadow on Right of box */
     if (r <= 78)
     {
          if (b > 23) b-- ;
          for(x = t + 1 ; x <= b + 1 ;
              scrp=MK_FP(__screenseg,(((x)*160)+((r+1)<<1))), x++)
              *scrp=(WHITE|(*scrp&0xff)) ;
     }

/* Give back the Space for the Box Type String */
     _exmback(box_type,11) ;
}

void __atsay(int row, int col, char *string, unsigned __Color)
{
     unsigned far *scrp;
     for(scrp=MK_FP(__screenseg,((row*160)+(col<<1)));
         (*string);
         string++,scrp++)
       *scrp=(__Color|(*string&0xff));
}

void __my_memset(byte *buffer, byte c, int count)
{
     register int x ;
     for (x = 0;x < count ; buffer[x] = c, x++) ;
     return ;
}

