* Module.....: msmenu.prg
* Library....: ProClip 3.00 or 3.50 (Jason Matthews/Genesis Development Corp.)
* Date.......: July 29, 1989
* Author.....: Charles Yeo
*
*
*
* Two menu routines with BOTH Mouse-Optional and First-Key select methods
*
*     General   -  uses the current Clipper color
*                  does NOT restore the screen before returning
*                  returns offset into array
*                  abort return zero
*                  select without Return-key confirmation when:
*                         first character of element is pressed
*                            when Confirm is on AND first character is unique
*                         item is selected by mouse
*                  highlight is moved when:
*                         mouse is moved within area of an item
*                         arrow key is pressed
*                         home/end is pressed
*                         first letter is pressed AND confirm is ON and
*                               first letter is NON-unique
*                  selected after Return-key confirmation when:
*                         unique is turned OFF
*                         previous character pressed was NON-unique
*                  aborted and zero reuturned when
*                         Escape-key pressed
*                         Right Mouse Button pressed
*
*
*
* 1.  MHChoice  -  Horizontal menu
*                  any row
*                  no boxes
*                  left/right border protection
*                  initial element
*                  optional sound
*
*     syntax:      MHChoice(Row, Border, Array [,Initial] [,SoundOn])
*
*                  Row     - expn - Row to display menu
*                  Border  - expn - # column to untouch Left AND Right
*                  Array   - expa - Array of Text to display
*                  Initial - expn - initial position within array for highlight
*                  SoundOn - expl - turn on/OFF sound
*
*
*
* 2.  MVChoice  -  Vertical Menu
*                  define Top and Left
*                  initial element
*                  optional sound
*                  optional box (none, single or double)
*                  optional split (2 column mode)
*
*     syntax:      MVChoice(Top, Left, Array [, Initial] [,SoundOn]
*                                            [,BoxType] [,Split] )
*
*                  Top     - expn - top row of menu
*                  Left    - expn - left column of menu
*                  Array   - expa - Array of Text to display
*                  Initial - expn - initial position within array for highlight
*                  SoundOn - expl - turn on/OFF sound
*                  BoxType - expc - s = single / d = double / otherwise NONE
*                  Split   - expl - turn on/OFF 2-column mode
*
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* * * * * * * * * * * * * *
*
* Horizontal Menu
*
* * * * * * * * * * * * * *

function MHChoice
parameters Row, Border, Array, InitPos, SndOn

if type("SndOn") # "L"
   SndOn = .F.
endif
if type("InitPos") # "N"
   InitPos = 1
endif
if pcount() < 3
   ? "Error. Insufficient parameter to MHCHOICE."
   return 0
endif
if type("Array") # "A"
   ? "Illegal Array in MHCHOICE"
   return 0
endif
if type("Row") # "N"
   ? "Illegal Row in MHCHOICE"
   return 0
endif
if type("Border") # "N"
   ? "Illegal Border in MHCHOICE"
   return 0
endif
if Row < 0 .or. Row > 79
   Row = 0
endif
if Border < 0
   Border = 0
endif

* find the spacing between array items
* simultaneously set up the first letter array

PRIVATE B, R, Width, Pos, RetVal, Key, LeftDown, RightDown, Dirty, Items

   Items = len(Array)
   PRIVATE Letter[Items], Col[Items]

   Width = Border * 2
   for Pos = 1 to Items
      Width = Width + len(Array[Pos])
      Letter[Pos] = upper(left(Array[Pos], 1))
   next
   if Width > 80
      ? "Illegal Spacing in MHCHOICE"
      return 0
   endif
   if Items > 1
      Spacing = int((80 - Width) / (Items - 1))
   else
      Spacing = 0
   endif
   Width = Border
   for Pos = 1 to Items
      Col[Pos] = Width
      Width = Width + Spacing + len(Array[Pos])      && get ready for next item
   next

   setcolor(ColorOf("standard"))
   scroll(Row, Border, Row, 79 - Border, 0)

   for Pos = 1 to Items
      @ Row, Col[Pos] say Array[Pos]
   next

   * position highlight on passed item
   if InitPos > Items
      InitPos = Items
   elseif InitPos < 1
      InitPos = 1
   endif
   Pos = InitPos
   NewColor(Row, Col[Pos], Row, Col[Pos] + len(Array[Pos]) - 1, ColorOf("enhanced"))
   Dirty = .F.

   * do mousie stuff
   MouseActive = Mouse("on")
   if MouseActive
      MsCursor("on")
      MsBound("on", Row, Border, Row, 79 - Border)
      MsSetRow(Row)
      MsSetCol(Col[Pos])
      LeftDown = .F.
      RightDown = .F.
   endif

   * main loop
   do while .T.
      * check for key
      Key = inkey()
      if Key # 0
         do case
            case Key = 19 .and. Pos > 1               && Left Arrow
               do NewHPos with Pos, Pos - 1, SndON
               Pos = Pos - 1

            case Key = 4 .and. Pos < Items            && Right Arrow
               do NewHPos with Pos, Pos + 1, SndON
               Pos = Pos + 1

            case Key = 1                             && Home
               do NewHPos with Pos, 1, SndON
               Pos = 1

            case Key = 6                             && End
               do NewHPos with Pos, Items, SndON
               Pos = Items

            case Key = 13                            && Enter
               RetVal = Pos
               exit

            case Key = 27                            && Escape
               RetVal = 0
               exit

            otherwise
               if Pos < Items                        && Not on last item
                  P = ascan(Letter, upper(chr(Key)), Pos + 1)
                  if P = 0                           && check from top
                     P = ascan(Letter, upper(chr(Key)))
                  endif
               else
                  P = ascan(Letter, upper(chr(Key)))
               endif
               if P > 0
                  do NewHPos with Pos, P, SndON
                  Pos = P
                  if Pos < Items             && NOT on last item
                     if !SetConfirm()        && auto return, if NO DUPS
                        if ascan(Letter, upper(chr(Key)), Pos + 1) = 0    && no dups after
                           if ascan(Letter, upper(chr(Key))) = Pos    && no dups before
                              RetVal = Pos
                              exit
                           endif
                        endif
                     endif
                  else
                     if !SetConfirm()        && auto return, if NO DUPS
                        if ascan(Letter, upper(chr(Key))) = Pos    && no dups before
                           RetVal = Pos
                           exit
                        endif
                     endif
                  endif
               elseif SndOn
                  sound(300, 2, .T.)
               endif
         endcase

      else                                           && key processing

         if MouseActive
            * check for mouse
            P = MsCol()
            if P = 0
               LeftDown = .F.
               do NewHPos with Pos, P, SndOn
            elseif P # Pos .or. Dirty
               do NewHPos with Pos, P, SndON
               Pos = P
               LeftDown = .F.
               RightDown = .F.
            endif

            if MsLBtnDown()
               LeftDown = .T.
               if SndOn
                  sound(100, 1, .F.)
               endif
            endif
            if MsLBtnUp() .and. LeftDown
               P = MsCol()
               if P > 0
                  if SndON
                     sound(200, 1, .F.)
                  endif
                  RetVal = P
                  exit
               endif
            endif
            if MsRBtnDown()
               RightDown = .T.
               if SndOn
                  sound(100, 1, .F.)
               endif
            endif
            if MsRBtnUp() .and. RightDown
               if SndOn
                  sound(200, 1, .F.)
               endif
               RetVal = 0
               exit
            endif
         endif                                          && mouse processing
      endif
   enddo

   if MouseActive
      MsCursor("off")
      MsBound("off")
      Mouse("off")
   endif

return RetVal



* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *




* * * * * * * * * * * * * *
*
* used exclusively by MHChoice to re-position the highlight
*
* * * * * * * * * * * * * *

procedure NewHPos
parameters Old, New, Snd

   if Snd
      sound(500 * New, 10, .F.)
   endif

   if MouseActive .and. New > 0
      MsCursor("off")
   endif

   * remove the highlight from the old position
   NewColor(Row, Col[Old], Row, Col[Old] + len(Array[Old]) - 1, ColorOf("standard"))
   Dirty = .T.

   if New > 0
      Dirty = .F.
      * now, mark the new position with the highlight
      NewColor(Row, Col[New], Row, Col[New] + len(Array[New]) - 1, ColorOf("enhanced"))
   endif

   if MouseActive .and. New > 0
      MsCursor("on")
      if New < Old                                 && moving left
         MsSetCol(Col[New] + len(Array[New]) - 1)  && rightmost of this item
      else
         MsSetCol(Col[New])                        && leftmost of this item
      endif
   endif

return



* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* * * * * * * * * * * * * *
*
* Used exclusively by MHChoice to find item Mouse is selecting
*
* * * * * * * * * * * * * *

function MsCol
PRIVATE P, X

   P = MsGetCol()
   for X = Items to 1 step -1
      if P >= Col[X] .and. P <= Col[X] + len(Array[X]) - 1
         exit
      endif
   next

return X





* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* * * * * * * * * * * * * *
*
* Vertical Menu
*
* * * * * * * * * * * * * *


function MVChoice
parameters T, L, Array, InitPos, SndOn, Box, Split

if type("Split") # "L"
   Split = .F.
endif
if type("Box") # "C"
   Box = " "
   BoxOn = .F.
else
   BoxOn = upper(Left(Box, 1)) $ "DS"
endif
if type("SndOn") # "L"
   SndOn = .F.
endif
if type("InitPos") # "N"
   InitPos = 1
endif
if pcount() < 3
   ? "Error. Insufficient parameter to MVCHOICE."
   return 0
endif
if type("Array") # "A"
   ? "Illegal Array in MVCHOICE"
   return 0
endif
if type("L") # "N"
   ? "Illegal Left Column in MVCHOICE"
   return 0
endif
if type("T") # "N"
   ? "Illegal Right Column in MVCHOICE"
   return 0
endif
if L < 0 .or. L > 79
   L = 0
endif
if T < 0 .or. T > 24
   T = 0
endif

* find the maximum width of each array item
* simultaneously set up the first letter array

PRIVATE B, R, Width, Pos, RetVal, Key, LeftDown, RightDown, Items, Litems

   Items = len(Array)
   Litems = Items
   PRIVATE Letter[Items]

   Width = 0
   for Pos = 1 to Items
      if len(Array[Pos]) > Width
         Width = len(Array[Pos])
      endif
      Letter[Pos] = upper(left(Array[Pos], 1))
   next

   R = L + Width + iif(BoxOn, 3, 1)
   B = T + Items + iif(BoxOn, 1, -1)
   if Split
      R = R + Width + 2              && 2 for gutter
      B = B - Items / 2
      Litems = Items / 2
      if int(B) < B                  && didn't divide evenly
         B = B + 1
         Litems = int(Litems + 1)
      endif
   endif

   setcolor(ColorOf("standard"))
   if BoxOn
      @ T, L, B, R box iif(upper(left(Box, 1)) = "S", "Ŀ ", "ͻȺ ")
      T = T + 1
      L = L + 1
      B = B - 1
      R = R - 2
   else
      scroll(T, L, B, R, 0)
   endif

   for Pos = 1 to Items
      if Split .and. Pos > Litems
         @ T + Pos - Litems - 1, L + 3 + Width say Array[Pos]
      else
         @ T + Pos - 1, L + 1 say Array[Pos]
      endif
   next

   * position highlight on passed item
   if InitPos > Items
      InitPos = Items
   elseif InitPos < 1
      InitPos = 1
   endif
   Pos = InitPos
   if Split .and. Pos > Litems
      NewColor(T + Pos - 1 - Litems, L + 3 + Width,;
               T + Pos - 1 - Litems, L + 2 + Width * 2, ColorOf("enhanced"))
   else
      NewColor(T + Pos - 1, L + 1, T + Pos - 1, L + Width, ColorOf("enhanced"))
   endif

   * do mousie stuff
   MouseActive = Mouse("on")
   if MouseActive
      MsCursor("on")
      if Split
         MsBound("on", T, L, T + Litems - 1, L + 3 + Width * 2)
      else
         MsBound("on", T, L, T + Items - 1, L + Width + 1)
      endif
      if InitPos > Litems
         MsSetRow(T + InitPos - 1 - Litems)
         MsSetCol(L + Width + 2)
      else
         MsSetRow(T + InitPos - 1)
         MsSetCol(L + Width + 1)
      endif
      LeftDown = .F.
      RightDown = .F.
   endif

   * main loop
   do while .T.
      * check for key
      Key = inkey()
      if Key # 0
         do case
            case Key = 5 .and. Pos > 1               && UpArrow
               do NewVPos with Pos, Pos - 1, SndON
               Pos = Pos - 1

            case Key = 24 .and. Pos < Items          && DnArrow
               do NewVPos with Pos, Pos + 1, SndON
               Pos = Pos + 1

            case Key = 18                            && PgUp
               do NewVPos with Pos, iif(Pos > Litems, Litems + 1, 1), SndON
               Pos = iif(Pos > Litems, Litems + 1, 1)

            case Key = 3                             && PgDn
               do NewVPos with Pos, iif(Pos > Litems, Items, Litems), SndON
               Pos = iif(Pos > Litems, Items, Litems)

            case Key = 1                             && Home
               do NewVPos with Pos, 1, SndON
               Pos = 1

            case Key = 6                             && End
               do NewVPos with Pos, Items, SndON
               Pos = Items

            case Split .and. Key = 19 .and. Pos > Litems      && left arrow
               do NewVPos with Pos, Pos - Litems, SndOn
               Pos = Pos - Litems

            case Split .and. Key = 4 .and. Pos <= Litems      && right arrow
               do NewVPos with Pos, Pos + Litems, SndOn
               Pos = Pos + Litems

            case Key = 13                            && Enter
               RetVal = Pos
               exit

            case Key = 27                            && Escape
               RetVal = 0
               exit

            otherwise
               if Pos < Items                        && Not on last item
                  P = ascan(Letter, upper(chr(Key)), Pos + 1)
                  if P = 0                           && check from top
                     P = ascan(Letter, upper(chr(Key)))
                  endif
               else
                  P = ascan(Letter, upper(chr(Key)))
               endif
               if P > 0
                  do NewVPos with Pos, P, SndON
                  Pos = P
                  if Pos < Items             && NOT on last item
                     if !SetConfirm()        && auto return, if NO DUPS
                        if ascan(Letter, upper(chr(Key)), Pos + 1) = 0    && no dups after
                           if ascan(Letter, upper(chr(Key))) = Pos    && no dups before
                              RetVal = Pos
                              exit
                           endif
                        endif
                     endif
                  else
                     if !SetConfirm()        && auto return, if NO DUPS
                        if ascan(Letter, upper(chr(Key))) = Pos    && no dups before
                           RetVal = Pos
                           exit
                        endif
                     endif
                  endif
               elseif SndOn
                  sound(300, 2, .T.)
               endif
         endcase

      else                                           && key processing

         if MouseActive
            * check for mouse
            P = MsGetRow() - T + 1
            if MsInCol2()
               P = P + Litems
            endif
            if P > Items
               P = Items
            endif

            if P # Pos
               do NewVPos with Pos, P, SndON
               Pos = P
               LeftDown = .F.
               RightDown = .F.
            endif

            if MsLBtnDown()
               LeftDown = .T.
               if SndOn
                  sound(100, 1, .F.)
               endif
            endif
            if MsLBtnUp() .and. LeftDown
               Pos = MsLBtnUp("row") - T + 1
               if MsInCol2()
                  Pos = Pos + Litems
               endif
               if SndON
                  sound(200, 1, .F.)
               endif
               RetVal = Pos
               exit
            endif
            if MsRBtnDown()
               RightDown = .T.
               if SndOn
                  sound(100, 1, .F.)
               endif
            endif
            if MsRBtnUp() .and. RightDown
               if SndOn
                  sound(200, 1, .F.)
               endif
               RetVal = 0
               exit
            endif
         endif                                          && mouse processing
      endif
   enddo

   if MouseActive
      MsCursor("off")
      MsBound("off")
      Mouse("off")
   endif

return RetVal



* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* * * * * * * * * * * *
*
* used exclusively by MVChoice to re-draw the highlight
*
* * * * * * * * * * * *

procedure NewVPos
parameters Old, New, Snd

   if Snd
      sound(500 * New, 10, .F.)
   endif
   if MouseActive
      MsCursor("off")
   endif
   * remove the highlight from the old position
   if Old > Litems
      Top = T + Old - Litems - 1
      Left = L + 3 + Width
   else
      Top = T + Old - 1
      Left = L + 1
   endif
   NewColor(Top, Left, Top, Left + Width - 1, ColorOf("standard"))

   * now, mark the new position with the highlight
   if New > Litems
      Top = T + New - Litems - 1
      Left = L + 3 + Width
   else
      Top = T + New - 1
      Left = L + 1
   endif
   NewColor(Top, Left, Top, Left + Width - 1, ColorOf("enhanced"))

   if MouseActive
      MsCursor("on")
      if New > Litems
         MsSetRow(T + New - Litems - 1)
         if .not. MsInCol2()                       && move it to start of Col2
            MsSetCol(L + 2 + Width)
         endif
      else
         MsSetRow(T + New - 1)
         if MsInCol2()                             && move it to end of Col1
            MsSetCol(L + 1 + Width)
         endif
      endif
   endif

return



* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* * * * * * * * * * * *
*
* used exclusively by MVChoice to determine if mouse is in right column
*
* * * * * * * * * * * *


function MsInCol2

   MsCol = MsGetCol()

return (MsCol > L + Width + 1)


* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


* eof

