;   July 18, 1989....Bill Carter..........75470,2463
;
;   This is sample startup code for Microsoft C & Quick C compiler to
;   enable routines to be converted to BIN files for use with dBASE IV.
;   This routine was written for Steve Silverwood & Jay Parsons.
;
;   The upgrade for QC 2.0 changes the requirements for startup.  Currently
;   Microsoft hasn't provided the new startup code.  When this is available
;   I will modify this routine so it isn't a kludge, and upload it.
;
;   This routine was written to work with programs compiled in the SMALL
;   MODEL.  My goals included being able to test your code with QC & with
;   NO CHANGES, convert it to a BIN.  To achieve this, it was neccessary to
;   copy the parameter dBASE sent into our local data segment.	I can think
;   of two ways that might work around this copying:
;
;	   1) declare main as:
;		 void main( int argc, char far**argv )
;	   2) use the COMPACT MODEL
;
;   I haven't currently tested either of these methods.
;
;   This routine is setup to use 2K worth of stack.  If you don't require
;   this much stack or require more you can safetyl change the EQU for
;   MAX_STACK.	2K is a whole lotta stack (if you don't declare lots of
;   local variables), just remember THERE IS NO STACK CHECKING.
;
;
;   While debugging this routine, I think I found an undocumented bug in
;   dBASE IV.  Namely, you must use at least one variable before loading
;   a BIN file.  If you are using a BIN & your first parameter gets trashed
;   this may be your cause.  I am assuming this is a dBASE bug, but I could
;   very well be wrong.  If anyone should discover an error in this code that
;   is causing this behavior, PLEASE send me a message via EasyPlex to
;   75470,2463.  Thanks
;
;
;   Maybe an example would be better:
;
;   Assume you have a BIN called CSTRUPR which will convert parameters to
;   all UPPERCASE.
;
;   Then execute the following at the dot prompt:
;
;   LOAD CSTRUPR
;   ARG1 = "this"
;   ARG2 = "is"
;   ARG3 = "a"
;   ARG4 = "test"
;   CALL CSTRUPR WITH ARG1,ARG2,ARG3,ARG4
;   ?ARG1	    && Instead of printing "THIS" will print "?ARG1"
;   && The rest of the parameter were correctly converted.
;
;   The workaround is to initialize at least one of the variable prior
;   to loading the BIN file.
;
;   ARG1 = "this"
;   LOAD CSTRUPR
;   && Now everything should work fine.
;
;
;   Note, please that this code does none of the checks that normal startup
;   code does.	I'm basically just providing a environment that will allow you
;   to exe2bin.  When (if) MS fills in the rest of what I need, I think I can
;   supply some objs that will replace normal startup.	Don't do any I/O,
;   avoid ANY memory allocation, don't exec or spawn, cross your fingers, say
;   a prayer, and everything should work as expected.
;
;   dbStart.asm
;
;   July 18, 1989....Bill Carter..........75470,2463
;
;   This startup routine is (obviously) a kludge.  Some runtime library routines
;   are are usable, most are not.  It's kind of hit and miss...extract the
;   approriate obj and try to link it....if it's okay you get no error messages.
;
;   An example follows for test.c
;
;   Assemble :		    MASM /Mx dbStart.asm;
;
;   Compile c routine :     cl /AS /Gs /Od /c test.c
;
;   Extract obj library :   lib SLIBCE *strupr
;
;   Link:		    link dbStart+test+strupr/NOD;
;
;			    ignore the NO STACK SEGMENT ERROR
;			    This is expected (even required).
;
;   Convert to bin:	    exe2bin dbStart
;
;***************   dbStart MUST be first .obj		      *****************
;***************   link test+strupr+dbStart/NOD; WILL NOT WORK!!! *************
;
;
;   You can create a .lib that works by extracting the .objs you want :
;
;		  lib SCLIBCE *name
;
;   and creating a seperate lib for them:
;
;		  lib DBC +name
;
;

;
;   Actual code begins here
;

_TEXT	SEGMENT WORD PUBLIC 'CODE'
_TEXT	ENDS

_DATA	SEGMENT WORD PUBLIC 'CODE'
_DATA	ENDS

DGROUP	 GROUP	_DATA

;
;   This public is used by MSC to guarentee that startup code is linked with
;   the code you write.  (ie it is declared extern in every obj MSC generates.
;   We still need to declare it even though it's not used.
;

public	__acrtused 		; trick to force in startup
	__acrtused = 9876h	; funny value not easily matched in SYMDEB

EXTRN	_main:NEAR


MAX_STACK  EQU 2048	;  Default stack size
PARMSIZE   EQU 0FFH	;  Size of each parameter dBIV sends

;
;   Normal .com entry
;

_TEXT SEGMENT

    ASSUME  cs:_TEXT,ds:_TEXT,ss:_TEXT

    ORG 100H
_astart:
    JMP NEAR PTR begin

;
;   MSC convention is DS == SS, so we'll have to save dB's stack segment
;   and pointer, then switch to a local stack.
;

DBSS	DW  ?			; A place to store dBASE's stack segment
DBSP	DW  ?			;      on pointer

ARGC	DW  ?			; Number of args dBASE sent to us

DBPARM	DB  0ffh*7 dup (0)	; A local copy of db's parameters

DBPTR	DW 7 DUP (0)		; and a copy of array of pointers

CSTCK	DB MAX_STACK DUP (0)	; this will be our stack
CSTTOP	LABEL	BYTE

begin:	      ; start address of all "C" programs

    ;	If you run dbase under debug, this int 03 acts like a breakpoint
    ;	on the first line of dbStart.
    ;	Comment it out if you like. ( Or leave it...this has no effect unless
    ;	you are running under a debugger. )
    ;

    int     03		    ; break in for the debugger

    mov     ax,cs
    mov     ds,ax	    ; setup ds

    mov     ax,ss	    ; save dbase stack
    mov     CS:DBSS,ax	    ;		       segment
    mov     CS:DBSP,sp	    ;		   and pointer

    ;
    ;	Move the stack
    ;

    mov     ax,cs
    cli 		       ;  REQUIRED
    mov     ss,ax
    mov     sp,OFFSET CSTTOP
    sti 		       ;  REQUIRED

    mov     ARGC,cx		    ; save the number of args

    push    es			    ; and the orginal ES:DI
    push    di

    ;
    ;	Setup to copy the parameters from dbase to our current segment.
    ;

    mov     si,ES:[DI]
    mov     ax,ES:[DI+2]
    mov     ds,ax
    lea     di,CS:DBPARM
    mov     ax,cs
    mov     es,ax
    mov     cx,0ffh*7

    ;
    ;	Here DS:SI is what ES:DI used to be, and ES:DI points to our local
    ;	table.	CX is number of bytes to move (256*7)
    ;
    ;	move entire table in one fell swoop

rep movsb

    ;	Switch back to current DS

    mov     ax,cs
    mov     ds,ax

    ;
    ;	Here I'm creating the array of pointers to the new parameter block.
    ;

    lea     di,DBPARM
    lea     bx,DBPTR
    mov     cx,7
plp:
    mov     [bx],di
    add     di,0ffh
    add     bx,2
    loop    plp

    ;
    ;	Whew! almost done, just push a pointer to parameter table, and
    ;	number of args, then call main.
    ;

    lea     di,DBPTR
    push    di	    ;	Near pointer to argv
    mov     cx,ARGC
    push    cx	    ;	argc

    call    _main   ;	Away you go!
    add     sp,4

    pop     di	    ;	Restore the originals so we can copy our changes
    pop     es	    ;	back where db will find them.


    mov     ax,ES:[DI]
    mov     di,ax
    mov     cx,0ffh*7
    lea     si,DBPARM
rep movsb	    ;	Copy from our copy of parameters to dBASE's

    ;
    ;	Restore db's stack.
    ;

    mov     ax,DBSS
    cli 			; REQUIRED
    mov     ss,ax
    mov     sp,DBSP
    sti 			; REQUIRED
dexit:
    retf    ; and back you go.

_TEXT	ENDS

	end	_astart		; start address
