*+
FUNCTION AddHotSpot(aMouseSpot,nFreeSpot,aDef)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: add a hot spot to the given array
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     7/7/91    LJL       Initial Version
*
* Calling parameters: aMouseSpot - an array of hot spots to receive the new one
*                     nFreeSpot - the next free spot - passed by reference
*                     aDef - an array defining the hot spot - See caller for
*                            structure
* Returns: the ID number of the hot spot
*
* Notes: None
*-
* LOCAL variables: 
LOCAL nNextSpot, lWorking, i

*
* Entry Point
*

IF (nFreeSpot=0)
	AADD(aMouseSpot,{})
	nNextSpot=LEN(aMouseSpot)
ELSE
	nNextSpot=nFreeSpot
	i=nNextSpot+1
	nFreeSpot=0
	lWorking=.T.
* find next free location
	DO WHILE i<LEN(aMouseSpot).AND.lWorking
		IF aMouseSpot[i,1]=-1
			lWorking=.F.
			nFreeSpot=i
		ENDIF
		i++
	ENDDO

ENDIF

* Now add the coordinates

aMouseSpot[nNextSpot]=aDef

RETURN nNextSpot

* End of AddHotSpot

******
*
* FUNCTION sleep(nSeconds,nInitial)
*
* Purpose: wait for a given period of time
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/20/91   LJL       Initial Version
*         V1.01     8/27/91   LJL       Actually got it to work over midnight
*
* Calling parameters: nSeconds - Input the number of seconds to waste
*                     nInitial - Optional input - the clock value (from
*                                a call to SECONDS()) from which the
*                                nSeconds seconds are to elapse. Useful
*                                for setting a minimum time between the
*                                start of events which could take a variable
*                                amount of time.
*
* Returns: NIL
*
* Notes: This gives the best guess based upon speed of the machine.
*        Don't use for more than 24 hours
*
FUNCTION sleep(nSeconds,nInitial)
*
* LOCAL variables: none

*
* Entry Point
*
IF nInitial=NIL.OR.VALTYPE(nInitial)!="N"
	nInitial=SECONDS()
ENDIF

* correct for running at midnight

IF nInitial+nSeconds>86399
	nInitial=nInitial-86399
*  Wait until midnight
     DO WHILE SECONDS()>100  // no problem with a _very_ slow machine
     ENDDO
ENDIF


nSeconds+=ninitial

DO WHILE (SECONDS()<nSeconds)

ENDDO

RETURN NIL

* End of sleep

**************************************************************************
*
* NOTE: The following routine has been submitted to the Nanforum Toolkit
*       and will be appearing in the next release (V 3.0). Be aware of 
*       possible duplicate PUBLIC symbols when that version comes out. Remove
*       this copy when version 3.0 of the toolkit is available.

/*
 * $DOC$         
 * $FUNCNAME$
 *    FT_MINIT()
 * $CATEGORY$
 *    Keyboard/Mouse
 * $ONELINER$
 *    Initialize the mouse driver, variables and return status of mouse
 * $SYNTAX$
 *    FT_MINIT() -> lMouseStatus
 * $ARGUMENTS$
 *    NONE
 * $RETURNS$
 *    An logical representing the mouse status (.F. == mouse not installed)
 * $DESCRIPTION$
 *    Initializes the mouse drive, associated variables and returns mouse 
 *    status. It checks to see if the mouse has been previously initialized
 *    and if so it does not reinitialize. Use FT_MSHOWCRS() to display the 
 *    mouse cursor.
 * $EXAMPLES$
 *    IF .NOT. FT_MINIT()
 *       ? "No mouse driver is installed"
 *    ENDIF
 * $END$
 */

FUNCTION FT_MINIT()

STATIC lMinit:=.F.

* If not previously initialized then try

IF !lMinit
	lMinit=(FT_MRESET()!=0)
ENDIF

RETURN lMinit
