/*
 * File......: MOUSBROW.PRG
 * Author....: Leo Letendre
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This will be placed in the Nanforum Toolkit. Until then all rights reserved.
 *
 * Adapted from TBDEMO.PRG and TBWHILE.PRG from Nantucket and Jim Orlowski
 * respectively.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#command DEFAULT <param> TO <val> [, <paramn> TO <valn> ];
=> ;
         <param> := IIF(<param> = NIL, <val>, <param> ) ;
         [; <paramn> := IIF(<paramn> = NIL, <valn>, <paramn> ) ]


#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"
#include "error.ch"
#include "mbrowse.ch"
#include "scrolbar.ch"

* Remove the comments on any of the following to perform the desired actions
* Note the arguments passed to the routine are not changed when any of these
* defines are active.

* #define NO_EDITS         // eliminates the code which allows editing of fields
* #define NO_APPENDS       // eliminates the code which allows adding records
* #define NO_SIDE_SCROLL   // eliminates the code which puts the scroll bar on
                           // the side
* #define NO_BOTTOM_SCROLL // eliminates the code which puts the scroll bar on
                           // the bottom
* #define NO_MOUSE         // eliminates the code for mouse support


STATIC aMouseSpot:={}    // Holder of mouse hot spots
STATIC nFreeSpot:=0      // next free spot in aMouseSpot 0 = none
STATIC lIgnoreMouse:=.F. // Ignore mouse even if it is there
STATIC lMouseUsed:=.F.   // Indicates if the mouse is in use
STATIC lDefRelease:=.F.  // Default value for waiting for release of button
                         // after hitting a hot spot
STATIC nDefSleep:=0.2    // Default time to wait between servicing hits
                         // on button (in seconds)
STATIC nLastRec          // closest record to go to if while is .F. on an
                         // edited record
STATIC oBrowse:=NIL		// The current browse object
STATIC nDblClkTime:=0.5  // The time, in seconds, to wait for a double click


#define nBotDepth        1      // the depth of the bottom separator

#ifdef FT_TEST

  /*
   *   THIS DEMO SHOWS TBNAMES.DBF CONSISTING OF LAST, FIRST, ADDR, CITY,
   *   STATE, ZIP WITH ACTIVE INDEX ON LAST + FIRST.  IT SHOWS LAST NAME,
   *   FIRST NAME, CITY ONLY FOR THOSE LAST NAMES THAT BEGIN WITH LETTER
   *   THAT YOU INPUT FOR THE CKEY GET.
   *
   *   TBNAMES.DBF/.NTX ARE AUTOMATICALLY CREATED BY THIS TEST PROGRAM
   */

*  #INCLUDE "SETCURS.CH"

  FUNCTION TBWHILE()
     LOCAL aFields := {}, cKey := "O", cOldColor
     LOCAL nFreeze := 1, lSaveScrn := .t., nRecSel
     LOCAL cColorList := "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R"
     LOCAL cColorShad := "N/N"
     LOCAL nId1, nId2, nId3, bScreenInit, cSaveClr
     LOCAL GetList:={}
     FIELD last, first, addr, city, state, zip IN TBNames

	SET DELETED ON
	SET CONFIRM ON

     IF ! FILE( "TBNAMES.DBF" )
        MAKE_DBF()
     ENDIF

     USE TBNames ALIAS TBNames

     IF ! FILE( "TBNAMES.NTX" )
        INDEX ON last + first TO TBNAMES
     ENDIF

     SET INDEX TO TBNAMES

     * Pass Heading as character and Field as Block
     * To eliminate the need to use FIELDWBLOCK() function in MBROWSE()

     AADD(aFields,{"Last Name " ,{|x| IIF(x=NIL,Last,Last:=x) } } )
     AADD(aFields,{"First Name",{|x| IIF(x=NIL,First,First:=x) } } )
     AADD(aFields,{"Address"   ,{|x| IIF(x=NIL,Addr,Addr:=x) } } )
     AADD(aFields,{"City"      ,{|x| IIF(x=NIL,City,City:=x)}  } )
     AADD(aFields,{"State"     ,{|x| IIF(x=NIL,State,State:=x)},.T.,"!!",;
                  {||showhelp()},{||clearhelp()} } )
     AADD(aFields,{"Zip"       ,{|x| IIF(x=NIL,Zip,Zip:=x)},.T.,"@R 99999-9999" } )

     cOldColor := SetColor("N/BG")
     CLEAR SCREEN
     @ 6,10 SAY "Space looks at all names"
     @ 5,10 SAY "Enter First Letter Of Last Name:" GET cKey PICTURE "!"
     READ

     * TBNames->Last = cKey is the Conditional Block passed to this function
     * you can make it as complicated as you want, but you would then
     * have to modify TBWhileSet() to find first and last records
     * matching your key.
     IF EMPTY(cKey)
         GOTO TOP
         cKey=NIL
     ELSE
         SEEK cKey
     ENDIF
* Add a help mouse hot spot and a function key

     SET KEY K_F1 TO browse_help
#ifndef NO_MOUSE
     nId1:=BRHotSpot(1,7,1,13,{|| browse_help()},,,.T.)
     nId2:=BRHotSpot(1,18,1,21,{|| browse_key("QUIT")})
     nId3:=BRHotSpot(1,26,1,31,{|| browse_key("SELECT")})

     bScreenInit:={|| cSaveClr:=SetColor("W/R"), DevPos(1,7), DevOut("F1=Help"),;
                      DevPos(1,18), DevOut("Quit"), DevPos(1,26),;
                      DevOut("Select"), SetColor(cSaveClr)}
#endif

*
* See the note in the MyReader routine below for an explanation of the while
* code block's form
*
     nRecSel := MBROWSE(aFields,;
          {|x| IIF(x=NIL,TBNames->Last = cKey, x = cKey)}, cKey, nFreeze,;
          lSaveScrn, cColorList, cColorShad, 3, 2, MaxRow() - 2, MaxCol() - 2,;
          bScreenInit,GET_ON_RETURN+DOUBLE_CLICK_GET,,K_ALT_E,.T.,;
          {|| myreader()})

     * Note you can use Compound Condition 
     * such as cLast =: "Pierce            " and cFirst =: "Hawkeye  "
     * by changing above block to:
     *    {||TBNames->Last = cLast .AND. TBNames->First = cFirst}
     * and setting cKey := cLast + cFirst

* To be formally correct we will deactivate the mouse hot spots

#ifndef NO_MOUSE
      BRRemHotSpot(nId1)
      BRRemHotSpot(nId2)
      BRRemHotSpot(nId3)
#endif
      SET KEY K_F1 TO

     ?
     IF nRecSel == 0
        ? "Sorry, NO Records Were Selected"
     ELSE
        ? "You Selected " + TBNames->Last +" "+ ;
           TBNames->First +" "+ TBNames->City
     ENDIF
     ?

     WAIT
     SetColor(cOldColor)
     CLEAR SCREEN
  RETURN nil

  STATIC FUNCTION make_dbf
  LOCAL x, aData := {                                                               ;
     { "SHAEFER","KATHRYN","415 WEST CITRUS ROAD #150","LOS ANGELES","CA","90030" },;
     { "OLSON","JAMES","225 NORTH RANCH ROAD","LOS ANGELES","CA","90023"          },;
     { "KAYBEE","JOHN","123 SANDS ROAD","CAMARILLO","CA","93010"                  },;
     { "HERMAN","JIM","123 TOON PAGE ROAD","VENTURA","CA","93001"                 },;
     { "BURNS","FRANK","123 VIRGINA STREET","OXNARD","CA","93030"                 },;
     { "PIERCE","HAWKEYE","123 OLD TOWN ROAD","PORT MUGU","CA","93043"            },;
     { "MORGAN","JESSICA","123 FRONTAGE ROAD","CAMARILLO","CA","93010"            },;
     { "POTTER","ROBERT","123 FIR STREET","OXNARD","CA","93030"                   },;
     { "WORTH","MARY","123-1/2 JOHNSON DRIVE","OXNARD","CA","93033"               },;
     { "JOHNSON","SUSAN","123 QUEENS STREET","OXNARD","CA","93030"                },;
     { "SAMSON","SAM","215 MAIN STREET","OXNARD","CA","93030"                     },;
     { "NEWNAME","JAMES","215 MAIN STREET","LOS ANGELES","CA","90000"             },;
     { "OLEANDAR","JILL","425 FLORAL PARK DRIVE","FLORAL PARK","NY","10093"       },;
     { "SMITH","SALLY","919 SOUTH S. ST.","SUN CITY","FL","20322"                 },;
     { "JACKSON","BO","REHAB LANE","CHICAGO","IL","05505"                         },;
     { "HULL","BRETT","400 OAKLAND AVE.","ST. LOUIS","MO","63124"                 },;
     { "COWENS","DAVE","BBALL HALL OF FAME","SPRINGFIELD","MA","01067"            },;
     { "JAGER","TOM","MOUNTAIN TOP LN","SOMEWHERE","NM","82345"                   },;
     { "JOYNER","JACKEE","SPRINT LANE","TRACK CITY","CA","92435"                  },;
     { "WILLIAMS","TED","LANDSDOWN ST","BOSTON","MA","02323"                      },;
     { "TRUMAN","HARRY","PRESIDENTS ROW","INDEPENDENCE","MO","64534"              },;
     { "SMOTHERS","TOMMY","CBS TOWERS","NEW YORK","NY","09123"                    },;
     { "TISCH","LAWRENCE","MOST OF","NEW YORK","NY","09100"                       },;
     { "BIRD","BIG","SESAME ST.","HARLEM","NY","09043"                            },;
     { "KIRK","JAMES","USS ENTERPRISE","HOLLYWOOD","CA","92567"                   },;
     { "PAUL","JOHN","1 VATICAN LN","VATICAN CITY","IT","99999"                   },;
     { "SUGARMAN","CANDY","1541 SWEETHEART ROAD","HERSHEY","PA","10132"           } }

  DbCreate( "TBNAMES", { { "LAST ", "C", 18, 0, } ,;
                         { "FIRST", "C",  9, 0, } ,;
                         { "ADDR ", "C", 28, 0, } ,;
                         { "CITY ", "C", 21, 0, } ,;
                         { "STATE", "C",  2, 0, } ,;
                         { "ZIP  ", "C",  9, 0, } } )
  USE tbnames
  FOR x := 1 TO Len( aData )
     APPEND BLANK
     Aeval( aData[x], {|e,n| FieldPut( n, e ) } )
  NEXT
  USE
  RETURN NIL

FUNCTION myReader
* Creates Gets and READs for appends to the browse
*
* Calling parameters: none
*
* Returns the number of records appended
*

LOCAL cLast, cFirst, cAddr, cCity, cState, cZip
LOCAL savescr, GetList:={}, nAppend:=0
LOCAL oBrowse:=ActiveBrowse(), lOk
FIELD Last, First, Addr, City, State, Zip IN TBNames

* Obviously this routine could be placed in a loop so that multiple records
* can be added. This function was split out since it becomes too difficult to
* allow an append directly in the browse while under the restraints of a 
* while condition.

SAVE SCREEN TO savescr

@ 6,6 CLEAR TO 12,72
@ 6,6,12,72 BOX B_SINGLE

cLast=SPACE(LEN(Last))
cFirst=SPACE(LEN(First))
cAddr=SPACE(LEN(Addr))
cCity=SPACE(LEN(City))
cState=SPACE(LEN(State))
cZip=SPACE(LEN(Zip))

@ 8,10 SAY "Last Name " GET cLast
@ 9,9 SAY "First Name " GET cFirst
@ 10,12 SAY "Address " GET cAddr
@ 11,15 SAY "City " GET cCity
@ 11,43 SAY "State " GET cState
@ 11,53 SAY "Zip " GET cZip PICTURE "@R 99999-9999"

READ

RESTORE SCREEN FROM savescr

IF LASTKEY()!=K_ESC

* Test to see if the new record will be within the current scope
* Note that the while code block was written so that if an argument was passed
* it uses the argument otherwise it uses the database. This was done so that
* it could be used here
     lOk:=EVAL(WHILE_BLOCK(oBrowse),cLast) 
     IF lOk .OR. ((.NOT. lOk) .AND. ;
        UPPER(CHR(FT_DISPMSG({{"This person does not fit current criteria",;
       "Do you still wish to add this person?"}, {"B/R",,"W/R"}},;
       "YyNn",,12)))="Y")
         APPEND BLANK
         Last := cLast
         First:= cFirst
         Addr := cAddr
         City := cCity
         State:= cState
         Zip  := cZip
         nAppend=IIF(lOk,1,0)
      ENDIF
ENDIF

RETURN nAppend

*****
*
* Browse_help()
*
* Put up a help screen
*
FUNCTION Browse_help

LOCAL savescr:=SAVESCREEN()

CLEAR SCREEN

@ 5,8 SAY "This browse has many features including: Mouse support, scroll bars,"
@ 6,8 SAY "editing of the data and appending fields to the database."
@ 7,8 SAY "Mouse Support: Click on a field to move to it. Double click to edit."
@ 8,8 SAY "    Click on the arrows to move database. Left button moves one item."
@ 9,8 SAY "    Right button move page. Both on up and down goes to top or bottom."
@ 10,8 SAY "    Click on scroll bar and display moves to the corresponding"
@ 11,8 SAY "    (proportional) position in the database"
@ 12,8 SAY "    Click on help, quit or select for those actions."
@ 13,8 SAY "Editing: Hit return to edit a field."
@ 14,8 SAY "Append: Scroll to bottom and hit down arrow (key or on screen with "
@ 15,8 SAY "    mouse) and append in form."
@ 16,8 SAY "Exit: Escape selects none. Alt E selects or use the mouse."
@ 20,8 SAY "Hit any key or mouse button to return to browse."


* wait for button to be released

#ifndef NO_MOUSE

DO WHILE FT_MBUTREL(1)!=0
ENDDO

#endif

*now clear the screen and resume when requested

#ifndef NO_MOUSE
DO WHILE inkey()=0.AND.FT_MGETPOS()=0
#else
DO WHILE inkey()=0
#endif
ENDDO

RESTSCREEN(,,,,savescr)

RETURN NIL
* End of browse_help

*****
*
* Browse_key
*
* forces a key into the buffer to perform a task such as selecting or exiting
*
* Calling Parameters: cAction - Either "QUIT" or "SELECT" as appropriate
*
* Returns: NIL
*
FUNCTION browse_key(cAction)

* Push the key on the input stack - Ugh
* Used the FT_PUTKEY function since KEYBOARD won't put a K_ALT_E in since
* its inkey code > 255

IF cAction=="QUIT"
    FT_PUTKEY(K_ESC)
ELSEIF cAction=="SELECT"
    FT_PUTKEY(K_ALT_E)
ENDIF

RETURN NIL

*End of browse_key

******
*
* Showhelp()
*
* Demo of a when clause
*
* Calling parameters: none
*
STATIC FUNCTION ShowHelp

@ 1,35 SAY "This column contains the state abbreviation."

RETURN .T.

* End of ShowHelp

*****
*
* ClearHelp()
*
* Example of using a valid in read
*
* Calling parameters: none
*
STATIC FUNCTION ClearHelp
LOCAL cOldColor

cOldColor := SetColor("N/BG")
@ 1,35 CLEAR TO 1, 79
SetColor(cOldColor)

RETURN .T.

* End of Clearhelp

#endif



/*  $DOC$
 *  $FUNCNAME$
 *     MBROWSE()
 *  $CATEGORY$
 *     Menus/Prompts
 *  $ONELINER$
 *     Browse an indexed database limited to a while condition with mouse
 *  $SYNTAX$
 *     MBROWSE( <aFields>, <bWhileCond>, <cKey>,
 *                 [<nFreeze>], [<lSaveScrn>], [<cColorList>],
 *                 [<cColorShadow>], [<nTop>], [<nLeft>],
 *                 [<nBottom>], [<nRight>], [<bScreenInit>], [<nReadInit>],
 *                 [<bAltReader>], [<nExitKey>], [<lAppendMode>], 
 *                 [<AppendReader>] ) -> nRecno
 *  $ARGUMENTS$
 *     <aFields> is multidimensional array of field blocks of fields you 
 *        want to display. Each row contains up to four members containing:
 *
 *        Index 1: Column heading
 *        Index 2: Code block for displaying information. Note: if you are
 *                 going to do an a read, this must code block must be written
 *                 so that if a parameter is passed, it will set the GET 
 *                 variable. For example: {|x| IIF(x=NIL,Last,Last:=x) }
 *                 can be used by both browse and the GET system.
 *        Index 3: Optional logical indicating if field can be edited if you
 *                 are allowing edits. By default, if you are allowing edits
 *                 (see below) it is .T., and, obviously, if you are not .F.
 *        Index 4: Optional Picture function for get on this column.
 *        Index 5: Optional Code block to be executed as a WHEN clause.
 *        Index 6: Optional Code block to be executed as a VALID clause.
 *
 *        Example to set up last name and first name in array:
 *        aFields := {}
 *        AADD(aFields, {"Last Name", {||Names->Last}, .T., "!XXXXXXXXXXXXXX" })
 *        AADD(aFields, {"First Name", {||Names->First} } )
 *
 *     <bWhileCond> is the limiting WHILE condition as a block.
 *        If cKey (below) is NIL. This is automatically set to {|| .T.}.
 *        If you will be allowing appends you will want to allow arguments to
 *        be passed so that you can use this while block on data entered by the
 *        user prior to adding it to the database. The third example below
 *        shows such a block (as does the example program above).
 *
 *        Example 1: { ||Names->Last == "JONES" }
 *        Example 2: { ||Names->Last == "JONES" .AND. Names->First == "A"  }
 *        Example 3: { |x| IIF(x=NIL, Names->Last = cKey, x = cKey)}
 *
 *     <cKey> is the key to find top condition of WHILE.  
 *        If NIL the entire database is browsed.
 *        cLast  := "JONES     "
 *        cFirst := "A"
 *        Example 1: cKey := cLast
 *        Example 2: cKey := cLast + cFirst
 *
 *     <nFreeze> is number of fields to freeze in TBrowse.  Defaults
 *     to 0 if not passed.
 *
 *     <lSaveScrn> is a logical indicating whether or not you want to
 *     save the screen from the calling program.  Defaults to .T. if
 *     not passed.
 *
 *     <cColorList> is a list of colors for the TBrowse columns.
 *     The 1st color is used as SAY/TBrowse Background and the
 *     3rd and 4th colors are used as part of column:defColor := {3, 4}

 *     Thus if you pass a cColorList, you MUST pass at least 4 colors.
 *     Defaults to "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R" if not passed.
 *
 *     <cColorShad> is the color of the TBrowse box shadow.  Defaults
 *     to "N/N" if not passed.
 *
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are the coordinates of
 *     the area to display the TBrowse in.  Defaults to 2, 2,
 *     MaxRow() - 2, MaxCol() - 2 with shadowed box, i.e. full screen.
 *
 *     <bScreenInit> is a code block which calls a routine to initialize the
 *     screen after it has been cleared. You could place help or mouse hot
 *     spots on the screen with this routine. If NIL then nothing happens.
 *
 *     <nReadInit> indicates how a read is initiated. The constants 
 *     GET_ON_RETURN and DOUBLE_CLICK_GET are defined in MBROWSE.CH. 
 *     GET_ON_RETURN indicates that a return will initiate a GET on the current
 *     field. DOUBLE_CLICK_GET indicates that a mouse double click will initiate
 *     a GET on the current field. Either one or the sum of the two can be used
 *     to indicate how to initiate a GET. Passing NO_GET or NIL will prevent any 
 *     editing.
 *     Example:
 *            GET_ON_RETURN+DOUBLE_CLICK_GET   will allow both the mouse and
 *                                             return initiated gets
 *
 *     <bAltReader> is a code block which is called in place of the internal
 *     reader when the user requests an edit. If NIL then the internal one is
 *     called. This gives more flexibility in doing reads and actually can
 *     be used for functions other than reads (especially with the mouse).
 *     see the function DoGet for details of what must be passed.
 *
 *     <nExitKey> is a InKey code of a key which will exit the browse other than
 *     the escape key which is always active. By default is is set to K_RETURN
 *     if GETS are not allowed and nothing if they are allowed.
 *
 *     <lAppendMode> indicates if appends to the database are allowed.
 *
 *     <bAppendReader> is a code block which will perform a read and append
 *     when the user requests an append. The routine receives no arguments but
 *     must return the number of records meeting the current while condition
 *     that were appended to the database. NOTE: if you are appending records
 *     under a while condition, do not include records which you may have added
 *     but which do not meet the criteria.
 *
 *  $RETURNS$
 *     nRecno is the number of the record selected by the <Enter> key.
 *     0 is returned if there are either no records matching the WHILE
 *     condition or an <Esc> is pressed instead of an <Enter>
 *  $DESCRIPTION$
 *     This is a demonstration of TBrowse with a WHILE condition for an
 *     indexed database.
 *  $EXAMPLES$
 *     * This example will only show those people with last name of "JONES"
 *     * in the TBNames.dbf which contains at least the fields:
 *     * Last, First, City AND is indexed on Last + First.
 *     LOCAL nRecSel    := 0
 *     LOCAL aFields    := {}
 *     LOCAL bWhile     := {||TBNames->Last = "JONES"}
 *     LOCAL cKey       := "JONES"
 *     LOCAL nFreeze    := 1
 *     LOCAL lSaveScrn  := .t.
 *     LOCAL cColorList := "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R"
 *     LOCAL cColorShad := "N/N"
 *     LOCAL bInitScreen:= {|| FancyScreen()}
 *     LOCAL nReadInit := GET_ON_RETURN+DOUBLE_CLICK_GET  // return and dbl clk
 *     LOCAL bAltReader := NIL  // no alternate reader
 *     LOCAL nExitKey := K_ALT_E // alt-E will get you out
 *     LOCAL lAppendMode := .T. // we will be daring and allow appends
 *     LOCAL bAppendReader := {|| MybrowseReader()} // The reader
 *
 *     USE TBNames INDEX TBNames NEW // indexed on Last + First
 *
 *     * Pass Heading as character and Field as Block including Alias
 *     * To eliminate the need to use FIELDWBLOCK() function in BROWSE()
 *     AADD(aFields, {"Last Name" , ;
 *          {|x| IIF(x=NIL,TBNames->Last, TBNames->Last:=x) },.T.  } )
 *     AADD(aFields, {"First Name", ;
 *          {|x| IIF(x=NIL, TBNames->First, TBNames->First:=x) },.T. } )
 *     AADD(aFields, {"City"      , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T. } )
 *     AADD(aFields, {"Zip Code"  , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T.,;
 *          "@R 99999-9999"})
 *
 *     IF MBROWSE( aFields, bWhile, cKey, nFreeze, lSaveScrn, ;
 *       cColorList, cColorShad, 3, 6, MaxRow() - 2, MaxCol() - 6, bInitScreen,;
 *       nReadInit, bAltReader, nExitKey, lAppendMode, bAppendReader) == 0
 *       ? "Sorry, NO Records Were Selected"
 *     ELSE
 *        ? "You Selected: " + TBNames->Last +" "+ ;
 *           TBNames->First +" "+ TBNames->City
 *     ENDIF
 *
 * Notes: This browse supplies scroll bars with active arrows for both columns
 *     and rows.
 *     Mouse functions: left button on arrow moves one item. 
 *                      Right button on arrow pages up/down or pans left/right.
 *                      Both buttons on arrow moves to top/bottom
 *                      Click on data area moves to that item.
 *                      Double click on item allows edit if programmer desires.
 *     This system was written with reentrancy in mind but it has not been
 *          test for such.
 *
 *     This browse system will handle calling functions set by SET KEY in the
 *     normal way. Two return values (defined in mbrowse.ch) are significant.
 *     REFRESH_CURRENT will cause browse:RefreshCurrent() to be called while
 *     REFRESH_ALL will cause browse:RefreshAll() to be called after your
 *     function is complete.
 *
 *     The information stored about the browse is stored in browse:cargo as an
 *     array. The file mbrowse.ch contains the defines which allow access to
 *     this information including the while code block.
 *
 *  $END$
 */


FUNCTION MBROWSE(aFields, bWhileCond, cKey, nFreeze, lSaveScrn, ;
                    cColorList, cColorShad, nTop, nLeft, nBottom, nRight, ;
                    bScreenInit, nReadInit, bAltReader, nExitKey, lAppendMode,;
                    bAppendReader )

   LOCAL column, cType, i
   LOCAL cHead, bField, lKeepScrn, cScrnSave
   LOCAL cColorSave, cColorBack, nCursSave
   LOCAL lMore, nKey, nPassRec, nTotalWidth:=0, nFrozenWidth:=0
   LOCAL nSepLen, nMouseRow:=0, nMouseCol:=0, nMouseKey, nTime, nDepth
   LOCAL oOldBrowse:=oBrowse
   LOCAL nCur_Rec

// Set default values

  DEFAULT nFreeze     TO 0, ;
          lSaveScrn   TO .t., ;
          cColorList  TO "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R", ;
          cColorShad  TO "N/N", ;
          nTop        TO 2, ;
          nLeft       TO 2, ;
          nBottom     TO MaxRow() - 2, ;
          nRight      TO MaxCol() - 2, ;
          nReadInit   TO NO_GET, ;
          nExitKey    TO IIF(nReadInit%DOUBLE_CLICK_GET=NO_GET,K_RETURN,K_ESC), ;
          lAppendMode TO .F., ;
          bWhileCond  TO {|| .T.}

   lKeepScrn := (PCOUNT() > 6)

   /* make new browse object */
   oBrowse := TBrowseDB(nTop, nLeft, nBottom, nRight)

   /* initialize the browse system */
   IF !init_browse(cKey, bWhileCond, nReadInit, bAltReader, lAppendMode )
         RETURN(0)
   ENDIF

   /* default heading and column separators */
   oBrowse:headSep := ""
   oBrowse:colSep  := "  "
   oBrowse:footSep := ""

   nSepLen=LEN(oBrowse:colSep)

   /* add custom 'TbSkipWhil' (to handle passed condition) */
   oBrowse:skipBlock := {|x| TbSkipWhil(x, oBrowse)}

   /* Set up substitute goto top and goto bottom */
   /* with While's top and bottom records        */
   oBrowse:goTopBlock    := {|| TbWhileTop(oBrowse)}
   oBrowse:goBottomBlock := {|| TbWhileBot(oBrowse)}

   /* colors */
   oBrowse:colorSpec := cColorList

   SAVE_HEADING_DEPTH(oBrowse,2)
   TOTAL_WIDTH(oBrowse)={}
   ASIZE(TOTAL_WIDTH(oBrowse),LEN(aFields)+1)
   SAVE_TOTAL_WIDTH(oBrowse,1,0)
   SAVE_APPEND_BLOCK(oBrowse, bAppendReader)
   SAVE_PROC_NAME(oBrowse,PROCNAME(1))
   SAVE_PROC_LINE(oBrowse,PROCLINE(1))

   /* add a column for each field in the current workarea */
   FOR i = 1 TO LEN(aFields)

      /* make the new column */
      column := TBColumnNew( aFields[i, 1], aFields[i, 2] )

    // If there is a picture and other get parameter variables then save them //

#ifndef NO_EDITS
      column:cargo=ARRAY(C_CARGO_SIZE)
      SAVE_ALLOW_EDIT(column,;
         IIF(LEN(aFields[i])>2, IIF(aFields[i,3]=NIL, .T. ,aFields[i,3]), .T.))
      SAVE_PICTURE(column, IIF(LEN(aFields[i])>3,aFields[i,4],NIL))
      SAVE_WHEN(column, IIF(LEN(aFields[i])>4,aFields[i,5],NIL))
      SAVE_VALID(column, IIF(LEN(aFields[i])>5,aFields[i,6],NIL))
#endif

     // Check to see if heading for this column is larger than previous

      IF HEADING_DEPTH(oBrowse) < (nDepth := 2 + FT_NOOCCUR(";",aFields[i, 1]))
          SAVE_HEADING_DEPTH(oBrowse,nDepth)
      ENDIF

     // column default colors

      column:defColor := {3, 4}

      oBrowse:addColumn(column)

     // Now keep track of the running width of the columns 

      nTotalWidth+=oBrowse:colwidth(i)+nSepLen
      SAVE_TOTAL_WIDTH(oBrowse,i+1,nTotalWidth)

      // Add up width of frozen columns 

      IF i<=nFreeze
         nFrozenWidth+=oBrowse:colwidth(i)+nSepLen
      ENDIF

   NEXT

   // freeze columns 
   IF nFreeze <> 0
      oBrowse:freeze := nFreeze
   ENDIF
   SAVE_FREEZE_WIDTH(oBrowse,nFrozenWidth)

   // save old screen and colors 
   IF lSaveScrn
      cScrnSave = SAVESCREEN(0, 0, MAXROW(), MAXCOL())
   ENDIF
   cColorSave := SetColor()

   // Background Color Is Based On First Color In Passed cColorList
   cColorBack := IF(',' $ cColorList, ;
      SUBSTR(cColorList, 1, AT(',', cColorList) - 1), cColorList )

   IF .NOT. lKeepScrn
      SetColor(cColorBack)
      CLEAR SCREEN
   ENDIF

   // make a window shadow 
   SetColor(cColorShad)
   @ nTop+1, nLeft+1 CLEAR TO nBottom+1, nRight+1
   SetColor(cColorBack)
   @ nTop, nLeft CLEAR TO nBottom, nRight
   SetColor(cColorSave)

   // get the number of records and the current record number
   // used for scroll bars and updating screen

    SAVE_TOTAL_COUNT(oBrowse,CountRec(@nCur_Rec,oBrowse))
    SAVE_RECORD_NUM(oBrowse,nCur_Rec)

   // Initialize the scroll bars 

#ifndef NO_SIDE_SCROLL
   RecScroll()
#endif
#ifndef NO_BOTTOM_SCROLL
   ColScroll()
#endif


   // Execute caller's screen setup routine
   IF VALTYPE(bScreenInit)="B"
      EVAL(bScreenInit)
   ENDIF

   nCursSave := SetCursor(SC_NONE)

   lMore := .t.
   WHILE (lMore)
      /* stabilize the display */
      nKey=0
      nMouseKey=0
      DO WHILE (nKey==0 .AND. nMouseKey ==0 .AND. .NOT. oBrowse:stable() )
         oBrowse:stabilize()
         nKey := INKEY()
#ifndef NO_MOUSE
         nMouseKey := IIF(lMouseUsed,FT_MGETPOS(@nMouseRow,@nMouseCol),0)
#endif

      ENDDO

      IF ( oBrowse:stable )

/* Update scroll bars */

#ifndef NO_SIDE_SCROLL
         ScrollBarUpdate(VERT_SCROLL(oBrowse),RECORD_NUM(oBrowse),TOTAL_COUNT(oBrowse), .F.)
#endif
#ifndef NO_BOTTOM_SCROLL
         ScrollBarUpdate(HORIZ_SCROLL(oBrowse),oBrowse:colpos,oBrowse:colCount,.F.)
#endif

         /* display is stable */
         IF ( oBrowse:hitBottom .AND. ALLOW_APPEND_MODE(oBrowse) )
/* banged against End Of Logical File; go into append mode */
               DoAppend()
               nKey=0
               nMouseKey=0
         ELSE

/* normal mode */
              IF ( oBrowse:hitTop .OR. oBrowse:hitBottom )
                 Tone(125, 0)
              ENDIF

// Make sure that the current record is showing
// up-to-date data in case we are on a network.

              oBrowse:refreshCurrent()
              ForceStable(oBrowse)

* everything's done; just wait for a key or mouse input
* Show and hide the cursor so that others won't have to worry
* about writing over it.


               IF lMouseUsed
#ifndef NO_MOUSE
                  FT_MSHOWCRS()

                  nKey=0
                  nMouseKey=0
                  DO WHILE (nKey=0).AND.(nMouseKey=0)
                     nMousekey=FT_MGETPOS(@nMouseRow,@nMouseCol)
                     nKey=INKEY()
                  ENDDO

* if we have input from the mouse then convert the mouse coordinates
* Get time so we can time a double click if necessary

                  IF  nMouseKey>0
                     nTime=SECOND()
                  ENDIF

                  FT_MHIDECRS()
#endif
               ELSE
                  nMouseKey=0
                  nKey=INKEY(0)
               ENDIF
        ENDIF

      ENDIF

 /* process input */

      DO CASE
       CASE nKey == K_ESC
 /* Exit so do it */
          lMore = .F.
          nPassRec=0

 /* Mouse input */
        CASE nMouseKey>0

#ifndef NO_MOUSE
           lMore = MouseFunc(nMouseKey,nMouseRow,nMouseCol,nTime)
#endif
 /* Special exit request key */

        CASE nKey == nExitKey
           lMore = .F.
           nPassRec = RECNO()

 /* Normal Key input */
        CASE nKey != 0
           lMore = ApplyKey(nKey)
           nPassRec=RECNO()  

 /* Falls through for case where we do an append */

       ENDCASE


   ENDDO  // for WHILE (lmore)

   /* restore old screen */
   IF lSaveScrn
      RESTSCREEN(0, 0, 24, 79, cScrnSave)
   ENDIF

 /* Remove hot spots for scroll bars */

#ifndef NO_SIDE_SCROLL
#ifndef NO_MOUSE
   BRRemHotSpot(VERT_SCROLL(oBrowse)[SB_MOUSEID])
#endif
#endif
#ifndef NO_BOTTOM_SCROLL
#ifndef NO_MOUSE
   BRRemHotSpot(HORIZ_SCROLL(oBrowse)[SB_MOUSEID])
#endif
#endif

/* reset cursor and colors */

   SetCursor(nCursSave)
   SetColor(cColorSave)

* Restore any previous browse if necessary

oBrowse=oOldBrowse

RETURN (nPassRec)


****
* TbSkipWhil()
*
* Special skip function to handle while condition, append mode and mouse
*
* Calling parameters: n - The number of records to skip
*                     oBrowse - The current browse

STATIC FUNCTION TbSkipWhil(n, oBrowse)
   LOCAL i

    i := 0

* Don't move or no records

    IF n == 0 .OR. LASTREC() == 0

        // Skip 0 (significant on a network)
        SKIP 0

    ELSEIF (n > 0 .and. RECNO() <> LASTREC() + 1)

  // Skip forward
        DO WHILE i < n
            SKIP 1
            IF ( EOF() .OR. .NOT. EVAL(WHILE_BLOCK(oBrowse)))
                SKIP -1
                EXIT
            ENDIF

            i++
        ENDDO

    ELSEIF n < 0

 // Skip backward
        DO WHILE i > n
            SKIP -1
            IF .NOT. EVAL(WHILE_BLOCK(oBrowse))
                SKIP 1
                EXIT
            ELSEIF  BOF()
                EXIT
            ENDIF

            i--
        ENDDO

    ENDIF

* update the record pointer for the scroll bars

    SAVE_RECORD_NUM(oBrowse,RECORD_NUM(oBrowse)+i)

    RETURN i

* EOFcn TbSkipWhil()


*****
* TbWhileTop
*
* Function to go to the top of the active portion of the database
*
* Calling parameters: oBrowse - The current browse object
*

STATIC FUNCTION TbWhileTop(oBrowse)
   LOCAL cSoftSave := SET(_SET_SOFTSEEK, .t.)
   IF SEEK_KEY(oBrowse)!=NIL
      SEEK SEEK_KEY(oBrowse)
   ELSE
      GOTO TOP
   ENDIF
   SET(_SET_SOFTSEEK, cSoftSave)
RETURN NIL

*****
*
*  TbWhileBot
*
* Function to go to the bottom of the active portion of the database
*
* Calling parameters: oBrowse - The current browse object
*

STATIC FUNCTION TbWhileBot(oBrowse)
   * SeekLast: Finds Last Record For Matching Key
   * Developed By Jon Cole
   * With softseek set on, seek the first record after condition.
   * This is accomplished by incrementing the right most character of the
   * string cKey by one ascii character.  After SEEKing the new string,
   * back up one record to get to the last record which matches cKey.
   #include "set.ch"
   LOCAL cSoftSave := SET(_SET_SOFTSEEK, .t.), cKey
   cKey=SEEK_KEY(oBrowse)
   IF cKey=NIL
      GOTO BOTTOM
   ELSE
      SEEK LEFT(cKey, LEN(cKey) -1) + CHR( ASC( RIGHT(cKey,1) ) +1)
      SET(_SET_SOFTSEEK, cSoftSave)
      SKIP -1
   ENDIF
RETURN NIL

******
* Init_Browse()
*
* Initializes the browse system for this browse object includeing the mouse
*
* Calling Parameters:  cKey - Character key for seek if browse in funtioning
*                              in "while" mode
*                      bWhileCond - Code block for evaluating the while 
*                              condition
*                      nReadInit - action of hitting return flag
*                      bAltReader - any alternate reader for gets
*                      lAppendMode - Logical indicating allow append during
*                              browse
*
* Returns: .F. if no records are present or none fit while condition
*

STATIC FUNCTION init_browse( cKey, bWhileCond, nReadInit, bAltReader, ;
                            lAppendMode )

/* fill in the cargo variables */

   oBrowse:cargo:=ARRAY(B_CARGO_SIZE)

/* default actions */

#ifndef NO_APPENDS
   SET_ALLOW_APPEND(oBrowse,lAppendMode)
#else
   SET_ALLOW_APPEND(oBrowse,.F.)
#endif
   SAVE_RETURN_ACTION(oBrowse,nReadInit%DOUBLE_CLICK_GET)
   SAVE_DOUBLE_CLICK(oBrowse,(nReadInit/DOUBLE_CLICK_GET>0.9))
   SAVE_WHILE_BLOCK(oBrowse,bWhileCond)  && default actions
   SAVE_ALT_READER(oBrowse,bAltReader)

/* If we are using the while portion then test for a record being present */

   IF cKey!=NIL

/* Save the key and while block information */

      SAVE_SEEK_KEY(oBrowse,cKey)
      SAVE_WHILE_BLOCK(oBrowse,bWhileCond)

/* If we are at a record that fits the bill then we will assume the caller
   wants to start here */

       IF .NOT.EVAL(bWhileCond)
/* Find the top and make sure we fit the criteria */
         TbWhileTop(oBrowse)
         IF .NOT. FOUND() .OR. LASTREC() == 0 .OR. !EVAL(bWhileCond)
            RETURN(.F.)
         ENDIF

       ENDIF

   ELSE

/* Use default values if while condition not being used */

      SAVE_SEEK_KEY(oBrowse,NIL)
      SAVE_WHILE_BLOCK(oBrowse,{|| .T.})
/* We will assume the caller wants to stay at this record */

   ENDIF

/* Initialize mouse if present */

IF !lIgnoreMouse
#ifndef NO_MOUSE
    lMouseUsed=FT_MINIT()
#endif
ELSE
    lMouseUsed=.F.
ENDIF

/* Now return */

RETURN .T.

#ifndef NO_SIDE_SCROLL
*****
*
* RecScroll()
*
* Purpose: initialize scroll bars for side
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/30/91   LJL       Initial Version
*
* Calling Parameters: none
*
* Returns: NIL
*
STATIC FUNCTION RecScroll()

LOCAL nT, nL, nB, nR
LOCAL aBar[SB_ELEMENTS]

* If we have no room then don't do any work

IF oBrowse:nLeft>0

* build the scroll bar and display it

    SAVE_VERT_SCROLL(oBrowse,ScrollBarNew(OBrowse:nTop,OBrowse:nLeft-1,;
         OBrowse:nBottom,,1,SB_VERTICAL))

    ScrollBarDisplay(VERT_SCROLL(oBrowse))

    ScrollBarUpdate(VERT_SCROLL(oBrowse),;
        RECORD_NUM(oBrowse), TOTAL_COUNT(oBrowse), .T.)

* Save the hot spot in the browse

#ifndef NO_MOUSE
    VERT_SCROLL(oBrowse)[SB_MOUSEID]=BRHotSpot(VERT_SCROLL(oBrowse)[SB_ROWTOP],;
               VERT_SCROLL(oBrowse)[SB_COLTOP],;
               VERT_SCROLL(oBrowse)[SB_ROWBOTTOM],;
               VERT_SCROLL(oBrowse)[SB_COLBOTTOM],;
               {|nB,nRow,nCol,nTime,oB| mousescroll(nB,nRow,nCol,nTime,oB)},;
               0,0.1,.F.)
#endif

ENDIF

RETURN NIL

* End of RecScrol

#endif

#ifndef NO_BOTTOM_SCROLL
*****
*
* ColScroll()
*
* Purpose: initialize scroll bars for bottom
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/1/91    LJL       Initial Version
*
* Calling Parameters: none
*
* Returns: NIL
*
STATIC FUNCTION ColScroll()

* if we have room then do the work

IF oBrowse:nBottom<MAXROW()
* build the scroll bar and display it

    SAVE_HORIZ_SCROLL(oBrowse,ScrollBarNew(OBrowse:nBottom+1,OBrowse:nLeft,;
        OBrowse:nRight,,1,SB_HORIZONTAL))

    ScrollBarDisplay(HORIZ_SCROLL(oBrowse))

    ScrollBarUpdate(HORIZ_SCROLL(oBrowse),OBrowse:colpos,OBrowse:colCount, .T.)

* Add a mouse event for the scroll bar and save it in the browse

#ifndef NO_MOUSE
     HORIZ_SCROLL(oBrowse)[SB_MOUSEID]=BRHotSpot(HORIZ_SCROLL(oBrowse);
                    [SB_ROWTOP],;
                    HORIZ_SCROLL(oBrowse)[SB_COLTOP],;
                    HORIZ_SCROLL(oBrowse)[SB_ROWBOTTOM],;
                    HORIZ_SCROLL(oBrowse)[SB_COLBOTTOM],;
                    {|nB,nRow,nCol,nTime,oB| mousescroll(nB,nRow,nCol,nTime,oB)},;
                    0,0.2,.F.)
#endif

ENDIF

RETURN NIL

* End of ColScrol
#endif

*****
*
* ApplyKey
*
* This routine handles the appropriate action for each key entered
*
* Calling parameters: nKey - the inkey code of the pressed key
*
* Returns: .T. if the browse should continue, .F. if it should not. This
*           action is based upon the callers indication of action to be
*           taken on the user hitting return
*
STATIC FUNCTION ApplyKey(nKey)

* Local variables

LOCAL lMore:=.T.  && signal to continue browse - default is yes
LOCAL i, j, k, done, nAction
LOCAL bKeyBlock

* handle the movement keys

  DO CASE
     CASE ( nKey == K_DOWN )
        oBrowse:down()

     CASE ( nKey == K_UP )
        oBrowse:up()

     CASE ( nKey == K_PGDN )
        oBrowse:pageDown()

     CASE ( nKey == K_PGUP )
        oBrowse:pageUp()

     CASE ( nKey == K_CTRL_PGUP )
        SAVE_RECORD_NUM(oBrowse,1)
        oBrowse:goTop()

     CASE ( nKey == K_CTRL_PGDN )

* Note: we must save the record number before calling oBrowse:goBottom since
* the browse object will call the skipper to move the display to the top of
* the screen page in the goBottom but waits until stabilization time to move
* back to the last record.

        SAVE_RECORD_NUM(oBrowse,TOTAL_COUNT(oBrowse))
        oBrowse:goBottom()

     CASE ( nKey == K_RIGHT )
         oBrowse:right()

     CASE ( nKey == K_LEFT )
         oBrowse:left()

     CASE ( nKey == K_HOME )
         oBrowse:home()

     CASE ( nKey == K_END )
         oBrowse:end()

     CASE ( nKey == K_CTRL_LEFT )
         oBrowse:panLeft()

     CASE ( nKey == K_CTRL_RIGHT )
         oBrowse:panRight()

     CASE ( nKey == K_CTRL_HOME )
         oBrowse:panHome()

     CASE ( nKey == K_CTRL_END )
         oBrowse:panEnd()

     CASE ( nKey == K_ESC )
         lMore := .f.

     CASE ( nKey == K_RETURN )

* Action is based upon caller's directive

          IF RETURN_ACTION(oBrowse)==GET_ON_RETURN
               lMore := DoGet()
          ENDIF

     OTHERWISE
* Now handle any function keys specified by caller

         IF ((bKeyBlock:=SetKey(nKey)) <> NIL)
              nAction=EVAL(bKeyBlock,PROC_NAME(oBrowse), PROC_LINE(oBrowse))
* Update screen based upon callers desire
              IF nAction=NIL

              ELSEIF nAction==REFRESH_CURRENT
                    oBrowse:refreshCurrent()
              ELSEIF nAction==REFRESH_ALL
                    oBrowse:RefreshAll()
              ENDIF
         ELSE

* No action taken so ring the bell
             Tone(125, 0)
         ENDIF

     ENDCASE

* Done so return

RETURN lMore

* End of ApplyKey

***
*   DoGet()
*   Do a GET for the current column in the browse.
*
* Calling parameters: none
*
* Returns: logical indicating if browse should continue. It is set to .F.
*          when the user has modified the only record showing and it no longer
*          fits the while condition
*

STATIC FUNCTION DoGet()

    LOCAL lMore:=.T.
#ifndef NO_EDITS

    LOCAL bIns, lScore, lExit
    LOCAL oCol, getList, nKey, new_rec := 0
    LOCAL xOldKey, xNewKey, nRecIncr, nRecNum, lForceUpdate:=.F.

// Get the current column object from the oBrowse

oCol := oBrowse:getColumn(oBrowse:colPos)

// If the user is allowed to edit the field then do so

IF ALLOW_EDIT(oCol)

    // Make sure screen is fully updated, dbf position is correct, etc.
    ForceStable(oBrowse)

    // If the caller supplied an alternate reader code block then use it

    IF VALTYPE(ALT_READER(oBrowse))="B"
        lMore=EVAL(ALT_READER(oBrowse))

    // otherwise use our own

    ELSE

    // Save the current record's key value (or NIL)
    // (for an explanation, refer to the rambling note below)
        xOldKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )

    // save alternate record in case we change the index value and will
    // no longer fit into the while condition
        nLastRec=0
        IF RECORD_NUM(oBrowse)=1 .AND. SEEK_KEY(oBrowse)!=NIL
           SKIP 1
           IF EVAL(WHILE_BLOCK(oBrowse))
              nLastRec=RECNO()
              nRecIncr=1
           ENDIF
           SKIP -1
        ELSEIF SEEK_KEY(oBrowse)!=NIL
           SKIP -1
           IF EVAL(WHILE_BLOCK(oBrowse))
              nLastRec=RECNO()
              nRecIncr=-1
              SKIP 1
           ELSE
              SKIP 2
              IF EVAL(WHILE_BLOCK(oBrowse)).AND..NOT.EOF()
                 nLastRec=RECNO()
                 nRecIncr=1
              ENDIF
              SKIP -1
           ENDIF
        ENDIF

    // Save global state
        lScore := Set(_SET_SCOREBOARD, .F.)
        lExit := Set(_SET_EXIT, .T.)
        bIns := SetKey(K_INS)

    // Set insert key to toggle insert mode and cursor shape
        SetKey( K_INS, {|| InsToggle()} )

    // Set initial cursor shape
        SetCursor( IF(ReadInsert(), SC_INSERT, SC_NORMAL) )

    // Create a corresponding GET

        GetList := {GetNew(Row(),Col(),oCol:block,oCol:heading;
                ,GET_PICTURE(oCol);
                ,oBrowse:colorSpec)}
        GetList[1]:preBlock=GET_WHEN(oCol)
        GetList[1]:postBlock=GET_VALID(oCol)

    // Read it using the standard reader
    // NOTE: for a shared database, an RLOCK() is required here

        READ

    // If the record no longer fits the while condition then move to the
    // alternate record
        IF .NOT. EVAL(WHILE_BLOCK(oBrowse))
              IF nLastRec>0
                   GOTO nLastRec
* Reset scroll bar counters

                   SAVE_TOTAL_COUNT(oBrowse,TOTAL_COUNT(oBrowse)-1)
                   SAVE_RECORD_NUM(oBrowse,RECORD_NUM(oBrowse)+nRecIncr)
              ELSE
                 lMore=.F.
              ENDIF
        ENDIF

    // Restore state
        SetCursor(0)
        Set(_SET_SCOREBOARD, lScore)
        Set(_SET_EXIT, lExit)
        SetKey(K_INS, bIns)

    // Get the record's key value (or NIL) after the GET
        xNewKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )

    // If the key has changed (or if this is a new record)
        IF lMore .AND. ((.NOT.(xNewKey == xOldKey)) .OR. lForceUpdate)

        // save current record information

        CountRec(@nRecNum,oBrowse)
        SAVE_RECORD_NUM(oBrowse,nRecNum)

        // Try to force screen to correct position

           CorrectScreen(xNewKey)

        ENDIF


    // Check exit key from get
        nKey := LASTKEY()
        IF nKey == K_UP .OR. nKey == K_DOWN .OR. ;
            nKey == K_PGUP .OR. nKey == K_PGDN

        // Ugh
            KEYBOARD( CHR(nKey) )

        ENDIF

    ENDIF
ENDIF

#endif

RETURN lMore

* End of DoGet


*******
*  DoAppend
*
* This routine will finish the handling of appended records
*
* Calling parameters: none
*
* Returns: NIL
*

STATIC FUNCTION DoAppend()

#ifndef NO_APPENDS

LOCAL xNewKey, xOldKey, nNewRec, nNew, nLastRec
LOCAL lScore, lExit, bIns, nOldRec


    // Make sure screen is fully updated, dbf position is correct, etc.

    ForceStable(oBrowse)

    // Save the current record's key value (or NIL)
    // (for an explanation, refer to the rambling note above in DoGet)
    xOldKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )

    // Save global state
    lScore := Set(_SET_SCOREBOARD, .F.)
    lExit := Set(_SET_EXIT, .T.)
    bIns := SetKey(K_INS)

    // Set insert key to toggle insert mode and cursor shape
    SetKey( K_INS, {|| InsToggle()} )

    // Set initial cursor shape
    SetCursor( IF(ReadInsert(), SC_INSERT, SC_NORMAL) )

    // Now use the callers routine to get new records. The number returned is
    // the number of new records. 

     IF ((nNew:=EVAL(APPEND_BLOCK(oBrowse)))=0) .OR.;
         (.NOT.EVAL(WHILE_BLOCK(oBrowse)) )

* If we were not left on a valid record return to the bottom again
          oBrowse:goBottom()
          forceStable(oBrowse)
     ENDIF

* Restore state
    SetCursor(0)
    Set(_SET_SCOREBOARD, lScore)
    Set(_SET_EXIT, lExit)
    SetKey(K_INS, bIns)

* Reset the Browse based if things have changed. See Long winded explanation
* above in DOGET for what is going on here

    // Get the record's key value (or NIL) after the GET
    xNewKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )

    // If the key has changed (or if this is a new record)
    IF  .NOT.(xNewKey == xOldKey) .OR. nNew > 0

    // Fix the screen

        CorrectScreen(xNewKey)

    ENDIF


* Reset scroll bar counters

     SAVE_TOTAL_COUNT(oBrowse,CountRec(@nNewRec,oBrowse))
     SAVE_RECORD_NUM(oBrowse,nNewRec)

#endif

 RETURN NIL

* End of DoAppend

******
*
*   CorrectScreen
*
* Purpose: correct the browse screen after edits and large moves
*
* Calling Parameters:  xNewKey  - The current keyvalue of the current record
*
* Returns: NIL
*
* This was moved from TBDEMO.PRG. The explanation follows:
*
    // What this next piece of code does:
    //
    // When a TBrowse stabilizes, it always tries to leave the
    // same "cell" highlighted as was previously highlighted. That
    // is, it always tries to keep the highlight at the same position
    // within the browse window unless it is explicitly moved via an
    // "up" or "down" message. The TBrowse positions the data source
    // in a corresponding fashion. If there aren't enough rows left
    // in the data source (i.e. EOF is encountered while trying to
    // adjust the database to match the window), the TBrowse will
    // relent and move the cursor upward, leaving it on the correct
    // record but with part of the window unfilled.
    //
    // That works OK for logical EOF, but a problem can occur when
    // a GET on a key field causes the current record to move so
    // close to logical BOF that it is impossible to highlight the
    // correct record while leaving the highlight at its previous
    // position within the window. In this case, TBrowse opts to
    // leave the highlight in the same position within the window,
    // even though that position no longer corresponds with the same
    // record as before. That is, it repositions the database as far
    // as it will go, then leaves the highlight where it was. The
    // result is that you end up with the highlight on a different
    // record than the one you just edited.
    //
    // The following piece of code addresses this by checking to see
    // if the current record's key value changed during the GET. If
    // so (or if the record is a new record, just appended), the code
    // below forces a complete refresh and a full stabilization. It
    // then checks to see if this caused the TBrowse to position the
    // database to a different record than before. If so, the old
    // record is assumed to be somewhere "above" the current record,
    // and a series of "up" messages are issued to the browse to get
    // the highlight to move up to the proper position.

STATIC FUNCTION CorrectScreen(xNewKey)

LOCAL nRecNum:=RECNO()
LOCAL nBack, nOldRec, i

   DISPBEGIN()

// Do a complete refresh
    oBrowse:refreshAll()
    ForceStable(oBrowse)

// Make sure we're still on the right record after stabilizing
    DO WHILE &(INDEXKEY()) >= xNewKey .AND. .NOT. oBrowse:hitTop();
       .AND. RECNO()!=nRecNum
          oBrowse:up()
          ForceStable(oBrowse)
    ENDDO

 // Check to see if we have a full screen. If not and we have a enough
 // records then move the display around to get a full screen.

    nBack=TOTAL_COUNT(oBrowse)-RECORD_NUM(oBrowse)

    IF  oBrowse:RowCount-oBrowse:RowPos> nBack

          nOldRec=RECORD_NUM(oBrowse)
          oBrowse:GoBottom()
          FOR i= 1 TO nBack
              oBrowse:up()
          NEXT
          ForceStable(oBrowse)
          SAVE_RECORD_NUM(oBrowse,nOldRec)
    ENDIF

    DISPEND()


RETURN NIL

* End of CorrectScreen



***
*   ForceStable()
*   Force a complete stabilization of a TBrowse.
*

STATIC FUNCTION ForceStable(browse)

    DISPBEGIN()
    DO WHILE .NOT. browse:stabilize()
    ENDDO
    DISPEND()

    RETURN NIL

* End of ForceStable


***
*   InsToggle()
*   Toggle the global insert mode and the cursor shape.
*

STATIC FUNCTION InsToggle()

    IF READINSERT()
        READINSERT(.F.)
        SETCURSOR(SC_NORMAL)

    ELSE
        READINSERT(.T.)
        SETCURSOR(SC_INSERT)

    ENDIF

    RETURN NIL

* end of insToggle


*****
*
* CountRec()
*
* Purpose: Counts the number of active records for use on scroll bars
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/10/91   LJL       Initial Version
*
* Calling Parameters: nCur_rec - BY REFERENCE - the position of the
*                              current record
*
* Returns: number of records active
*
STATIC FUNCTION CountRec(nCur_rec,browse)

LOCAL nNumRecords
LOCAL old_skip, skip_amt, done, nNumCur, save_rec
LOCAL last_rec, i, incr, Rec_cnt, first_record

* Save current record number

save_rec=RECNO()

* Go to top record

TbWhileTop(browse)
first_record=RECNO()

incr=1
i=1
DO WHILE i<3

	last_rec=RECNO()
	Rec_cnt=1

* Initial amount to skip

	skip_amt=INT(RECCOUNT()/2)*incr
	done=.F.

	DO WHILE !done

* skip and see where we are

		SKIP skip_amt

		IF (IIF(incr=-1,BOF(),EOF())) .OR. !EVAL(WHILE_BLOCK(browse))

*  hit the end so we really don't know what happened

			old_skip=Skip_amt
			skip_amt=INT((skip_amt+incr)/2)
* If we are skipping no more then we are done
			done=skip_amt==incr.AND.old_skip==incr
			GOTO last_rec
		ELSE

* Not to the end so add the amount we skipped

			Rec_cnt+=skip_amt*incr
			last_rec=RECNO()
			old_skip=skip_amt
			skip_amt=INT((skip_amt+incr)/2)
		ENDIF

	ENDDO

*move only one so we are maybe done
	IF i=1
		nNumRecords=Rec_cnt
		incr=-1
		GOTO save_rec
		i++
		IF save_rec=first_record
			nCur_rec=1
			i=4
		ENDIF
	ELSE
		nCur_rec=Rec_cnt
		i=4
	ENDIF

ENDDO

* Go back to original record
GOTO save_rec

RETURN nNumRecords

* End of CountRec

*****
*
* ActiveBrowse()
*
* Purpose: returns the currently active browse
*
* Calling parameters: none
*
* Returns: the currently active browse object
*
FUNCTION ActiveBrowse

RETURN(oBrowse)

* End of ActiveBrowse

#ifndef NO_MOUSE
*****
*
* MouseFunc()
*
* This function determines if the mouse is in the browse area and if it is then
* action needs to be taken. 
* Additionally this routine processes any screen "hot spots" which are selected
* by the user. 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/27/91   LJ Letendre   Initial Version
*
* Calling Parameters:
*                    nButton - Button which was hit - reserved for future
*                    nRow - Row coordinate of mouse pointer when button hit
*                    nCol - Col coordinate of mouse pointer
*                    nTime - The system time that the button was clicked
* Returns: NIL
*
* Notes: The processing of "Hot Spots" occurs prior to checking for the
* cursor being in a the browse. Therefore, the code block will be executed
* without the check for moving the cursor to another get.
*
*

STATIC FUNCTION MouseFunc(nButton, nRow, nCol, nTime)

*
* Local variables:
*
LOCAL j, working, nAction, done, col_right, k
LOCAL lMore:=.T.

* if we have input from the mouse then convert the mouse coordinates
* Clear button press counts so call can determine double click easily

IF nButton%2=1 && left button 
     FT_MBUTPRS(0)
       ENDIF
IF (INT(nButton/2)%2)=1 && right button
    FT_MBUTPRS(1)
ENDIF
IF (nButton>=4) && middle button
    FT_MBUTPRS(2)
ENDIF
nRow=INT(nRow/8)
nCol=INT(nCol/8)

* Set flag to denote completion

working=.T.

* First check to see if any action hot spots were clicked on

j=1
DO WHILE (j<=LEN(AMouseSpot).AND.working)

* Check coordinates
	working=.NOT.(AMouseSpot[j,9].AND.;
				nRow>=AMouseSpot[j,1].AND.nRow<=AMouseSpot[j,3].AND.;
				nCol>=AMouseSpot[j,2].AND.nCol<=AMouseSpot[j,4].AND.;
				(AMouseSpot[j,8]=0.OR.AMouseSpot[j,8]=nButton))

* If we have a match then execute the code block

	IF .NOT.working

* do the request

		nAction=EVAL(AMouseSpot[j,5],nButton,nRow,nCol,nTime,oBrowse)

* Take the appropriate action if requested
          IF nAction=NIL

		ELSEIF nAction=REFRESH_CURRENT
			oBrowse:refreshCurrent()
		ELSEIF nAction=REFRESH_ALL
			oBrowse:refreshAll()
		ENDIF

* Wait for release if requested
		IF AMouseSpot[j,7]
			DO WHILE FT_MBUTREL(1)!=0
			ENDDO
		ENDIF

* Pause for the minimum amount of time

		sleep(AMouseSpot[j,6],nTime)
	ENDIF
* increment counter
	j++

ENDDO

* if we did not find a hit then continue on
IF working

* move the cursor as requested
	lMore = MoveCursor(nRow, nCol, nButton, nTime)

* Wait for release so that scrolling or hot spots are not
* messed up by not releasing quickly enough

	DO WHILE FT_MBUTREL(0)!=0
	ENDDO

ENDIF

* Now return

RETURN lMore

* End of  MouseFunc

******
*
*  MoveCursor()
*
* Purpose: move the cursor to the specified location-initiate read on dbl click
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/30/91   LJ Letendre   Initial Version
* 
* Calling parameters: nRow - Current mouse Row
*                     nCol - Current mouse Column
*                     nButton - Mouse Button hit
*                     nTime - Time the button was hit
*
* Returns: logical value indicating if the browse should continue. See DoGet
*          for when this gets changed.
*
* Note: This routine is not operational during an append READ therefore
*       the read can not be terminated with the mouse.

STATIC FUNCTION MoveCursor(nRow, nCol, nButton, nTime)

LOCAL j, k, col_right, nMove, done, nLeftOffset, nLeftSkew
LOCAL nRightSkew, nColSep, nLeftCol, nSkew, lMore:=.T.
STATIC nOldRow, nOldCol, nOldTime

* Search for a match in coordinates

IF nRow>=oBrowse:nTop+HEADING_DEPTH(oBrowse);
		.AND.nRow<= oBrowse:nBottom-nBotDepth;
		.AND.nCol>=oBrowse:nLeft;
		.AND.nCol<=oBrowse:nRight

* check for double click first if necessary and if it was then edit the field

	IF DOUBLE_CLICK(oBrowse) .AND. nButton=1 .AND. nOldRow=nRow ;
		.AND. nOldCol=nCol .AND. (nTime-nOldTime)<=nDblClkTime

		lMore:=DoGet()

	ELSEIF nButton=1
* Left Button
		nMove=nRow-obrowse:nTop-oBrowse:rowpos+1-HEADING_DEPTH(oBrowse)
* move up or down
		IF nmove>0
			FOR j=1 TO nmove
				oBrowse:down()
			NEXT
		ELSEIF nMove<0
			FOR j=1 TO -nmove
				oBrowse:up()
			NEXT
		ENDIF

* Move left or right

* Figure if we are moving into a column
* First the empty space on the left is determined. Note if oB:leftvisible=0
*     then all of the columns are frozen

		nColSep=LEN(oBrowse:colSep)
		nLeftCol=oBrowse:nLeft  // just a feeling that this will be faster
		nSkew=1+oBrowse:nRight-nLeftCol-FREEZE_WIDTH(oBrowse);
			-IIF(oBrowse:leftvisible>0,;
			 (TOTAL_WIDTH(oBrowse)[oBrowse:rightvisible+1];
			 -TOTAL_WIDTH(oBrowse)[oBrowse:leftvisible]),0)+nColSep

		nLeftSkew=INT(nSkew/2)
          nRightSkew=nSkew-nLeftSkew+nColSep
		nLeftCol-=(nColSep/2)

* If we need to go to a frozen column do the work here

          IF nCol<(nLeftCol+FREEZE_WIDTH(oBrowse))

* Figure which column we need to go to
			done=.F.
			j=0
			DO WHILE .NOT.done .AND. j<oBrowse:freeze
				j++
                    done=(nCol<(nLeftCol+TOTAL_WIDTH(oBrowse)[j+1]))
			ENDDO

* In the moveable columns

		ELSE
			done=.F.
			j=oBrowse:leftvisible
			nLeftSkew+=nLeftCol+FREEZE_WIDTH(oBrowse)-TOTAL_WIDTH(oBrowse)[j]
			j--
			DO WHILE .NOT. done .AND. j<oBrowse:rightvisible
				j++
				IF j=oBrowse:rightvisible
					nLeftSkew+=nRightSkew
				ENDIF
				done=(nCol<(nLeftSkew+TOTAL_WIDTH(oBrowse)[j+1]))
			ENDDO
		ENDIF
 
* Now move
		nMove=oBrowse:colpos-j
		IF nMove>0.AND.done
			FOR j=1 TO nMove
				oBrowse:left()
			NEXT
		ELSEIF done
			FOR j=1 TO (-nMove)
				oBrowse:right()
			NEXT
		ENDIF
* check for double click, if requested, and if so then do a get

* Save old coordinates and time
		nOldRow=nRow
		nOldCol=nCol
		nOldTime=nTime

	ENDIF
ENDIF

RETURN lMore

* End of MoveCursor

*****
*
* MouseScroll()
*
* Purpose: process mouse scrolling requests
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/2/91    LJL       Initial Version
*
* Calling Parameters: nBut - The button number 1=Left 2=Right, 3=Both
*                     nRow - The row that the cursor is in when hit
*                     nCol - The column the mouse was in when hit
*                     nTime - The time the button was hit
* 
* Returns: REFRESH_CURRENT or REFRESH_ALL as defined in browse.ch

STATIC FUNCTION MouseScroll(nBut,nRow,nCol,nTime)

LOCAL aScrollBar, result:=0
LOCAL nScrollHeight, nNewRec, i, nSkip
Local Strng:=""

* Get the scroll bar information

aScrollBar=IIF(VERT_SCROLL(oBrowse)[SB_COLTOP]=nCol,;
		    VERT_SCROLL(oBrowse),HORIZ_SCROLL(oBrowse))

* Determine where we are

* On the left or top arrow

IF nRow=aScrollbar[SB_ROWTOP].AND.nCol=aScrollBar[SB_COLTOP]

* Left button
	IF nBut=1
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL
			oBrowse:up()
		ELSE
			oBrowse:left()
		ENDIF

* Right Button
	ELSEIF nBut=2
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL

			oBrowse:pageUp()

		ELSE
			oBrowse:panLeft()
		ENDIF
* Both buttons
	ELSEIF nBut=3
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL
		     SAVE_RECORD_NUM(oBrowse,1)
			oBrowse:goTop()
* force a wait for release
			DO WHILE FT_MBUTREL(1)!=0
			ENDDO

		ENDIF

		ForceStable(oBrowse)

	ENDIF
* Bottom or right arrow

ELSEIF nRow=aScrollBar[SB_ROWBOTTOM].AND.nCol=aScrollBar[SB_COLBOTTOM]

* Left button
	IF nBut=1
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL
			oBrowse:down()
		ELSE
			oBrowse:right()
		ENDIF

* Right Button
	ELSEIF nBut=2
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL

			oBrowse:pageDown()
		ELSE
			oBrowse:panRight()
		ENDIF
* Both buttons?
	ELSEIF nBut=3
		IF aScrollBar[SB_DIRECTION]=SB_VERTICAL

* Note: we must save the record number before calling oBrowse:goBottom since
* the browse object will call the skipper to move the display to the top of
* the screen page in the goBottom but waits until stabilization time to move
* back to the last record.

		     SAVE_RECORD_NUM(oBrowse,TOTAL_COUNT(oBrowse))
			oBrowse:goBottom()

* force a wait for release
			DO WHILE FT_MBUTREL(1)!=0
			ENDDO
		ENDIF
	ENDIF
ELSE

* move display according to where the cursor was clicked on the scroll bar
	IF nBut=1
		IF aScrollbar[SB_DIRECTION]=SB_VERTICAL
			DISPBEGIN()
			nScrollHeight=aScrollBar[SB_ROWBOTTOM]-aScrollBar[SB_ROWTOP] - 2
* Calculate new position
               nNewRec=ROUND(1+((nRow-aScrollBar[SB_ROWTOP]-1);
					*MAX(1,TOTAL_COUNT(oBrowse)-1))/nScrollHeight,0)


* Move to new position

			nSkip= nNewRec-RECORD_NUM(oBrowse)

			SKIP nSkip
			SAVE_RECORD_NUM(oBrowse,nNewRec)
			CorrectScreen(IIF(EMPTY(INDEXKEY()),NIL,&(INDEXKEY()) ) )

*  DO columns now

		ELSE
			nScrollheight=aScrollBar[SB_COLBOTTOM]-aScrollBar[SB_COLTOP]-2
			nNewRec=ROUND(1+((ncol-aScrollBar[SB_COLTOP]-1);
					*MAX(1,oBrowse:colCount-1))/nScrollHeight,0)

* Move to new position

			nNewRec=oBrowse:colpos-nNewRec
			IF nNewRec>0
				FOR i=1 TO nNewRec
					oBrowse:left()
				NEXT
			ELSEIF nNewRec<0
				FOR i=1 TO (-nNewRec)
					oBrowse:right()
				NEXT
			ENDIF
			ForceStable(oBrowse)

		ENDIF
* Send out display no that we are done

		DISPEND()

* force a wait for release

		DO WHILE FT_MBUTREL(1)!=0
		ENDDO


	ENDIF
ENDIF

RETURN result

* End of MouseScroll


*****
*
* BrDblClk
*
* Purpose: set the mouse double click interval
*
* Calling parameters: nDblTime - the maximum time for a double click to take
*
* Returns: The current setting of the double click time
*

FUNCTION BrDblClk(nDblTime)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=nDblClkTime

IF nDblTime!=NIL
	nDblClkTime=nDblTime
ENDIF

RETURN oldsetting

* End of BrDblClk

******
*
* BRHotSpot()
*
* This function allows the caller to define a location on the screen which
* if clicked on with the mouse will cause an action to take place.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/20/91   LJ Letendre   Initial Version
*                                            - taken from MOUSEGET
* 
* Calling parameters:
*                     nTopRow - the top row of the area 
*                     nLeftCol - the left column of the area
*                     nBotRow - the bottom row of the area
*                     nRightCol - the right column of the area 
*                     bAction - Code block which will be executed when
*                              mouse is clicked in the area
*                     nButton - Optional button number for action to occur. IF
*                              equal to 0 or NIL, the action occurs on 
*                              clicking anybutton (the code block can decide 
*                              what to do with based upon the button). If equal
*                              to 1, code block executes only on left click,
*                              if equal to 2 only on right click and if equal
*                              to 4(?) then the middle button.
*                     nSleep - Optional value of a minimum time (in seconds) to
*                              wait between servicing multiple button presses. 
*                              Prevents routine from operating too quickly and 
*                              reading the press of a button multiple times 
*                              when not intended. If =NIL then the default value
*                              is used (see MDefaultSleep()).
*                      lRelease - Optional Logical Value. If set to .T. the
*                              servicing routine will pause after the completion
*                              of bAction for the release of the mouse button(s)
*                              Useful for guaranteeing no multiple hits on
*                              an area. If =NIL then the default is used (see
*                              MDefaultRelease())
*
* Returns: nId which is an ID to be used to remove the area with a call
*              to RDRemHotSpot(nId)
*
* Note: The code block bAction is called with four arguments:
*
*                 nButNum: the number of the button pressed with
*                          1=left, 2=right, 4=middle(?).
*                 nRow: The row that the mouse cursor was in when it
*                       was clicked
*                 nCol: The column that the mouse cursor was in when it
*                       was clicked
*                 nTime: The time returned by SECOND() shortly after the
*                       button was clicked.
*                 oBrowse: The current browse object
*
*        Thus the code block should have a form similar to the following
*        if one wishes to use the button/cursor information:
*
*        {|nButNum, nRow, nCol, nTime, oBrowse|;
*			 MyFunc(NButNum,nRow,nCol,nTime,oBrowse)}

FUNCTION BRHotSpot( nTopRow, nLeftCol, nBotRow, nRightCol, bAction, nButton,;
				 nSleep, lRelease)
*
* Local variables
*

* Entry point

RETURN AddHotSpot(aMouseSpot,@nFreeSpot,;
			{nTopRow, nLeftCol, nBotRow, nRightCol, bAction,;
			IIF(nSleep=NIL,nDefSleep,nSleep),;
			IIF(lRelease=NIL,lDefRelease,lRelease),;
			IIF(nButton=NIL,0,nButton),.T.})


* End of BRHotSpot

******
*
* BRRemHotSpot()
*
* This subroutine clears the specified Hotspot 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/20/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to remove
*                            from active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION BRRemHotSpot(nID)
*
* Local variables
*
LOCAL i, working

* Set values to those off of the screen and no code block

AMouseSpot[nID,1]:=AMouseSpot[nID,2]:=AMouseSpot[nID,3]:=AMouseSpot[nID,4]:=-1
AMouseSpot[nID,5]=NIL
IF nID<nFreeSpot.OR.nFreeSpot=0
	nFreeSpot=nID
ENDIF

* Shrink array if possible

i=LEN(AMouseSpot)
working=.T.
DO WHILE i>=nFreeSpot.AND.working
	working=AMouseSpot[i,1]<0
	i--
ENDDO

ASIZE(AMouseSpot,i+1)


RETURN NIL

* End of BRRemHotSpot

******
*
* BRCoolSpot()
*
* This subroutine deactivates the specified HotSpot without deleting it
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/17/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to remove
*                            from active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION BRCoolSpot(nID)
*
* Local variables
*

AMouseSpot[nId,9]=.F.

RETURN NIL

* End of RDCoolSpot

******
*
* BRWarmSpot()
*
* This subroutine reactivates the specified HotSpot which was deactivated
* by RDCoolSpot
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/17/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to return 
*                            to active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION BRWarmSpot(nID)
*
* Local variables
*

AMouseSpot[nId,9]=.T.

RETURN NIL

* End of BRWarmSpot


*****
*
*  BRDefSleep()
*
* This routine sets the default minimum time between servicing the mouse
* button when on a "hot spot". Useful for slowing things down.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/20/91   LJ Letendre   Initial Version
*
* Calling Paramters: nSleepDef - Number of second for the default interval
*                                If absent no change made.
*
* Returns: current setting
*
* Note: the default time within the system is 0.2 seconds
*
FUNCTION BRDefSleep(nSleepDef)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=nDefSleep

IF nSleepDef!=NIL
	nDefSleep=nSleepDef
ENDIF

RETURN oldsetting

* End of BRDefSleep

*****
*
*  BRDefRelease()
*
* This routine sets the default logical value controling if the program
* waits for the release of the mouse button before continuing when it is in
* a "Hot Spot"
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/20/91   LJ Letendre   Initial Version
*
* Calling Paramters: lReleaseDef - If present will set the default action
*                                  on releasing the mouse button before
*                                  continuing when servicing a "Hot Spot"
*                                  If absent no change made. .T. causes
*                                  a wait for release.
*
* Returns: current setting
*
*
* Note: The default release action is not to require a release (= .F.)
*
*
FUNCTION BRDefRelease(lReleaseDef)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=lDefRelease

IF lReleaseDef!=NIL
	lDefRelease=lReleaseDef
ENDIF

RETURN oldsetting

* End of BRDefRelease

*****
*
* function BRIgnoreMouse()
*
* Purpose: force the routines to ignore the mouse and perform the overhead
*          necessary for mouse support
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/10/91   LJL       Initial Version
*
* Calling Parameters: lIgnore - logical for ignoring mouse .T. = act as if
*                               mouse is not present. If absent just returns
*                               current setting
*
* Returns: setting in effect prior to call
*
FUNCTION BRIgnoreMouse(lIgnore)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=lIgnoreMouse

IF lIgnore!=NIL
	lIgnoreMouse=lIgnore
ENDIF

RETURN oldsetting

* End of BRIgnoreMouse

* End of conditional compilation for NO_MOUSE
#endif

