*****
*
* MouseValid(lOn, nId)
*
* Turns on and off a hotspot for the current logical field
*
* Calling parameters:   lOn - Logical - turn on the mouse function to switch
*                                       logical values
*                       nId - numeric - The hot spot number - Returned when
*                                       called with lOn=.T. and is equal to
*                                       the hot spot number MUST BE BY REFERENCE
*                                       - Required when lOn=.F. and is the 
*                                       hotspot to delete.
* Returns: .T.
*
* Note:  This function should be called as part of a GET as shown in the
*        following example:
*
*     @ 10,10 GET lExample WHEN MouseValid(.T.,@nId) VALID MouseValid(.F.,nId)
*
*
FUNCTION mouseValid(lOn, nID)

LOCAL oCurGet:=GetActive()

IF lOn
	nId=RDHotSpot(oCurGet:Row,oCurGet:Col,oCurGet:Row,oCurGet:Col,;
		{|nBut| changeLog(nBut)})
ELSE
	RDRemHotSpot(nId)
ENDIF

RETURN .T.

*****
**
* ChangeLog(nBut)
*
* Changes the current value of a logical field
*
* Calling Paramters: nBut - The button number
*
* Returns: NIL
*
* Note: this routine is set up to set the logical to .T. with the left
*       button and .F. with the right button. Alternatively one could toggle
*       the value with the button press.
*
FUNCTION ChangeLog(nBut)

IF nBut=1
	GetActive():VarPut(.T.)
ELSEIF nBut=2
	GetActive():VarPut(.F.)
ENDIF

RETURN NIL