/* * File......: PROPER2.C
 * Author....: Robert DiFalco, Glenn Scott, Craig Baker, and Tom Kozan
 * Date......: $Date:   10 May 1991 10:55  $
 * Revision..: $Revision:   1.0  $
 * 
 * This is an modification of an original work by Glenn Scott and Robert
 * DiFalco which was placed in the public domain.  The modifications were
 * performed by Craig Baker and Tom Kozan and this work is placed in the
 * public domain as well.
 *
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     CDB_PROPER()
 *  $CATEGORY$
 *     String
 *  $ONELINER$
 *     Convert a string to proper-name case
 *  $SYNTAX$
 *     CDB_PROPER( <cString> ) -> cProperName
 *  $ARGUMENTS$
 *     <cString> is the string to be converted.
 *  $RETURNS$
 *     A string of the same length as <cString>, only converted to
 *     proper name case (upper/lower case).
 *  $DESCRIPTION$
 *     CDB_PROPER() uses a brute-force algorithm to convert a string
 *     to propername case.  First, it capitalizes all words starting
 *     after a blank, dash, or apostrophe.  This will catch most names,
 *     including special cases such as names beginning with O' (O'Malley,
 *     O'Reilly) and hyphenated names (such as Susan Chia-Mei Lo).
 *
 *     Next, it does a specific adjustment for words beginning in "Mc"
 *     It finds the first 'Mc' and capitalizes the next character after
 *     it.  It does this for all occurrences of Mc.
 *
 *     Two additional enhancements have been added from the original
 *     FT_PROPER() in order to make it more useful for business applications.
 *     It now properly handles words ending in 's and will capitalize letters
 *     immediately following a period, catching things like P.O. Box and the
 *     like.
 *
 *     The original FT_PROPER() was written in Clipper by Glenn Scott
 *     and Mark Zechiel; it was re-written in C (and thus, optimized
 *     and enhanced) by Robert DiFalco.
 *
 *     This revision was performed by Craig Baker and Tom Kozan.
 *
 *  $EXAMPLES$
 *       FUNCTION main( cStr )
 *         OutStd( CDB_PROPER( cStr ) + chr(13) + chr(10) )
 *       RETURN ( nil )
 *  $END$
 */


#include "extend.h"

CLIPPER CDB_PROPER()
{
  int  iLen   =  _parclen(1);
  char *cStr  =  _parc(1);
  char *p;

  int i, fCap = TRUE, iPos = 0;

  for( i = 0; i < iLen + 1; i++ ) {
     if( _ftIsAlpha( cStr[i] ) == TRUE )  {
	if( fCap == TRUE )
	   cStr[i] = _ftToUpper( cStr[i] );
	else cStr[i] = _ftToLower( cStr[i] );
	}
     fCap = ( cStr[i] == ' ' || cStr[i] == '-' || cStr[i] == 0x27 );
  }

  // Find "Mc"
  for( i = 0; i <= iLen; i++ )
     if( cStr[i] == 'M' && cStr[i+1] == 'c' ) {
	cStr[i+2] = _ftToUpper( cStr[i+2] );
     }

  /* // If "Mc" was found, Cap next letter if Alpha
  if( iPos > 1 )
     if( iPos < iLen )
	if( _ftIsUpper( cStr[iPos] ) == FALSE )
	   cStr[iPos] = _ftToUpper( cStr[iPos] );
  */
  // Find "'s"
  for( i = 0; i <= iLen; i++ )
     if( (cStr[i] == 39) && (cStr[i+1]=='S') && (cStr[i+2]==' '))
	cStr[i+1] = 's';

  for( i = 0; i <= iLen; i++ )
     if( cStr[i] == '.' && _ftIsAlpha( cStr[i+1]))
	cStr[i+1] = _ftToUpper( cStr[i+1] );
  _retc( cStr );
  return;
}

int _ftIsAlpha( char c )
{
  return( _ftIsUpper(c) || _ftIsLower(c));
}

int _ftToLower( char c )
{
  return(c >= 'A' && c <= 'Z' ? c - 'A' + 'a' : c);
}
int _ftToUpper( char c )
{
  return((c >= 'a' && c <= 'z') ? c - 'a' + 'A' :  c);
}


int _ftIsUpper( char c )
{
  return(c >= 'A' && c <= 'Z');
}


int _ftIsLower( char c )
{
  return(c >= 'a' && c <= 'z');
}

                                                    
