*********************************************************************
*  Function: MonType
*  Writer: Kraig Krist/TBCS
*          PO Box 711
*          Annandale, VA 22003-0711
*  Date: September 5, 1993
*  Description: Handle Adapter Type request.
*********************************************************************
*
*   ***** Function Specifications *****
*
*   Passed In: 1. Adapter Type (EGA, VGA, etc) to test.
*                 Example: If MonType('EGA')
*
*              2. NIL if Function will return Adapter Type.
*                 Example: cMonType := MonType()
*
*   Returns: Appropriate value based on value passed in.
*
*********************************************************************
*             ---- Modification Log ----
*
*  When:
*   Why:
*
*********************************************************************
External CMonType
*********************************************************************
*    Function MonType
*********************************************************************
FUNCTION MonType(xType)
*********************************************************************
*    Declare Variables
*********************************************************************
  Local xReturn, nVAdapter
  Local aAdapters[9]
*********************************************************************
*    Initialize Variables
*********************************************************************
  aAdapters[1] := 'MDPA'
  aAdapters[2] := 'CGA'
  aAdapters[3] := 'EGA'
  aAdapters[4] := 'VGA'
  aAdapters[5] := 'MCGA'
  aAdapters[6] := 'HGC'
  aAdapters[7] := 'OCGA'
  aAdapters[8] := 'OEGA'
  aAdapters[9] := 'OVGA'
*********************************************************************
*    Call C Function to determine current Video Adapter
*********************************************************************
  nVAdapter := CMonType()
  If xType == NIL
*********************************************************************
*    Value was not passed in.  Therefore, return Adapter type.
*********************************************************************
    If nVAdapter < 0 .or. nVAdapter > 9
      xReturn := 'Unknown'
    Else
      xReturn := aAdapters[nVAdapter]
    EndIf
  Else
*********************************************************************
*    Determine if passed value is equal to current video adapter type.
*********************************************************************
    If nVAdapter < 0 .or. nVAdapter > 9
      xReturn := .F.
    Else
      If Upper(xType) == Upper(aAdapters[nVAdapter])
        xReturn := .T.
      Else
        xReturn := .F.
      EndIf
    EndIf
  EndIf
Return (xReturn)
