********************************************************************************
* Program Id: modntx.prg
*    Version: 1.20
********************************************************************************
*
*    Purpose: To retrieve/modify the index expression without re-creating
*             an index.  Also, using these functions, to provide an indexing
*             status slidebar from a UDF that can be removed from the index 
*             key expression.
*
*   Calls to: slidebar() contained in STATUS.PRG
*             setuns(), setstd() contained in COLORSET.C
*
*      Notes: uses the Summer '87 indexext() function to determine the type
*             of index header to use.  If you use non-standard extensions to
*             the .NTX/.NDX files, you deserve to have to rewrite a small part
*             of these routines.  You can SCREW UP your index files in a big
*             way if you don't understand what you're doing with these
*             functions.  If you do corrupt them, I will not be held 
*             responsible - these routines work fine for me.
*             
*     Notice: Released into the Public Domain.  However, if you want to, I
*             won't refuse money.  It might encourage me to keep putting stuff
*             on the boards - I haven't been too enthusiastic about it lately.
*
*  Thanks to: Robert V. Hannah III, for knowing where to find the information
*             on the index file headers.
*
*     Author: John F. Kaster
*
*       Date: 6-2-1989
*
********************************************************************************
* Date     Name Description
*
* 06/01/89 jfk  Original program
* 06/02/89 jfk  Added .NDX file support
* 08/23/89 jfk  Added support for numeric or date indices
********************************************************************************
*
* According to Reference(Clipper), Feb. 1988 Advanced User's Log(),
* the structure of the Clipper .NTX file is as follows:
*
* Type      Var                    Size
*
* typedef struct
* {
*   unsigned  sign;                   2
*   unsigned  version;                2
*   long      root;                   4
*   long      free_page;              4
*   unsigned  item_size;              2
*   unsigned  key_size;               2
*   unsigned  key_dec;                2
*   unsigned  max_item;               2
*   unsigned  half_page;              2
*   char      key_expr[256];        256
* } NTX_HEADER;
*
* Total offset to key_expr:   22 bytes
*
* According to Reference(Clipper), March 1988 Advanced User's Log(),
* the structure of the dbase .NDX file is as follows:
*
* Type      Var                    Size
*
* typedef struct
* {
*   long      start_key_page;         4
*   long      total_pages_in_file;    4
*   long      filler1;                4
*   unsigned  index_key_len;          2
*   unsigned  max_keys_page;          2
*   unsigned  ndx_key_type;           2
*   long      size_key_rec;           4
*   char      filler2;                1
*   char      unique;                 1
*   char      key_name[488];        488
* } NDX_HEADER;
*
* Total offset to key_name:   24 bytes

* When you are ready to use these routines as a stand-alone, comment out
* the source code between the two boundaries.
*
********* TOP BOUNDARY **************************************************
* parameter dbffile, idxfile
* if pcount() < 2
*   ? 'MODNTX <dbffile> <idxfile>'
*   quit
* endif
* use ( m->dbffile )
* clea
* set color to GR+/N,W+/B,,,W/B
* tmp = substr( getidxkey( m->idxfile ) + space( 256 ), 1, 256 )
* @ 12,0 say m->idxfile+"'s index expression:" get m->tmp pict '@S30'
* read
* @ 12,0 SAY 'Indexing '+idxfile+':'
* statidx( idxfile, m->tmp, row(), col() )
* return
********* BOTTOM BOUNDARY ***********************************************

******************
* getidxkey( <idxname> [, <handle> ] )
*
* <idxname> - name of the .NTX file to read the key from
* <handle>  - the file handle to use.  If not passed, the file is opened.
*
* returns the index key expression in <idxname> directly from the index
* file.  This is useful only if the index is not active, really . . . I
* would suggest using the indexkey() supplied with Clipper, in that case.
******************
function getidxkey
parameter idxname, handle
private pc, retidx, hdrpos, hdrlen
pc = pcount()
if m->pc < 2
  * open file as read/write
  if at('.', m->idxname ) = 0
    idxname = trim( m->idxname ) + indexext()
  endif
  handle = fopen( m->idxname, 2 )
  if handle = -1
    return ""
  endif
else  && File supposedly open
  * Get current file position
  fpos = fseek( m->handle, 0, 1 )
endif

if '.NTX' $ upper( m->idxname )
  hdrpos = 22
  hdrlen = 255
else && .NDX file
  hdrpos = 24
  hdrlen = 488
endif

* Positions the DOS file pointer at the start of the key expression
if fseek( handle, m->hdrpos, 0 ) # m->hdrpos
  retidx = ''
else 
  retidx = freadstr( m->handle, m->hdrlen )
endif
if m->pc < 2
  fclose( m->handle )
else
  * re-position file pointer
  fseek( m->handle, m->fpos, 0 )
endif
return m->retidx

******************
* setidxkey( <idxname>, <idxexp> [, <handle> ] )
*
* <idxname> - name of the .NTX file to set the key expression in
* <idxexp>  - expression to set the .NTX key expression to
* <handle>  - the file handle to use.  If not passed, the file is opened.
*
* puts the index key expression in <idxname> without having to re-generate
* the index.
******************
function setidxkey
parameter idxname, idxexp, handle
private pc, retidx, fpos, hdrlen, hdrpos
pc = pcount()
if m->pc < 2
  return .f.
elseif m->pc < 3
  * open file as read/write
  if at('.', m->idxname ) = 0
    idxname = trim( m->idxname ) + indexext()
  endif
  handle = fopen( m->idxname, 2 )
  if handle = -1
    return .f.
  endif
else  && File supposedly open
  * Get current file position
  fpos = fseek( m->handle, 0, 1 )
endif

if '.NTX' $ upper( m->idxname )
  hdrpos = 22
  hdrlen = 255
else && .NDX file
  hdrpos = 24
  hdrlen = 488
endif

* Positions the DOS file pointer at the start of the key expression
if fseek( handle, m->hdrpos, 0 ) # m->hdrpos
  retidx = .f.
else
  * padding the index expression with NULL characters
  idxexp = substr( m->idxexp + repl( chr(0), m->hdrlen ), 1, m->hdrlen )
  retidx = ( fwrite( m->handle, m->idxexp ) = m->hdrlen )
  fwrite( m->handle, chr(0) ) && Terminate index key
endif

if m->pc < 3
  fclose( m->handle )
else
  * re-position file pointer
  fseek( m->handle, m->fpos, 0 )
endif
return m->retidx

****************
* statidx( <idxfile>, <idxexp> [, <row> , <col> [, <width> ] ] )
*
* <idxfile> - name of the index file to create/update
* <idxexp>  - key expression to use in index (re)generation
* <row>     - row of the status bar - default = 23
* <col>     - column for the status bar - default = 0
* <width>   - width of the status bar - default = 80
*
* produces a slidebar indicating how much of the index is done on lines
* 23 and 24. If you want to change where it's doing it, just modify the
* slidebar() clause according to the slidebar() documentation contained
* in status.prg.  After the index is created using slidebar(), the index
* key is modified directly in the file with setidxkey() to remove the
* slidebar() expression.
*
* Warning:  since the slidebar expression requires 55 characters, your
*           index expression must be 55 characters less than the maximum
*           length of the index key.  Refer to the top of this file for
*           that number in the corresponding index structures.  Notice
*           that two parameters in slidebar are passed by reference, and
*           that the other variables are fully qualified as memory variables.
*           For total generality, I would suggest leaving the slidebar()
*           expression as it is, or fully qualifying any variables you pass
*           to it.
****************
function statidx
parameter idxfile, idxexp, irow, icol, iwid
private oldper, curon, tot, newexp, pc
pc = pcount()
if m->pc < 2
  return .f.
elseif m->pc < 5
  irow = if( m->pc < 3, 23, m->irow )
  icol = if( m->pc < 4,  0, m->icol )
  iwid = 80 - m->icol
endif
idxexp = ltrim( trim( m->idxexp ) )
tot = reccount()
curon = 0
oldper = 0
if type( m->idxexp ) = 'C'
  newexp = "slidebar(@oldper,@curon,m->tot,m->irow,m->icol,m->iwid)+"+m->idxexp
else && Numeric or date index
  newexp = "len(slidebar(@oldper,@curon,m->tot,m->irow,m->icol,m->iwid))+"+m->idxexp
endif
set cursor off
index on &newexp to ( m->idxfile )
set cursor on
set index to && closing index file in case we're not in a multi-user situation
setidxkey( m->idxfile, m->idxexp )
return .t.

external slidebar
