********************************************************************************
* Program Id: status.prg
*    Version: 1.00
********************************************************************************
*
*    Purpose: Provide a means of indicating the status of an operation as
*             a horizontal scrolling bar.
*
*  Called by: Indexing routines, etc.
*
*      Notes: 
*
********************************************************************************
* Date     Name Description
*
* 06/02/89 jfk  Original program
********************************************************************************
* clear
* tot = 10000
* row = 23
* col = 0
* wid = 80
* dsp = 'S'
* chs = 'o'
* @ 8, 0 SAY 'Itr: ' get m->tot
* @ 10,0 SAY 'Row: ' get row
* @ 12,0 SAY 'Col: ' get col
* @ 14,0 SAY 'Wid: ' get wid
* @ 16,0 SAY 'Dsp: ' get dsp
* @ 18,0 SAY 'Chs: ' get chs
* read

* set color to GR+/N,W+/B,,,W/B
* oldper = 0
* set cursor off
* for i = 0 to m->tot
*   slidebar( @oldper, m->i, m->tot, m->row, m->col, m->wid, m->dsp, m->chs )
*   if nextkey() = 27
*     exit
*   endif
* next
* set cursor on
* return

*****************
*
* Syntax: 
*   slidebar( @<old%>, @<current#>, <total#>, <row>, <column>, <barsize>,
*             <ticks>, <status chars> )
*
* Notes.: 
*   puts a slidebar on <row>, <column> of <barsize>.  As the percent
*   complete is updated, the bar is filled in.  Defaults are:
*
*   @<old%>     - old percentage value.  Changed as reference.
*   @<current#> - current number out of total #
*   <total#>    - total number of operations to perform
*   <row>       - screen row to display slidebar on
*   <column>    - starting column to display the bar on
*   <barsize>   - number of columns in the bar
*   <ticks>     - 'S' to show 0 .. 50 .. 100
*   <chars>     - 3 character string of the status characters to use
*
*
*   Since this function returns a NULL string, and the two values that
*   are updated are passed as reference parameters, this function could
*   be used to indicate the status of loops with a minimum of effort.
*
*****************
function slidebar
parameter oldperc, curon, todo, line, column, width, disp, chars
private pc, curperc, iperc, std, uns
pc = pcount()

****** Checking parameters passed
if m->pc < 3
  return ""
elseif m->pc < 8
  line    = if( m->pc < 4, 23, m->line )
  column  = if( m->pc < 6, 0, m->column )
  width   = if( m->pc < 5, 80 - m->column, m->width )
  disp    = if( m->pc < 7, 'S', m->disp )
  chars   = 'o'
endif

if m->todo < 1
  setuns()
  @ m->line, m->column say replicate( substr( m->chars, 5, 1 ), m->width )
  setstd()
elseif m->curon = 0
  if upper( m->disp ) = 'S'
    @ m->line - 1, m->column say '0'
    @ m->line - 1, m->column + m->width - 3 say '100'
    if m->width > 8
      @ m->line - 1, m->column + (m->width/2) - 1 say '50'
    endif
  endif
  @ m->line, m->column say replicate( substr( m->chars, 1, 1 ), m->width )
  oldperc = 0
else
  curperc = round( ( m->curon / m->todo ) * m->width, 1 )
  if m->oldperc < m->curperc
    oldperc = m->curperc
    iperc   = int( m->curperc )
    dec     = int( (m->oldperc - m->iperc) * 5 )
    setuns()
    @ m->line, m->column say replicate( substr( m->chars, 6, 1 ), m->iperc )
    if m->iperc < m->width
      @ row(),col() say substr( m->chars, 1 + int( ( m->oldperc - m->iperc ) * 5 ), 1 )
    endif
    setstd()
  endif
endif
curon = m->curon + 1
return ""

