/*  This is a stripped down notepad showing how to add a mouse.
    Other key strokes can be added.  I removed the save/edit stuff
    beacause I needed a read only file viewer to view small files and
    I didn't want to link in the (extra) large maxview().  This code
    should be enough to get anyone started on mousifying the regular notepad.

    Compile:  clipper view /a/m/n/w
    Link:     whatever
*/

#include "FUNCky.ch"

#define ANORMAL   23
#define TABSIZE   4
#define MAXLINES  3000
#define MAXCOLS   1024
#define BUFFSIZE  (1024 * 60)

#define CR              chr(13)
#define CRLF            chr(13)+chr(10)

STATIC np
STATIC h
STATIC text, s
STATIC filename
STATIC reccount 

FUNCTION NotePad( cFileName )

   m_csroff()

   filename := cFileName

   reccount     := 1

   @ 23,1 say ""
   @ 23,3 say ""
   @ 23,5 say chr( 27 )
   @ 23,7 say chr( 26 )

   np       := npCreate( 1, 0, lastrow()-2, lastcol(), ANORMAL, BUFFSIZE, MAXLINES, MAXCOLS, TABSIZE )

   IF( isfile(filename, A_NORMAL) )
        h    := fopen( filename, O_READWRITE)
        s    := min( flen(h), BUFFSIZE - (MAXLINES * 4) )
        text := space(s)
        fread(h, @text, s)
        fclose(h)
   ELSE
        text := ""
   ENDIF

   npStore ( np, 1, text)
   npEolChar(np, 32)
   npEofChar(np, 32)
   npTabChar(np, 32)
   
   npDisplay ( np )
   m_csron()
   NotePad2(np)

   npFree(np)

return NIL

FUNCTION NotePad2(np)

   LOCAL nKey := 0
   LOCAL xcode
   LOCAL mButton := 0

   setcursor(1)

   DO WHILE( TRUE )

      npDisplay ( np )
      setpos ( npScrRow(np), npScrCol(np))

      nKey := inkey( .1 )

      if nKey == 0

        mButton := button()

        do case
        case mButton == 1
          do case
          case m_region( 23, 1, 23, 1 )
            nKey := UPARROW
          case m_region( 23, 3, 23, 3 )
            nKey := DOWNARROW
          case m_region( 23, 5, 23, 5 )
            nKey := LEFTARROW
          case m_region( 23, 7, 23, 7 )
            nKey := RIGHTARROW
          otherwise
            npWinCsrMove( np, m_Row() - 1, m_col() )
          endcase
        case mButton == 2
          nKey := ESC
        endcase

      endif

      DO CASE
                                         
         CASE ( nKey EQ LEFTARROW )
            npCsrLeft ( np, 1 )
            LOOP

         CASE ( nKey EQ RIGHTARROW )
            npCsrRight ( np, 1 )
            LOOP

         CASE ( nKey EQ UPARROW )
            npCsrUp ( np, 1 )
            LOOP

         CASE ( nKey EQ DOWNARROW )
               npCsrDown ( np, 1 )
            LOOP

         CASE ( nKey EQ CTRLRIGHT)
            npWordRight ( np )
            LOOP

         CASE ( nKey EQ CTRLLEFT )
            npWordLeft ( np )
            LOOP

         CASE ( nKey EQ HOME )
               npHome( np )
            LOOP

         CASE ( nKey EQ ENDKEY )
               npEnd( np )
              LOOP

         CASE ( nKey EQ PGUP )
            npPageUp ( np )
            LOOP

         CASE ( nKey EQ PGDN )
            npPageDown ( np )
            LOOP

         CASE ( nKey EQ  ESC OR nKey EQ 301)
               return (FALSE)
            LOOP

     ENDCASE

   ENDDO

return(FALSE)

init function begin
  cls
  m_reset()
  m_csron()
return nil


