// This information is for the use of all ... 
// provided by Michael Obranovic  CIS: 70511,1505
// 
//
// Problem  : The function call to FT_MINIT() returned true even when no
//            mouse driver was installed.
//
// Cause    : FT_MINIT()'s call to FT_MRESET() tested for the mouse but
//            called FT_MYLIMIT() even if no mouse was found. The call to
//            FT_MYLIMIT() sets aReg[AX] to 8 so the return value of 
//            FT_MRESET() was always 8 and FT_MINIT() was always true.
//
// Solution : The IF statement shown below must be added to FT_MRESET()         
//
//
FUNCTION FT_MRESET()

   aReg[AX] := 0          // set mouse function call 0
   FT_INT86( 51, aReg )  // execute mouse interrupt
   lCrsState=.F.         // Cursor is off after reset

* Reset maximum x and y limits only if a mouse was detected
   IF aREG[AX] <> 0                // if there is no mouse driver
     FT_MYLIMIT(0,8*MAXROW())      // then don't execute these 
     FT_MXLIMIT(0,8*MAXCOL())      // lines of code 
   ENDIF
RETURN aReg[AX] 	       // return status code

