#include math.hdr


*- this is built in FORCE function (not documented)
FUNCTION LOGICAL Interrupt PROTOTYPE
  PARAMETERS VALUE UINT intrupt,;
                   UINT ax,;
                   UINT bx,;
                   UINT cx,;
                   UINT dx,;
                   UINT si,;
                   UINT di,;
                   UINT bp,;
                   UINT ds,;
                   UINT es



procedure mouse_confine
   parameters int u_row, int l_row, int l_col, int r_col

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


   *- turn cursor on for debugging
  ax = 0x01
  #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+



     *- define mouse region - vertical
     ax=0x08
     * 8 mickeys per column and row
     cx=u_row * 8
     dx=l_row * 8
      #pragma w_func_proc-
     Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
      #pragma w_func_proc+

     *- define mouse region - horizontal
     ax=0x07
     * 8 mickeys per column and row
     cx=l_col * 8
     dx=r_col * 8
      #pragma w_func_proc-
     Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
      #pragma w_func_proc+

endpro



* returns a .f. if not installed, .t. if installed
function logical mouse_detect

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


  *- reset mouse driver and detect status

  ax = 0x00
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

   if ax = 0x00
     return .f.
   else
     return .t.
   endif

endpro


* get mouse row
function uint mouse_row


   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


  *- reset mouse driver and detect status

  ax = 0x03
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

   return dx
endpro


* get mouse col
function uint mouse_col


   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


  *- reset mouse driver and detect status

  ax = 0x03
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

   return cx
endpro


* which of 25 rows is mouse in ( 0 - 24 )
function uint mouse_scrn_row

   return i_trunc( mouse_row() / 8 )

endpro

* which of 80 cols is mouse in ( 0 - 79 )
function uint mouse_scrn_col

   return i_trunc( mouse_col() / 8 )

endpro


procedure mouse_speed
   parameters uint how_fast


   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


  *- set mouse threshold speed

  dx = how_fast
  ax = 0x13
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+


endpro


procedure mouse_set_pos
   parameters uint which_row, uint which_col

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
     uint urow,ucol
   enddef

   * position mouse cursor on screen

  dx = which_row * 8
  cx = which_col * 8
  ax = 0x04
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

endpro


procedure hide_mouse

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
     uint urow,ucol
   enddef

  ax = 0x02
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

endpro

procedure show_mouse

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
     uint urow,ucol
   enddef

  ax = 0x01
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

endpro


* returns a 1 if leftbutton, 2 if rightbutton, 4 if middle button
function uint mouse_button

   vardef
     UINT ax,bx,cx,dx,si,di,bp,ds,es
   enddef


  *- reset mouse driver and detect status

  ax = 0x03
   #pragma w_func_proc-
  Interrupt(0x33, ax, bx, cx, dx, si, di, bp, ds, es)
   #pragma w_func_proc+

   return bx
endpro
