#include string.hdr
#include keys.hdr
#include io.hdr
#include mice.hdr


FUNCTION LONG create_slist_ PROTOTYPE

PROCEDURE add_slist_ PROTOTYPE
	PARAMETERS VALUE LONG, CONST CHAR

PROCEDURE clear_slist_ PROTOTYPE
	PARAMETERS VALUE LONG

FUNCTION CHAR get_slist_ PROTOTYPE
	PARAMETERS VALUE LONG, VALUE INT
	
PROCEDURE scroll_ PROTOTYPE
	PARAMETERS VALUE UINT, VALUE UINT, VALUE UINT, VALUE UINT, VALUE LOGICAL

FUNCTION INT slist_max_ PROTOTYPE
	PARAMETERS VALUE LONG

VARDEF EXTERN
	BYTE	__color_std, __color_enhcd
ENDDEF
	
VARDEF
	INT	__tops_ = 1				&& top of screen.
ENDDEF

*------------------------------------------------------------------------------
*
*   procedure: PICK_INIT()
*  parameters: none
* description: initialize a pick list.
*     assumes: 
*
*------------------------------------------------------------------------------

FUNCTION LONG pick_init

	__tops_ = 1
	RETURN create_slist_()

ENDPRO

*------------------------------------------------------------------------------
*
*   procedure: PICK_ADD
*  parameters: 
* description: adds a string to a pick list.
*     assumes: 
*
*------------------------------------------------------------------------------

PROCEDURE pick_add
	PARAMETERS VALUE LONG plist, CONST CHAR s

	add_slist_( plist, s )

ENDPRO

*------------------------------------------------------------------------------
*
*   procedure: PICK_STR
*  parameters: 
* description: returns a string given a picklist ID.
*     assumes: 
*
*------------------------------------------------------------------------------

FUNCTION CHAR pick_str
	PARAMETERS VALUE LONG plist, VALUE INT idx

	RETURN get_slist_( plist, idx )

ENDPRO

*------------------------------------------------------------------------------
*
*   procedure: SWAP_COLORS_
*  parameters: make enhanced normal and normal enhanced
* description: 
*     assumes: 
*
*------------------------------------------------------------------------------

PROCEDURE swap_colors_
	VARDEF
		BYTE	tmp
	ENDDEF

	tmp = __color_std
	__color_std = __color_enhcd
	__color_enhcd = tmp

ENDPRO

*------------------------------------------------------------------------------
*
*   procedure: PICK_LIST
*  parameters: 
* description: performs a pick list operation on the passed picklist.
*     assumes: 
*
*------------------------------------------------------------------------------

PROCEDURE pick_list
 PARAMETERS ;
	VALUE LONG plist, ;
	VALUE INT r, VALUE INT c, VALUE INT r1, VALUE INT c1, ;
	INT idx, ;
	VALUE LOGICAL disp_only,;
        VALUE LOGICAL ret ,;
        LOGICAL use_mouse


	VARDEF
		UINT	wid
		UINT 	height
		UINT	i
		UINT	k
		LOGICAL	redraw
                uint mouse_row,new_mouse_row
                uint mouse_col,new_mouse_col
                uint which_button
	ENDDEF

	*---if we are going wait until return or esacpe, then reset the ID
	*	to 1

        * set mouse area
        if use_mouse
           mouse_confine(r,r1,c,c1)
        endif
        which_button = 0


	IF .NOT. ret
		idx = 1
		__tops_ = 1
	ELSE
		IF idx > slist_max_( plist )
			idx = 1
		ENDIF
		IF idx = 1
			__tops_ = 1
		ENDIF
	ENDIF

	wid = c1 - c + 1			
	height = r1 - r 

	IF idx-__tops_ > height
		__tops_ = idx
	ENDIF

	IF slist_max_( plist ) < height
		height = slist_max_( plist )
	ENDIF

	*--- do the intial display

	redraw = .t.

        new_mouse_row = r
        new_mouse_col = c
        mouse_row = r
        if use_mouse
           mouse_set_pos(new_mouse_row,new_mouse_col)
        endif

	REPEAT
		IF redraw
			@ r, c CLEAR TO r1, c1
			FOR i = 0 TO height
				IF __tops_+i > slist_max_( plist )
					EXIT
				ENDIF

				@ r+i, c
				?? left(get_slist_(plist, __tops_+i),wid):wid
			NEXT
		ENDIF

		DO swap_colors_
		@ r+idx-__tops_,c
		?? left(get_slist_(plist, idx ),wid):wid
		DO swap_colors_
		IF disp_only
			RETURN
		ENDIF

                *k = get_key()

                  if use_mouse
                     mouse_set_pos(new_mouse_row,new_mouse_col)
                     mouse_row = mouse_scrn_row()
                  endif
                  repeat

                     k = inkey()
                     if use_mouse
                        new_mouse_row = mouse_scrn_row()
                        which_button = mouse_button()
                     endif

                  until ( k <> 0 ) .or. mouse_row <> new_mouse_row ;
                     .or. ( which_button <> 0 )

                  do case

                  case k <> 0
                     * will just exit

                  case new_mouse_row > mouse_row
                     k = &K_DOWN
                  case new_mouse_row < mouse_row
                     k = &K_UP

                  * left mouse button
                  case which_button = 1
                     k = &K_ENTER

                  * right mouse button
                  case which_button = 2
                     k = &K_ESC

                  endcase

                  which_button = 0



		IF k = &K_ESC
			idx = 0
			EXIT
		ENDIF

		IF k = &K_ENTER
			EXIT
		ENDIF

		@ r+idx-__tops_,c
		?? get_slist_(plist, idx):wid

		redraw = .f.

		DO CASE
			CASE k = &K_DOWN
				IF idx <> slist_max_( plist )
					idx = idx + 1
				ENDIF
				IF idx - __tops_ > height
					scroll_( r, c, r1, c1, .t. )
					__tops_ = __tops_ + 1
				ENDIF

			CASE k = &K_UP
				IF idx > 1
					idx = idx - 1
				ENDIF
				IF idx - __tops_ < 0
					scroll_( r, c, r1, c1, .f. )
					__tops_ = __tops_ - 1
				ENDIF

			CASE k = &K_PG_DOWN
				__tops_ = __tops_ + height + 1
				idx = idx + height + 1
				IF idx > slist_max_( plist )
					idx = slist_max_( plist )
				ENDIF
				IF __tops_ + height > slist_max_( plist )
					__tops_ = slist_max_( plist ) - height
					IF __tops_ < 1
						__tops_ = 1
					ENDIF
				ENDIF
				redraw = .t.

			CASE k = &K_PG_UP
				idx = idx - height - 1
				__tops_ = __tops_ - height - 1
				IF idx < 1
					idx = 1
				ENDIF
				IF __tops_ < 1
					__tops_ = 1
				ENDIF
				redraw = .t.

			CASE k = &K_HOME
				idx = 1
				__tops_ = 1
				redraw = .t.

			case k = &K_END
				idx = slist_max_( plist )
				__tops_ = idx - height
				IF __tops_ < 1
					__tops_ = 1
				ENDIF
				redraw = .t.

			OTHERWISE
				IF ret
					EXIT
				ENDIF
					
		ENDCASE

                if use_mouse
                   new_mouse_row = r+idx-__tops_
                endif
				
	UNTIL k = &K_ESC


         #pragma w_func_proc-
         mouse_detect()       && reset mouse when done
         #pragma w_func_proc+

ENDPRO

*------------------------------------------------------------------------------
*
*   procedure: PICK_CLEAR
*  parameters: 
* description: 
*     assumes: 
*
*------------------------------------------------------------------------------

PROCEDURE pick_clear
	PARAMETERS VALUE LONG plist

	clear_slist_( plist )

ENDPRO
