* FILE ........: MEMO_DEMO.PRG
*****************************************************************************
* PROGRAM......: MEMO_DEMO
* AUTHOR.......: Dale L. Clark
* DATE.........: 1/15/89
* COPYRIGHT....: Dale L. Clark, 1989.  Placed in the Public Domain.
*
* DESCRIPTION..: This function is used to demonstrate the three methods of
*                editing MEMO fields using Clipper.
*****************************************************************************
SET SCOREBOARD OFF
USE MEMODEMO
getcolor = highlight()
saycolor = setcolor()
DO WHILE .T.
   CLEAR
   @  8,20 TO 15,60 DOUBLE
   @  9,22 SAY "MEMO EDITING DEMO"
   @ 10,21 TO 10,59
   @ 11,22 PROMPT "End Demonstration    "
   @ 12,22 PROMPT "SAY/GET-READ-MEMOEDIT"
   @ 13,22 PROMPT "Function Key Approach"
   @ 14,22 PROMPT "MGET() Approach      "
   MENU TO MAIN
   CLEAR
   DO CASE
      CASE MAIN < 2
           RETURN
      CASE MAIN = 2
           DO SAY_GET
      CASE MAIN = 3
           DO F_KEY
      CASE MAIN = 4
           DO M_GET
   ENDCASE
ENDDO
RETURN
*****************************************************************************
PROCEDURE M_GET
DO SCREEN2
READ
RETURN
*****************************************************************************
PROCEDURE SCREEN2
CLEAR GETS
@  5, 2 SAY "Part Number...:" GET PART_NO
@  7, 2 SAY "Description...:"
MGET("DESCRIPT",7,18,9,75)             && GET MEMO USING MGET
@ 11, 2 SAY "Price.........:" GET PRICE
@ 13, 2 SAY "Comments......:"
MGET("COMMENTS",13,18,15,75)           && GET MEMO USING MGET
@ 17, 2 SAY "Qty. on Hand..:" GET ON_HAND
RETURN
*****************************************************************************
PROCEDURE SCREEN1
CLEAR GETS
@  5, 2 SAY "Part Number...:" GET PART_NO
@  7, 2 SAY "Description...:"
SET COLOR TO &getcolor.
MEMOEDIT(DESCRIPT,7,18,9,75,.F.,27)             && DISPLAY MEMO USING MEMOEDIT
SET COLOR TO &saycolor.
@ 11, 2 SAY "Price.........:" GET PRICE
@ 13, 2 SAY "Comments......:"
SET COLOR TO &getcolor.
MEMOEDIT(COMMENTS,13,18,15,75,.F.,27)           && DISPLAY MEMO USING MEMOEDIT
SET COLOR TO &saycolor.
@ 17, 2 SAY "Qty. on Hand..:" GET ON_HAND
RETURN
*****************************************************************************
PROCEDURE SAY_GET
DO SCREEN1
READ
SET COLOR TO &getcolor.
T_DESCRPT = MEMOEDIT(DESCRIPT,7,18,9,75,.T.)  && EDIT MEMO USING MEMOEDIT
IF .NOT. (T_DESCRPT == DESCRIPT)
   REPLACE DESCRIPT WITH T_DESCRPT
ENDIF
T_COMMENT = MEMOEDIT(COMMENTS,13,18,15,75,.T.)  && EDIT MEMO USING MEMOEDIT
SET COLOR TO &saycolor.
IF .NOT. (T_COMMENT == COMMENTS)
   REPLACE COMMENTS WITH T_COMMENT
ENDIF
RETURN
*****************************************************************************
PROCEDURE F_KEY
DO SCREEN1
SET KEY -2 TO M_DESCR
@ 10, 2 SAY "Press <F3> to edit the description."
SET KEY -3 TO M_COMMT
@ 16, 2 SAY "Press <F4> to edit the comments.   "
READ
SET KEY -2
@ 10, 2 SAY "                                   "
SET KEY -3
@ 16, 2 SAY "                                   "
RETURN
PROCEDURE M_DESCR                                 && Procedure for <F3>
SET COLOR TO &getcolor.
T_DESCRPT = MEMOEDIT(DESCRIPT,7,18,9,75,.T.)  && EDIT MEMO USING MEMOEDIT
SET COLOR TO &saycolor.
IF .NOT. (T_DESCRPT == DESCRIPT)
   REPLACE DESCRIPT WITH T_DESCRPT
ENDIF
RETURN
PROCEDURE M_COMMT                                && Procedure for <F4>
SET COLOR TO &getcolor.
T_COMMENT = MEMOEDIT(COMMENTS,13,18,15,75,.T.)  && EDIT MEMO USING MEMOEDIT
SET COLOR TO &saycolor.
IF .NOT. (T_COMMENT == COMMENTS)
   REPLACE COMMENTS WITH T_COMMENT
ENDIF
RETURN

