// MemoGet.PRG
//
// Duplicate of Clipper's GET class providing access to multi-line GETs.
//
// Date  : 2/24/94
// Author: ShaunB..
// Requires: Class(y) and FUNCky
// Function/Procedure Prototype Table  -  Last Update: 02-25-94 @ 10:44:20am
// 
// Return Value         Function/Arguments
//   
// Void                 static procedure editGetNote(oGet)
// Void                 static procedure getMemoReader( oGet )
// self                 method assign()
// self                 method colorDisp(cColor)
// self                 method display()
// self                 method init(nTop, nLeft, nHeight, nWidth, bBlock, cName, cPic, bWhen, bValid,;
// self                 method killFocus()
// self                 method reset(lForceIt)
// self                 method setFocus()
// self                 method setTheColor(cColor)
// ::buffer             method unTransform()
// self                 method undo()
// self                 method updateBuffer()
// eval(::block)        method varGet()
// xValue               method varPut(xValue)

#include "inkey.ch"
#include "getexit.ch"
#include "class(y).ch"
#include "funcky.ch"

#define K_UNDO          K_CTRL_U

create class memoGet
	export:
		var badDate			readonly
		var block
		var buffer        readonly
		var cargo
		var changed 		readonly
		var clear
		var col
		var colorSpec
		var decPos
		var exitState
		var hasFocus		readonly
		var minus
		var name
		var original		readonly
		var picture
		var pos				readonly
		var postBlock
		var preBlock
		var reader
		var rejected		readonly
		var row
		var subscript
		var type				readonly
		var typeOut

		var oNote
		var bottomRow
		var rightCol
		var maxLines		readonly
		var maxSize			readonly
		var tabSize			readonly

		method init

		// State change
		method assign
		method colorDisp
		method display
		method killFocus
		method reset
		method setFocus
		method undo
		method unTransform
		method updateBuffer
		method varGet
		method varPut

		// Extensions
		method setTheColor
end class


// Constructor
method init(nTop, nLeft, nHeight, nWidth, bBlock, cName, cPic, bWhen, bValid,;
				nMaxLines, nMaxSize, nTabSize, cColor)
	::block        := bBlock
	::col          := nLeft
	::setTheColor(iif(cColor == nil, setColor(), cColor))
	::name  		   := upper(cName)
	::picture      := cPic
	::reader 	   := {|g| getMemoReader(g) }
	::row 		   := nTop
	::hasFocus     := .f.
	::preBlock     := bWhen
	::postBlock    := bValid
	::bottomRow    := nTop+nHeight
	::rightCol     := nLeft+nWidth
	::maxLines		:= iif(nMaxLines == nil, 200, nMaxLines)
	::maxSize		:= iif(nMaxSize == nil, 10000, nMaxSize)
	::tabSize		:= iif(nTabSize == nil, 4, nTabSize)
	::oNote        := NotePad():new(::row, ::col, ::bottomRow, ::rightCol,;
										  	  atoattr(::colorSpec), ::maxSize, ::maxLines, DEFAULT, ::tabSize)
	::oNote:store(NP_NOWRAP, eval(::block))

	::reset(.t.)
	::exitState := GE_NOEXIT
return self


// Use this when the color needs to be changed instead of assigning a value
// directly to oGet:colorSpec
method setTheColor(cColor)
	if chrCount(",", cColor) > 1
		::colorSpec := strExtract(cColor, ",", 2)
	else
		::colorSpec := cColor
	endif

	if empty(::colorSpec)
		::colorSpec := "N/W"
	endif

	if !empty(::oNote)
		::oNote:color := atoattr(::colorSpec)
	endif
return self


method assign()
	if ::hasFocus
		eval(::block, ::buffer)
	endif
return self


method colorDisp(cColor)
	if cColor != nil
		::setTheColor(cColor)
	endif
	::display()
return self


method display()
	::oNote:display()
return self


method killFocus()
	if ::hasFocus
		::display()
		::reset()
	endif
return self


method reset(lForceIt)
	lForceIt := iif(lForceIt == nil, .f., lForceIt)

	if ::hasFocus .or. lForceIt
		if !lForceIt
			::updateBuffer()
		endif
		::badDate   := .f.
		::buffer    := nil
		::cargo     := nil
		::changed   := .f.
		::clear     := .f.
		::decPos    := nil
		::hasFocus  := .f.
		::minus     := nil
		::original  := nil
		::pos       := nil
		::rejected 	:= .f.
		::subscript := nil
		::type      := "C"
		::typeOut   := .f.
		::display()
	endif
return self


method setFocus()
	::original := ::buffer := eval(::block)
	::hasFocus := .t.
	::display()
return self


method undo()
	if ::hasFocus
		::varPut(::original)
		::updateBuffer()
	endif
return self


method unTransform()
return ::buffer

method updateBuffer()
	if ::hasFocus
		::oNote:store(NP_NOWRAP, ::varGet())
		::buffer := ::oNote:retrieve(NP_NOWRAP)
		::display()
	endif
return self

method varGet()
return eval(::block)


method varPut(xValue)
	eval(::block, xValue)
return xValue


// Reader for the notepad GET
static procedure getMemoReader( oGet )
	local nState

	if getPreValidate(oGet)
	   oGet:setFocus()

		oGet:exitState := GE_NOEXIT
		do while ( oGet:exitState == GE_NOEXIT )
			editGetNote(oGet)
			oGet:varPut(oGet:oNote:retrieve(NP_NOWRAP))
			oGet:updateBuffer()

			if getPostValidate(oGet)
				exit
			endif
		enddo

		oGet:killFocus()
	endif
return


// Controls NotePad's behaviour during editing.
static procedure editGetNote(oGet)
	local nKey, lInsert

	lInsert := .t.

	oGet:exitState := GE_NOEXIT
	do while .t.
		oGet:oNote:display()
		csrPut(oGet:oNote:scrRow, oGet:oNote:scrCol)
		nKey := inkey(0)

		do case
			// Data to be inserted
			case nKey >= 32 .and. nKey <= 255
				if lInsert
					oGet:oNote:insert(nKey)
				else
					oGet:oNote:overWrite(nKey)
				endif

			case nKey == K_ENTER
				if lInsert
					oGet:oNote:insert(nKey)
				else
					oGet:oNote:overWrite(nKey)
					oGet:oNote:csrRow++
					oGet:oNote:csrCol := 1
				endif

			case nKey == K_BS
				oGet:oNote:backSpace()

			case nKey == K_DEL
				oGet:oNote:delete()

			case nKey == K_INS
				lInsert := !lInsert

			case nKey == K_LEFT
				oGet:oNote:csrIndex--

			case nKey == K_RIGHT
				oGet:oNote:csrIndex++

			// Up one row.  If we're at the top of the memo then move up and out of the
			// field to the previous GET.
			case nKey == K_UP
				if oGet:oNote:csrRow == 1
					oGet:exitState := GE_UP
					exit
				else
					oGet:oNote:csrRow--
				endif

			// Down one row.  If we're one the last line of the memo then move down
			// and out of the memo to the next GET.
			case nKey == K_DOWN
				if oGet:oNote:csrRow == oGet:oNote:lineCount
					oGet:exitState := GE_DOWN
					exit
				else
					oGet:oNote:csrRow++
				endif

			case nKey == K_HOME
				oGet:oNote:csrCol := 1

			case nKey == K_END
				oGet:oNote:csrCol := oGet:oNote:lineLength

			// Same as K_UP
			case nKey == K_PGUP
				if oGet:oNote:csrRow == 1
					oGet:exitState := GE_UP
					exit
				else
					oGet:oNote:pageUp()
				endif

			// Move to previous field
			case nKey == K_CTRL_PGUP
				oGet:exitState := GE_UP
				exit

			// Same as K_DOWN
			case nKey == K_PGDN
				if oGet:oNote:csrRow == oGet:oNote:lineCount
					oGet:exitState := GE_DOWN
					exit
				else
					oGet:oNote:pageDown()
				endif

			// Move to next field
			case nKey == K_CTRL_PGDN
				oGet:exitState := GE_DOWN
				exit

			// Move to end of memo
			case nKey == K_CTRL_END
				oGet:oNote:csrIndex := oGet:oNote:buffSize

			// Move to beginning of memo
			case nKey == K_CTRL_HOME
				oGet:oNote:csrIndex := 1

			// Undo - copy back from the ::original value
			case nKey == K_CTRL_U
				oGet:undo()
				oGet:oNote:csrIndex := 1

			// Undo all changes and move to next field.
			case nKey == K_ESC
				oGet:undo()
				oGet:exitState := GE_DOWN
				exit
		endcase
	enddo
return
