/**************************************************************************
** TESTPARS.PRG                                                          **
**      Test Program for METAPARS.PRG function.                          **
**                                                      Rod Cushman      **
**                                                      03/10/93 01:18pm **
**************************************************************************/

#include "InKey.ch"
#include "Box.ch"
#include "SetCurs.ch"

#xcommand DEFAULT <foo> to <bar> => ;
                  If( <foo> == NIL, <foo> := <bar>, NIL )


  Local   SysClr := "BG/B,W/B", SysErrClr := "W+/R,R/W",                  ;
          SysWinClr := "B/W,B/BG",                                        ;
          nTop := 2, nLft := 13, nBot := 16, nRit := 65, cSavScr2
  Private cSrch := Space(40)

  SetCursor( SC_NONE )                  // Disable Cursor

  // Check for existence of test database.
  If !File( "TESTPARS.DBF" )
     Tone(155,1)
     CLR_WIN( nTop, nLft, nTop+4, nRit, SysErrClr )
     @ nTop+1, nLft+2 Say "ERROR:  MISSING TESTPARS.DBF"
     @ nTop+2, nLft+2 Say "PRESS ANY KEY TO EXIT PROGRAM"
     InKey(0)
     Quit
  EndIf

  Use TestPars Exclusive                // Neglect Network operation

  If Alias() != "TESTPARS"              // Error occured opening file
     CLR_WIN( 10, 25, 19, 55, SysClr )
     @ 10,32 Say '*** FILE ERROR ***'                   Color '*I'
     @ 12,27 Say 'An Error Occured while     '
     @ 13,27 Say 'trying to open TESTPARS.DBF'
     @ 14,27 Say '  Rod Cushman              '
     @ 15,27 Say '  CIS # 71212,1234         '
     @ 17,27 Say 'Press Any Key to Exit Demo '
     InKey(0)
     SetCursor( SC_NORMAL )             // Enable Cursor
     Quit
  EndIf

  Do While .t.
     cSrch := cSrch + Space(40-Len(cSrch))          // Pad to length
     SetColor( SysClr )
     DispBegin()
     @ 0, 0 Clear to MaxRow(), MaxCol()
     @ 0,30 Say "*** METAPARS DEMO ***"   Color "I"
     Clr_Win( nTop, nLft, nTop+2, nRit, SysWinClr )
     SetCursor( SC_NORMAL )             // Enable Cursor
     @ nTop+1, nLft+2 Say 'Enter Search String: ' Get cSrch Picture '@!S26'
     cSavScr2 := SaveScreen( 9, 14, 23, 65 )
     CLR_WIN( 9,14,23,65, SysWinClr )
     @  9,35 Say "*** HELP ***"                         Color "*I"
     @ 11,16 Say "The METAPARS() function allows for the following"
     @ 12,16 Say "string combinations:                            "
     @ 13,16 Say "                A                               "
     @ 14,16 Say "                A*                              "
     @ 15,16 Say "                A*B                             "
     @ 16,16 Say "                *A                              "
     @ 17,16 Say "                *A*                             "
     @ 18,16 Say "                *A*B                            "
     @ 20,16 Say "Where A and B are character strings and '*'     "
     @ 21,16 Say "follows Standard Regular Expression operation.  "
     DispEnd()
     Read
     SetCursor( SC_NONE )               // Disable Cursor
     RestScreen( 9, 14, 23, 65, cSavScr2 )

     cSrch := AllTrim( cSrch )          // Remove spaces...

     If LastKey() = K_ESC
        CLR_WIN( 10, 25, 19, 55, SysErrClr )
        @ 10,32 Say '*** THANK YOU ***'                 Color '*I'
        @ 12,27 Say 'Please forward any comments'
        @ 13,27 Say 'or concerns to:            '
        @ 14,27 Say '  Rod Cushman              '
        @ 15,27 Say '  CIS # 71212,1234         '
        @ 17,27 Say 'Press Any Key to Exit Demo '
        InKey(0)
        TESTPARS->( DbCommitAll() )
        TESTPARS->( DbCloseArea() )
        Quit
     EndIf

     cCond := METAPARSE( cSrch, 'DESC' )
     bFltr := &( "{||" + cCond + "}" )  // Make filter faster...

     DbSetFilter( bFltr, cCond )        // Activate filter
     DbGoTop()

     If Eof()                           // No Records found...
        CLR_WIN( 10, 25, 15, 55, SysErrClr )
        @ 10,32 Say '*** NONE FOUND ***'                Color '*I'
        @ 12,27 Say 'No Records Matched the     '
        @ 13,27 Say 'search criterion.          '
        InKey(3)
        DbClearFilter()
        DbGoTop()
        Loop                            // Skip back to the top and try again
     EndIf

     //
     // Perform a poor-man's browse of the filtered data.
     //
     DispBegin()
     cSavScr3 := SaveScreen( nBot+2,9, nBot+6,71 )
     Clr_Win( nTop+4, nLft, nBot, nRit, SysWinClr )
     Clr_Win( nBot+2, 10, nBot+6, 70, SysWinClr )
     @ nBot+2,35     Say "*** HELP ***"                 Color "*I"
     @ nBot+3,11 Say "Press <ESC> or <ENTER> to return to select window"
     @ nBot+4,11 Say "Filtered Browse of date for:                     "
     @ nBot+5,11 Say SubStr(cCond,1,59)
     DispEnd()
     DbEdit( nTop+5, nLft+1, nBot-1, nRit-1, { 'RecNo()', 'Desc' } )
     DispBegin()
     RestScreen( nBot+2, 9,nBot+6,71, cSavScr3)
     DispEnd()
  EndDo                                         // Main Loop

Return


/**************************************************************************
** Clears the area of the screen: ntop,nleft -> nbot,nright Color cColor **
**************************************************************************/
Function CLR_WIN
  Parameters nTop, nLeft, nBot, nRight, cColor, cBorder
  Local cOColor

  DEFAULT cColor  TO SetColor()
  DEFAULT cBorder TO B_DOUBLE + Space(1)        // Relies on box.ch

  DispBegin()
  tColor := SetColor()
  Set Color to                                  // Reset color to default
  SetColor( cColor )
  @ nTop,nLeft,nBot,nRight Box cBorder
  DispEnd()
Return(cOColor)
