* Source code to @..PROMPT and MENU..TO
* Reverse engineered by Frank Imburgio, CIS ID 76666,317
* 10/31/90 and 9/26/90
* Must be compiled with /n switch in order to get STATICs to work
#include "Inkey.ch"
#include "Menu.ch"
#include "Setcurs.ch"
STATIC aPrompts:={}
STATIC cAccelColor:=NIL
********
FUNC SetAccel(cColor)
********
IF cColor==NIL
   IF cAccelColor==NIL
      RETURN SetColor()
   ELSE
      RETURN cAccelColor
   ENDIF
ELSE
   cAccelColor=cColor
ENDIF
*********
FUNC __AtPrompt(nRow,nCol,cPrompt,cMsg)
*********
* This places the prompts on the screen and adds them to an array declared
* STATIC at the top of this code.
IF Empty(cMsg)
   cMsg=''
ENDIF
PromptSay(nRow,nCol,cPrompt,SetColor(),SetAccel(),MENUACCEL)
Aadd(aPrompts,{nRow,nCol,cPrompt,cMsg,AccelKey(cPrompt)})
********
FUNC __MenuTo(bVarblock,cVarName)
********
* that routine that does the keystroke handling and displays the
* highlighted menu action
Local nKey:=0,nCurrent:=0,nWidemess:=2,nNumprompts:=Len(aPrompts),nRetval:=0
Local cScreen,nRow,cPrompt,nCol,cMsg,nCount

* set cursor off, color to background color
Local cSaveColor :=SetColor(BarColor(SetColor()))
Local iSaveCursor:=SetCursor(SC_NONE)

* check the get-set block sent for a valid variable, set to one if necessary
IF Memvarblock(cVarname)==NIL
   nCurrent:=1
ELSE
   nCurrent:=Eval(bVarblock)
ENDIF
* find the widest message, store in nWidemess
AeVal(aPrompts,{|x| nWidemess:=Max(nWidemess,LEN(x[MENUMESS]))})

DO WHILE .T.
   * get the row, col, prompt, and message from the list..
   nRow   :=aPrompts[nCurrent,MENUROW]
   nCol   :=aPrompts[nCurrent,MENUCOL]
   cPrompt:=aPrompts[nCurrent,MENUPROMPT]
   cMsg   :=aPrompts[nCurrent,MENUMESS]

   * save the current choice in normal color
   cScreen:=SaveScreen(nRow,nCol,nRow,nCol+Len(cPrompt))

   * Highlight the current choice
   @ nRow,nCol SAY Strtran(cPrompt,MENUACCEL,'')

   * draw the current message if on, checking SET MESSAGE and CENTER
   IF Set(_SET_MESSAGE) # 0
      IF Set(_SET_MCENTER)
         @ Set(_SET_MESSAGE),(MaxCol()/2) - (nWideMess/2) ;
           SAY Padc(cMsg,nWidemess)
      ELSE
         @ Set(_SET_MESSAGE),0 SAY Padl(cMsg,nWidemess)
      ENDIF
   ENDIF

   ** Do the keypause...
   nKey=Inkey(0)

   * UnHighlight the current choice using RestScreen()
   RestScreen(nRow,nCol,nRow,nCol+Len(cPrompt),cScreen)

   * the big switch...
   DO CASE
   CASE nKey==K_HOME
      nCurrent:=1
   CASE nKey==K_END
      nCurrent:=nNumprompts
   CASE (nKey==K_UP .OR. nKey==K_LEFT)
      IF nCurrent>1
         nCurrent--
      ELSE
         IF Set(_SET_WRAP)
            nCurrent:=nNumprompts
         ENDIF
      ENDIF
   CASE (nKey==K_DOWN .OR. nKey==K_RIGHT)
      IF nCurrent<nNumprompts
         nCurrent++
      ELSE
         IF Set(_SET_WRAP)
            nCurrent:=1
         ENDIF
      ENDIF
   CASE nKey==K_ESC
      EXIT
   CASE nKey==K_ENTER
      nRetval:=nCurrent
      EXIT
   OTHERWISE
      * other keys - check for a match against the list of accelerator keys
      * saved when prompt list was created.
      FOR nCount=1 TO nNumprompts
         IF Upper(Chr(nKey))=Upper(Substr(aPrompts[nCount,MENUKEY],1,1))
            nCurrent=nCount
            EXIT
         ENDIF
      NEXT
      * user pressed a char key and it matched..
      IF nCount<nNumprompts+1
         nRetval=nCount
         EXIT
      ENDIF
   ENDCASE
ENDDO
* release the prompt list
aPrompts={}
* restore the color and cursor
SetColor(cSaveColor)
SetCursor(iSaveCursor)
* return the value
RETURN nRetval
************
STATIC FUNC BarColor(CoAttrib)
**************
* returns the second color in the dBase list: if dBase setting is
* W+/B,N/W returns 'N/W'
RETURN SUBSTR(coattrib,AT(",",coattrib)+1)
***********
STATIC FUNC AccelKey(cPrompt)
***********
* finds either the key specified as the accelerator key with the MENUACCEL
* character, or the first character (clipper default)
IF ! MENUACCEL $ cPrompt
   RETURN Upper(Substr(cPrompt,1,1))
ELSE
   RETURN Upper(SUBSTR(cPrompt,AT(MENUACCEL,cPrompt)+1))
ENDIF
********
STATIC FUNC PromptSay(nRow,nCol,cString,cNormal,cHighlight)
********
* places the prompt on the screen, highlighting the accelerator key in the
* ACCELCOLOR
Local nPlace
Local nRowSave          := Row()
Local nColSave          := Col()
Local cSavecolor        := Setcolor(cNormal)

* display String in normal color without Ampersands
@ nRow,nCol SAY Strtran(cString,MENUACCEL,'')

* Check for the ampersand
IF MENUACCEL $ cString
   nPlace=AT(MENUACCEL,cString)
ELSE
   nPlace=1
ENDIF
SetColor(cHighlight)
@ nRow,nCol+nPlace-1 SAY Substr(Strtran(cString,MENUACCEL,''),nPlace,1)
Setcolor(cSavecolor)
DevPos(nRowSave,nColSave)
RETURN NIL

