*********************************************************************
*
*  Program         :  Menu.Prg
*  Date            :  June 21, 1988
*  Author          :  G. McKechnie
*  Revision        :  May 5, 1990
*  Copyright (c)   RCM Software 1990 All rights reserved
*  Use Notes       :
*
*                  Main menu for any suite of programs
*
*********************************************************************





* Minimum dBase/Clipper environment
***********************************
SET BELL OFF
SET SCORE OFF
SET DATE BRITISH
SET CURSOR OFF

*SET KEY 306 TO ALT_M         && Memory(0)

* Need some color - you mono guys can get your own
* Change this to whatever your taste.
**************************************************
SETCOLOR("w/b,b/w,,,w/b")

* These vars have to appear in the main menu 
* module because they change with each system
*********************************************
prog_prefix = "RCM_"

* Change this to whatever you like
**********************************
title       = "RCM Software Pty. Ltd."


* Read in the menu info from the text file menu.txt
* Creates Public array menu_info and mvar menu_items
****************************************************
IF ! MENU_TEXT("menu.txt")    

   * Out of here
   *************
   QUIT

ENDIF

* Display the menu screen - give it a Framework look.
* Clear the top & bottom line which are the status lines
********************************************************
CLS(STANDARD(),"")                   && MW likes 112,176
PRINT(24,0,"",STANDARD(),MAXCOL()+1)
PRINT(0, 0,"",STANDARD(),MAXCOL()+1)

* Tell them what day it is
**************************
PRINT(0,1,TODAY(),STANDARD()+8)
PRINT(0,FLUSH_RT(title)+2,title,STANDARD()+8)

* Better tell them what time it is too
**************************************
CLOCK12(24,70,ROLOC(STANDARD()))

* Check for a previous bad exit
* Re-index all files etc.
*******************************
* IF ! index_ok
*    REBUILD()
* ENDIF

* Initialise mvars used by BAR_MENU()
*************************************
wrapping      = .F.     
shadow_on     = .T.     && Shadowed pull downs
bar_choice    = 1       && Default bar menu item

* BLINKER - Pack and get rid of whatever is in memory
*****************************************************
BLIMEMPAK(-1)
BLIOVLCLR()

* Start of main loop
********************
DO WHILE .T.


   * Parameters are array name, bar menu row, 
   * message row, help_code, shadowed pulldowns
   ********************************************
   bar_choice = BAR_MENU(menu_info, 3, 24, "MAIN",shadow_on)


   * Change in rcm.h
   *****************
   IF bar_choice = 7.1
      UNCLOCK12()
      SET CURSOR ON
      SETCOLOR("")
      CLEAR
      EXIT
   ENDIF

ENDDO

* EXTERNAL ALT_M

* \-------------------------- Eof() Menu.prg -----------------------------







