*** Program : MENUCLOK.PRG
*** Author : Rejean Lavoie, Lachine, Quebec
*** Date :  1989-02-13
*
* This program displays a main menu with the date and
* time displayed and updated every minute.
*
set talk OFF
set echo OFF
do while .T.
 clear

* Set up the main menu screen

 @3,21 to 16,51 double
 @4,25 say '--- M A I N   M E N U ---'
 @6,25 say '0 - EXIT'
 @7,25 say '1 - OPTION # 1'
 @8,25 say '2 - OPTION # 2'
 @9,25 say '3 - OPTION # 3'
 @10,25 say '4 - OPTION # 4'
 @11,25 say '5 - OPTION # 5'
 @12,25 say '6 - OPTION # 6'
 @13,25 say '7 - OPTION # 7'
 @15,25 say 'Which one... '

 FINI2=.F.                    && FINI2 is the flag to exit the loop
 TIM="00:00"                  && The initial clock string.
 D=CTOD("01/01/81")           && The initial date string.
 set escape off

* This loop checks & updates the date and time on the screen if it needs
* updating. It also checks for a one key stroke from the keyboard for
* a menu selection.

 do while .not. FINI2       && FINI2 must be TRUE to exit this loop.
  store inkey() to ANS      && Scan keyboard and key pressed.
  if ANS=0                  && ANS=0 if not pressed.
   if left(time(),5) <> TIM     && If not pressed then check if the
    TIM=left(time(),5)          && displayed time needs updating.
    if D <> date()              && Check if the date has changed.
     D=date()
     DATE=cdow(D)+"  "+left(cmonth(D),3)+" "+str(day(D),2)+", "+str(year(d),4)
     @18,21 clear to 18,70      && Not same date so clear the line
     @18,21 say DATE            && and put in the new date.
    endif
    @18,47 say TIM          && Display the new time.
    @15,37 say " "          && Put cursor back to select.
   endif
   loop           && Go back to the start of the DO WHILE .not. FINI2
  endif

* Check the value of the key pressed and find out what it is.

  ANS=ANS-48   && Subtract 48 to convert ASCII key to its intended value.
  if ANS+21=0  && Check for the ESC key. If so, make ANS=0.
    ANS=0
  endif
  if ANS<0 .or. ANS>7  && Disregard anything less than 0 and more than 7.
    loop
  endif
  FINI2=.t.          && Set the finish flag TRUE to exit this loop.
  ?? ltrim(str(ANS)) && Display the key selected.
 enddo

* A valid key has been pressed, so do the
* program as selected from the menu.

 set escape ON
 on error loop        && In case program doesn't exist, go back to top.
 do case
  case ANS = 1        && If key pressed was 1
   do OPTION 1
  case ANS = 2        && If key pressed was 2
   do OPTION 2
  case ANS = 3        && If key pressed was 3
   do OPTION 3
  case ANS = 4        && If key pressed was 4
   do OPTION 4
  case ANS = 5        && If key pressed was 5
   do OPTION 5
  case ANS = 6        && If key pressed was 6
   do OPTION 6
  case ANS = 7        && If key pressed was 7
   do OPTION 7
  case ANS = 0        && If key pressed was 0 or ESCape
   exit               && then exit to the dBase prompt.
 endcase
enddo
set escape on
on error
*
*** end of program  MENUCLOK.PRG
