** Function: menu_box()
** Syntax:  menu_box (t,l,b,r,box characters,message,intense(T or F),color)
** Prupose: draw a menu box in color choice with shadowing, and center
**          a message on top in normal or intense
**
** example:
**  db_line = chr(210)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+;
**            chr(200)+chr(186)
**  shadow = "N+/"       && need this for function
**  bright = "W+/B"      && need this for function
**  normal = "W/B"       
**  
**     menu_box(10,10,15,25,db_line,"Center Message",.T.,normal)
**
FUNCTION menu_box
	PARAMETERS t,l,b,r,box_str,str,intense,shade
	PRIVATE l_spaces,r_spaces,msg_len

	* make shadow
	SET COLOR TO &shadow
	@ t+1,l+1,b+1,r+1 BOX replicate(chr(177),9)

	* draw box
	SET COLOR TO &shade
	@ t,l,b,r BOX box_str

	* calculate gap on left & right sides
	msg_len=len(str)
	l_spaces=int(((r-l-1)-msg_len)/2)
	r_spaces=l_spaces

	* adjust left side if not equal
	IF r_spaces + l_spaces +msg_len !=(r-l-1)
		l_spaces=l_spaces+1
	ENDIF

	* draw characters in left side
	@ t,l SAY substr(box_str,1,1)
	@ t,l+1 SAY replicate(substr(box_str,2,1),l_spaces)

	* draw message (in intense color if specified) on top line of box
	IF intense
		SET COLOR TO &bright
		@ t,l+l_spaces+1 SAY str
		SET COLOR TO &norm
	ELSE
		@ t,l+l_spaces+1 SAY str
	ENDIF

	* draw characters on left side
	@ t,l+l_spaces +1+len(str) SAY replicate(substr(box_str,2,1),r_spaces)
	@ t,r SAY substr(box_str,3,1)

RETURN ('')
