*---- Program     : MENU.prg
*---- Author      : Keith Roddey, 2823 Corning St. #2, L.A., CA. 90034
*---- Description : This program not only illustrates the types of menus
*----               MENU.bin creates, it allows you to try out different
*----               color combinations with the Default menu type.
*---- Release Date: 05/06/88

SET STATUS OFF
SET TALK OFF
SET ESCAPE OFF
CLEAR ALL
SET CONFIRM ON
SET CONSOLE ON
SET BELL OFF
SET DELIMITERS OFF
SET DEVICE TO SCREEN
SET INTENSITY OFF
SET MENU ON
SET PRINT OFF
SET PROCEDURE TO
SET SCOREBOARD OFF
LOAD MENU
bc         = CHR(177)
attr1      = "/N"
attr2      = "R+"
attr3      = "GR+"
attr4      = "/BG"
attr5      = "W+"
attr6      = "N"
attr7      = "BG+"
attr8      = "B"
attr9      = "W/R"
attr10     = "B/N"
attr11     = "N/W"
h_menu     = "01,0,0,HORIZONTAL MENU,Vertical,Left_Justified,Default_(Color),/H,/O"
v_menu     = "01,1,0,VERTICAL MENU,Post Hours,Update Employee File,Reports,"+;
"u(T)ilities,e(X)it,/V,/K,,,T,X"
l_menu     = "01,1,0,LEFT JUSTIFIED MENU,Detail Report,Full Budget Report,"+;
"Summary Report,Exception Report,Year End Report,Vendor Listing,Printer Setup"+;
",Pack & Reindex,/L,/S1,/K,,,,,,,-"
main_menu  = "01,?,2,1,MENU COLORS,Title,Options,Direct Keystrokes,Shadow,"+;
"Help Message,Screen Background,/K,,,,,B,/O"
title_menu = "01,11,15,TITLE COLORS,Background,Text,Line,/S1"
opts_menu  = "01,11,15,OPTION COLORS,Background,Text Selected,Text Other,"+;
"Line Top,Line Bottom,/S1,/K,S,O,T,B"
back_menu  = "05,5,9,SCREEN BACKGROUND COLOR,N (Black),W (White),R (Red),G"+;
" (Green),B (Blue),RG (Brown),RB (Purple),GB (Light Blue),/K,,,,,1,2,3"
fore       = "W"
back       = "B"
draw       = .T.
DO WHILE .T.
  IF draw
  SET COLOR TO W/N
  CLEAR
  @  2, 5 SAY "THIS IS AN EXAMPLE OF A HORIZONTAL LIGHT BAR MENU"
  @  4, 5 SAY "You select an option by moving the Light Bar to the option"
  @  5, 5 SAY "that you want to take and then press <Return>.  You can move"
  @  6, 5 SAY "the light bar with the <Arrow>, <Home>, <End>, or <Space Bar> keys."
  @  7, 5 SAY "You can also choose an option by pressing the Direct Keystroke of"
  @  8, 5 SAY "a menu option.  The Direct Keystroke is usally the 1st character"
  @  9, 5 SAY "of a menu option.  The <Esc> key is used to terminate a menu."
  @ 10, 5 SAY "Pressing <Esc> at this menu will cause this demonstration"
  @ 11, 5 SAY "program to terminate."
  @ 12, 5 SAY "All menu types can have a Menu Title, as this one does.  Horizontal"
  @ 13, 5 SAY "menus are displayed on one line with the Menu Title and Options"
  @ 14, 5 SAY "delimited by 2 spaces."
    draw       = .F.
  ENDIF
  CALL MENU WITH h_menu
  DO CASE
  CASE VAL(h_menu) = 0
    EXIT
  CASE VAL(h_menu) = 1
    SET COLOR TO +W
    @ 16, 5 SAY "THIS IS AN EXAMPLE OF A VERTICAL LIGHT BAR MENU"
    @ 18, 5 SAY "Vertical menus center the title and options within the box that"
    @ 19, 5 SAY "is drawn.  The characters used to draw the box can be changed."
    @ 20, 5 SAY "With each of the menus, you can change what colors are used to"
    @ 21, 5 SAY "draw them.  The /K switch was used to override the Direct"
    @ 22, 5 SAY "Keystrokes for the e(X)it and u(T)ilities options."
    @ 23, 5 SAY "To terminate this menu press the <Esc> key or the <X> key."
    SET COLOR TO W
    DO WHILE .T.
      CALL MENU WITH v_menu
      IF VAL(v_menu) = 0 .OR. VAL(v_menu) = 5
        EXIT
      ENDIF
    ENDDO
    @ 16, 0 CLEAR
  CASE VAL(h_menu) = 2
    SET COLOR TO +W
    @ 16, 5 SAY "THIS IS AN EXAMPLE OF A LEFT JUSTIFIED LIGHT BAR MENU"
    @ 18, 5 SAY "Left Justified menus display the title and options left justified"
    @ 19, 5 SAY "within the box that is drawn.  In addition,  the Direct"
    @ 20, 5 SAY "Keystrokes are diplayed to the left of each of the menu options."
    DO WHILE .T.
      CALL MENU WITH l_menu
      IF VAL(l_menu) = 0
        EXIT
      ENDIF
    ENDDO
    @ 16, 0 CLEAR
  CASE VAL(h_menu) = 3
    CLEAR
    draw       = .T.
    redraw     = .T.
    DO WHILE .T.
      IF redraw
        SET COLOR TO &fore./&back
        CLEAR
        SET COLOR TO &back./&fore
        @  0, 0 SAY bc+bc+bc+bc+bc+" This Utility will help you decide what "+;
        "colors to use for your menus "+bc+bc+bc+bc+bc+bc
        SET COLOR TO &fore./&back
        @  5,40 SAY "Title Background     [      ]"
        @  6,40 SAY "Title Text           [      ]"
        @  7,40 SAY "Title Line           [      ]"
        @  8,40 SAY "Option Background    [      ]"
        @  9,40 SAY "Option Text Selected [      ]"
        @ 10,40 SAY "Option Text Other    [      ]"
        @ 11,40 SAY "Option Line Top      [      ]"
        @ 12,40 SAY "Option Line Bottom   [      ]"
        @ 13,40 SAY "Direct Keystrokes    [      ]"
        @ 14,40 SAY "Shadow               [      ]"
        @ 15,40 SAY "Help Message         [      ]"
        @ 17,35 SAY "The following color switches are valid:"
        @ 19,40 SAY "W - white, N - none,"
        @ 20,40 SAY "R - red,  G - green,  B - blue,"
        @ 21,40 SAY "+ - high intensity."
        @ 23,35 SAY "Background colors must start with /."
        SET COLOR TO +&fore./&back
        @  5,62 SAY attr1
        @  6,62 SAY attr2
        @  7,62 SAY attr3
        @  8,62 SAY attr4
        @  9,62 SAY attr5
        @ 10,62 SAY attr6
        @ 11,62 SAY attr7
        @ 12,62 SAY attr8
        @ 13,62 SAY attr9
        @ 14,62 SAY attr10
        @ 15,62 SAY attr11
        redraw     = .F.
      ENDIF
      CALL MENU WITH main_menu
      DO CASE
      CASE SUBSTR(main_menu,4,1) = "Y"
        @ 24, 0 SAY "<< NO HELP AVAILABLE >>  Press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        @ 24, 0
      CASE VAL(main_menu) = 0
        EXIT
      CASE VAL(main_menu) = 1
        DO WHILE .T.
          CALL MENU WITH title_menu
          IF VAL(title_menu) = 0
            EXIT
          ENDIF
          tag        = LTRIM(STR(VAL(title_menu)))
          attr&tag   = attr&tag+SPACE(6-LEN(attr&tag))
          @ 3,35 SAY "ENTER COLOR SWITCHE(S)"
          @ 4+VAL(tag),62 GET attr&tag PICTURE "@!"
          READ
          @ 3,35 SAY "                      "
          attr&tag   = TRIM(attr&tag)
          CALL MENU WITH "/C"+attr1+","+attr2+","+attr3+","+attr4+","+attr5+","+;
          attr6+","+attr7+","+attr8+","+attr9+","+attr10+","+attr11
        ENDDO
      CASE VAL(main_menu) = 2
        DO WHILE .T.
          CALL MENU WITH opts_menu
          IF VAL(opts_menu) = 0
            EXIT
          ENDIF
          tag        = LTRIM(STR(VAL(opts_menu)+3))
          attr&tag   = attr&tag+SPACE(6-LEN(attr&tag))
          @ 3,35 SAY "ENTER COLOR SWITCHE(S)"
          @ 4+VAL(tag),62 GET attr&tag PICTURE "@!"
          READ
          @ 3,35 SAY "                      "
          attr&tag   = TRIM(attr&tag)
          CALL MENU WITH "/C"+attr1+","+attr2+","+attr3+","+attr4+","+attr5+","+;
          attr6+","+attr7+","+attr8+","+attr9+","+attr10+","+attr11
        ENDDO
      CASE VAL(main_menu) >= 3 .AND. VAL(main_menu) <= 5
        tag        = LTRIM(STR(VAL(main_menu)+6))
        attr&tag   = attr&tag+SPACE(6-LEN(attr&tag))
        @ 3,35 SAY "ENTER COLOR SWITCHE(S)"
        @ 4+VAL(tag),62 GET attr&tag PICTURE "@!"
        READ
        @ 3,35 SAY "                      "
        attr&tag   = TRIM(attr&tag)
        CALL MENU WITH "/C"+attr1+","+attr2+","+attr3+","+attr4+","+attr5+","+;
        attr6+","+attr7+","+attr8+","+attr9+","+attr10+","+attr11
      CASE VAL(main_menu) = 6
        CALL MENU WITH back_menu
        IF VAL(back_menu) > 0
          back       = TRIM(SUBSTR(" N W R G B RGRBGB",VAL(back_menu)*2,2))
          fore       = SUBSTR("WBWBWWWB",VAL(back_menu),1)
          redraw     = .T.
        ENDIF
      ENDCASE
    ENDDO
  ENDCASE
ENDDO
SET COLOR TO W/N
CLEAR
QUIT
