*
*  Program: mem_rep.PRG
*  For    : Clipper Summer '87
*  Author : Tony Kirk
*  Date   : 02/19/88
*  Purpose: Automates writing code segments which read field list and create
*           matching memory variables.  Writes the code to create the memory
*           variables, and the code to replace the memory variables into the
*           dbf.  In other words, "dbf->fields TO m->fields TO dbf->fields"
*
*  Notes  : I know there are routines/functions "out there" that perform the
*           routine globally, using macros.  In a large dbf (many fields), a
*           performance degradation will occur.  MEM_REP.PRG  will create as
*           many of these routines as you wish, all hard coded to work  with
*           the one data file only.  Creates a completely new file which can
*           later be merged with other prgs/procs.
*
*  *******  I can't say this proc is perfect.  Make a separate directory with
*  NOTICE!  MEM_REP.EXE, your DBF file, and any associated DBT file.  Then I
*  *******  recommend you experiment with it for a while.  (See MEM_DEMO.PRG)
*
*  Details: 1  Ignores MEMO fields.
*           2  Performs the routine on logical fields, but the bugs in the
*                Summer '87 version of Clipper may prohibit correct use of a
*                logical field, as of 02/19/88 (see anomaly report #5).
*           3  Notice necessary parameters in created proc (xxx_2MEM).
*           4  To be a standalone program.  Variable names may need changed if
*                it is to be merged with another program.
*           5  Due to use of "setcolor", requires EXTEND.LIB.
*           6  If using "blank" memvars, must use pict clause in editing
*

save scre to oldscrn

if iscolor()
  oldcolor=setcolor('w+/b,bg+/n,b,,bg+/b')
else
  oldcolor=setcolor('w+,i,,,u')
endif

clear screen

@ 1,35 say 'MEM_DBF'
@ 2,21 say 'Press ^W to finish entry, Esc to exit'

@ 4,10 to 16,70 double

dbfname=space(12)                       && dbf file name
dbfpre ='          '                    && dbf    alias    prefix
mempre ='M->'                           && memory variable prefix
prgpre ='   '                           && procedure name  prefix
prgname=space(12)                       && proc file name
pubstr =''                              && public variable string
numstr =''                              && numeric (store 0 to..)

do while .t.
  @  6,20 say 'DBF file name to use   :' get dbfname pict '@K !!!!!!!!.dbf' valid is_dbf(dbfname)
  @  7,20 say 'PRG file name to create:' get prgname pict '@K !!!!!!!!.prg' valid no_prg(prgname)
  @  9,20 say 'DBF field alias prefix :' get dbfpre pict '@K@!'
  @ 10,20 say 'MEM variable prefix    :' get mempre pict '@K@!'
  @ 11,20 say 'PRG procname prefix    :' get prgpre pict '@K@!'
  @ 13,15 say '1)  DBF file must exist.  '
  @ 14,15 say '2)  PRG procname prefix - "xxx"=procname prefix:'
  @ 15,15 say '    dbf -> mem: xxx_2mem    mem -> dbf: xxx_2dbf'
  read
  if lastkey() = 18 .or. lastkey() = 3
    loop
  endif
  if lastkey() = 27
    set alte off
    set alte to
    close all
    setcolor(oldcolor)
    rest scre from oldscrn
    return
  endif
  @ 22,0 say ''
  op=' '
  wait 'Press [Enter] to begin, any other key to return.' to op
  if lastkey()<>13
    @ 22,0 clear
    loop
  endif
  @ 22,0 clear
  dbfpre=ltrim(trim(dbfpre))
  mempre=ltrim(trim(mempre))
  prgpre=ltrim(trim(prgpre))
  use (dbfname)
  cnt=fcount()
  set cons off
  set alte to &prgname
  set alte on
  ? '********************'
  ? '*  Function &prgpre._2MEM'
  ? '*'
  ? '*  Parameter : Logical - where T equates memvars to contents of fields'
  ? '*                        and   F equates memvars to empty fields'
  ? '********************'
  ? '*  Date : '+dtoc(date())
  ? ''
  ? 'func &prgpre._2mem'
  ? 'para in_mem'
  ? ''
  for i=1 to cnt
    fld=fieldname(i)
    vtype=type('&fld')
    if vtype<>'M'
      if len(pubstr)>0
        pubstr=pubstr+','
      endif
      pubstr=pubstr+'&fld'
      if len(pubstr)>70
        ? 'publ '+pubstr
        pubstr=''
      endif
    endif
  next i
  if len(pubstr)<>0
    ? 'publ '+pubstr
  endif
  ? ''
  for i=1 to cnt
    fld=fieldname(i)
    vtype=type('&fld')
    if vtype<>'M'
      mem=mempre+fieldname(i)
      dbf=dbfpre+fieldname(i)
      do case
       case vtype='C'
         ? '&mem = iif(in_mem,&dbf,spac(len(&dbf)))'
       case vtype='D'
         ? '&mem = iif(in_mem,&dbf,ctod("  /  /  "))'
       case vtype='L'
         ? '&mem = iif(in_mem,&dbf,.f.)'
       case vtype='N'
         ? '&mem = iif(in_mem,&dbf,0)'
      endcase
    endif
  next i
  ? ''
  ? 'return (.t.)'
  ? ''
  ? ''
  ? ''
  ? '********************'
  ? '*  Function &mempre._2DBF'
  ? '********************'
  ? '*  Date : '+dtoc(date())
  ? ''
  ? 'func &prgpre._2dbf'
  ? ''
  for i=1 to cnt
    fld=fieldname(i)
    vtype=type('&fld')
    if vtype<>'M'
      mem=mempre+fieldname(i)
      dbf=dbfpre+fieldname(i)
      ? 'repl &dbf with &mem'
    endif
  next i
  ? ''
  ? 'return (.t.)'
  set alte off
  set alte to
  set cons on
  use
  dbfname=space(12)                       && dbf file name
  dbfpre ='          '                    && dbf    alias    prefix
  mempre ='m->'                           && memory variable prefix
  prgpre ='   '                           && procedure name  prefix
  prgname=space(12)                       && proc file name
  pubstr=''                               && public var declaration string
enddo


*************
*
*  is_dbf
*
*************


func is_dbf

para db

if file('&db')
  return (.t.)
else
  ?? chr(7)
  return (.f.)
endif


*************
*
*  no_prg
*
*************

func no_prg

para pr

if ! file('&pr')
  return (.t.)
else
  junk=savescreen(20,5,22,75)
  @ 20,5 to 22,75
  @ 21,10 say '&PR exists.  Overwrite? '
  @ 21,50 prom ' No '
  @ 21,58 prom ' Yes '
  menu to no_op
  if no_op=2
    no_op=(.t.)
  else
    no_op=(.f.)
  endif
  restscreen(20,5,22,75,junk)
  return no_op
endif
