/* Program :MEMOUTIL.C 
   Author -:Kevin E. Saffer (from a program written by Brian Russell and
            David Dodson, originally published in Nantucket News, Vol 1,1.
   Date ---:December 4, 1986

   Notes --:This program provides two additional memo handling functions
            for the Clipper compiler, Autumn '86 version.

            The first function, MEMOLINE, provides a line extract function
            for manipulating memo fields.  This is useful when you wish to 
            print or display a selected number of lines from a memo field.

            Specify the memo field, the starting line number, and the number
            of lines to be returned.

            Will return a null if specified lines are not found.

            All filter characters are replaced with the specified replacement.
            This allow memos edited with word processors such as Wordstar to 
            be processed correctly.

     Syntax: ?? MEMOLINE(MemoField,StartLine,NumberOfLines,Filter,Replacement)

            
            The second function, MEMOFIND, provides a string search function
            that is dramatically faster that the AT() function in Clipper.
            It is provided for applications that must make text searches 
            through memo fields.  Note that MEMOFIND only works on the 
            current record, you must scan the data file using SKIPS.

            MEMOFIND will return a logical .T. if the specified character
            string is present in the memo field, otherwise will return .F.

            Be aware that MEMOFIND is case sensitive, and the passed paramenters
            will have to be converted to upper case before processing to get a
            match.

            Syntax: IF MEMOFIND(SearchString,Memofield,Filter,Replacement)
                      ? "Found it!"
                    ENDIF                                                  */

/* various defines and external declarations from extend.h,
   a program file distributed on your Clipper disks         */

#include "extend.h"

#define LINE_FEED '\n'
#define TRUE 1
#define FALSE 0

MEMOLINE()
{
  char *pos1;			/* pointers to source/target memos */
  char *pos2;			
  char *str1;
  char *str2;
  char *testchar;        	/* characters for filtering */
  char *filtchar;
  char *replchar;
  unsigned StartLine;		/* passed parameters */
  unsigned NumOfLines;
  unsigned CurrentLine;
 
  /* check passed parameters */
  if (PCOUNT >= 5 && ISCHAR(1) && ISNUM(2) && ISNUM(3) && ISCHAR(4) && ISCHAR(5))
  {
    pos1 = _parc(1);		/* position in source memo */
    str2 = pos1;                /* assign space for the target memo */
    pos2 = str2;                /* position in target memo */
    CurrentLine = 1;     	/* line counter */
    StartLine = _parni(2);      /* passed start line */
    NumOfLines = _parni(3);     /* passed number of lines */
    filtchar = _parc(4);	/* character to filter out */
    replchar = _parc(5);	/* character to replace with */
    
    /* skip to specified start line */
    while ((CurrentLine < StartLine) && (*pos1))
    {
      if (*pos1 == *filtchar)		/* check for filter charracter */
         *testchar = *replchar;      	/* replace with specified character */
      else
         *testchar = *pos1;

      if (*testchar == LINE_FEED)	/* check for a line feed */
         CurrentLine++;			/* bump	line counter if found */
      *pos1++;				/* bump source pointer */
    }  

    /* build target memo field */
    while (((CurrentLine - StartLine) < NumOfLines) && (*pos1))
    {
      *pos2 = *pos1;		/* add character to target */
      if (*pos2 == *filtchar)	/* check for filter charracter */
         *pos2 = *replchar;     /* replace with specified character */
      if (*pos2 == LINE_FEED)	/* check for a line feed */
         CurrentLine++;		/* bump line counter if found */
      *pos1++;			/* bump source pointer */
      *pos2++;                  /* bump target pointer */
    }

    *pos2 = '\0';		/* terminate target memo */
    _retc(str2);		/* return it to Clipper */
  }
  else
    _retc("");			/* error, return null */
}


MEMOFIND()
{
  char *pos1;			/* pointers to string/memo */
  char *pos2;			
  char *filtchar;		/* characters for filtering */
  char *replchar;
  char *sourchar;
  char *targchar;

  /* check passed parameters */
  if (PCOUNT >= 4 && ISCHAR(1) && ISCHAR(2) && ISCHAR(3) && ISCHAR(4))
  {
    pos1 = _parc(1);		/* position in search string */
    pos2 = _parc(2);            /* position in memo */

    /* search for a match */
    while (*pos1 && *pos2)      /* loop until end of memo */
    {
      if (*pos1 = *filtchar)    /* filter the search character */
        *sourchar = *replchar;
      else
        *sourchar = *pos1;

      if (*pos2 = *filtchar)	/* filter the memo character */
        *targchar = *replchar;
      else
        *targchar = *pos2;

      while (*sourchar == *targchar && *sourchar && *targchar)		/* loop while strings match */
      {
        *pos1++;                         /* bump both pointers */
        *pos2++;

        if (*pos1 = *filtchar)       	/* filter both again */
          *sourchar = *replchar;
        else
          *sourchar = *pos1;

        if (*pos2 = *filtchar)
          *targchar = *replchar;
        else
          *targchar = *pos2;
      }

      if (*sourchar != '\0')        	/* reset search string if needed */
        pos1 = _parc(1);

      if (*targchar)
        *pos2++;
    }  
    if (*sourchar == '\0')              /* did we make it to the end of the search string? */
      _retl(TRUE);                    	/* yes, return a .T. */
    else
      _retl(FALSE);                    	/* no, return a .F. */
  }
  else
  _retl(FALSE);                         /* function failed, return .F. */
}

/* EOF:MEMOUTIL.C */
