****************************************************************************
*  Function: MemoShow()
*
*   Version:  1.1
*    Author:  Steve Hoover
*      Date:  03/21/90
*  
*
*  Syntax:  MemoShow(<expC1>, [<expN1>, <expN2>, <expN3>,
*                   <expN4>] [,<expL1>] [,<expC2>] [,<expN5>] 
*                   [,<expN6>])
*
*  Purpose: To display character strings and memo fields.
*           MemoShow() contains all of MemoEdit()'s parameters,
*           but I have changed the functionality of some of them
*           that were used mostly for editing purposes.  
*           I purposely copied MemoEdit()'s parameter structure
*           to make it easy to implement in places where Memoedit()
*           is already being used.  The changes are as follows:
*
*           <expL1> is now used to turn off/on a line highlight
*                   bar.
*           <expN8> is now used to tell the function how many columns
*                   to move right when the Tab key is pressed.
*          <expN10> is now used to tell the function how many columns
*                   to move left when the Shft-Tab keys are pressed
*
*  Arguments: 
*
*  <expC> is the character string or memo field to edit.
*
*  <expN1>, <expN2>, <expN3>, <expN4> define the
*  display window coordinates in the following order: top, left,
*  bottom, and right.  If omitted, the entire screen is used.
*
*  <expL1> turn Off/On Line Highlighting (.F. = Off -- .T. = On)          
*
*  <expC2> is the name of a user function (a Clipper
*  user-defined function) to execute whenever a key is pressed. 
*  Specify the function name without both the parenthetical suffix
*  and arguments.                                        
*               
*  <expN5> determines the line length.  If <expN5> is
*  greater than width of the window (<expN4> - <expN2> - 1), the
*  window scrolls horizontally.  The default is (<expN4> -
*  <expN2> - l).
* 
*  <expn6> determines the tab size.  Default is four.
*
*  <expN7> is the initial line of the memo to place the cursor
*          Default is 1.
*
*  <expN8> is the number of columns to move right when Tab
*          is pressed.  Default is 5.
*
*  <expN9> is the intial row to place the cursor relative
*          to the window position.  The default is 1.
*
*  <expN10> is the number of columns to move left when Shft-Tab
*           is pressed.  Default is 5.
*
*  All arguments are optional.  You must, however, pass a
*  dummy argument for any argument you wish to skip.
*
*  Returns: Unaltered Display String
*  
*  Usage:
*
*  MemoShow() is a general purpose text display function you can use 
*  in your applications for a variety of purposes. It includes a user 
*  function to allow programming of other activites germane to the 
*  current text display task.
*
*               MemoShow() Navigation Keys
*
*      Key                          Purpose
*      -------------------------------------------------------
*      Uparrow or Ctrl-E            Move up one line 
*      Dnarrow or Ctrl-X            Move down one line. 
*      Leftarrow or Ctrl-A          Move to Next Block Left
*      Rghtarrow or Ctrl-F          Move to Next Block Right
*      Ctrl-Home                    Beginning of the memo 
*      Ctrl-End                     End of the memo 
*      PgUp                         Next edit window up 
*      PgDn                         Next edit window down 
*      Ctrl-PgUp                    Beginning of current window 
*      Ctrl-PgDn                    End of current window
*      Tab                          Move n spaces to right
*      Shift-Tab                    Move n spaces to left
*      Return                       Move to next line And Clear OffSet
*
*               MemoShow() Terminate Keys
*      
*      Key                          Purpose
*      -------------------------------------------------------
*      Esc                          Terminate 
* 
*      I couldn't use Ctrl-W to terminate because it is the 
*      same as Ctrl-End (23)
*
*
*Libraries: EXTEND.LIB
*
*     Uses: MEMOLINE(), MLCOUNT()
*
*    Notes: MEMOLINE() slows down substantially when you exceed
*           a hundred or so lines.  I farted around with buffering
*           the string so that it displayed faster, but the workaround
*           was kind of kludgy and I didn't have the time to spend
*           on finding an elegant solution.  For my purposes, (A Help
*           System Display) this version worked fine.  I wouldn't use
*           this function for displaying large screen reports without
*           re-writing it to buffer the input string.  I also didn't
*           have time to implement the user-defined function feature.
*           I really don't know if this is as major in MEMOSHOW() as
*           it would be in MEMOEDIT().  The hook is there (right after
*           the INKEY(0)) and anyone who wants to design that part
*           please do.  I probably will eventually, but I haven't the
*           time right now.     
*
* Upgrades: I'm releasing this to the public domain and any changes
*           or improvements are welcome and appreciated.  All I ask
*           is that you upload the changes back to Compuserve and
*           drop me a line letting me know that changes were made.
*           My user id is 71257,2553.  The first major change
*           should probably be breaking large strings into smaller
*           strings so that the MEMOLINE() search isn't so slow. Also
*           the user defined function part needs to be designed.  It
*           could probably use some tightening up and optimizing too.
*
*     Bugs: I wrote this in about 5 hours and there may be a few bugs
*           in it that I didn't catch.  If you do find some bugs, either
*           let me know or go ahead and fix them and then upload the fix
*           to Compuserve.
*
*
* Memory Use: MEMOLINE() =   654 bytes  
*             MLCOUNT()  =   328 bytes
*             MemoShow() =  2952 bytes without line numbers
*                        -------------
*                  Total    3934 bytes
*
*               vs.
*
*             MEMOEDIT() = 16602 bytes
*
*    I know this isn't a true representation, but you get the idea.
* I saved 11k in my application when I substituted MemoShow() for
* MEMOEDIT().  The above representation also doesn't take into account
* the ability to overlay MemoShow() (if your using ALINK) and the 
* absence of duplicate buffer variables created by MEMOEDIT. Now if
* I could just figure out how to write this function in C.......... (hint,hint)
*
*******************************************************************************

FUNCTION MemoShow

PRIVATE DispStr,TopRow,TopCol,BottRow,BottCol,DispFunc,LineLength,LineHigh,TabSize
PRIVATE InitLine,TabRight,InitWLine,TabLeft,CurrentColor,HighColor,DispOffSet
PRIVATE MaxDispLines,DispPageWidth,DispPageLength,DispOffSet,DispLine,WindLine, 
PARAMETERS DispStr,TopRow,TopCol,BottRow,BottCol,LineHigh,DispFunc,LineLength,TabSize,InitLine,TabRight,InitWLine,TabLeft

CurrentColor = SETCOLOR()
HighColor = SUBSTR(CurrentColor,AT("/",CurrentColor)+1,1) + "/" + SUBSTR(CurrentColor,1,AT("/",CurrentColor)-1)
** Check And Make Sure Parameters Were Passed OK
IF TYPE("DispStr") <> "C"
  ** No String Specified
  RETURN(DispStr)          
ENDIF   
IF TYPE("TopRow") <> "N"
  ** Top Row Not Specified
  TopRow = 0
ENDIF  
IF TYPE("TopCol") <> "N"
  ** Top Col Not Specified
  TopCol = 0    
ENDIF  
IF TYPE("BottRow") <> "N"
  ** Bottom Row Not Specified
  BottRow = 23
ENDIF  
IF TYPE("BottCol") <> "N"
  ** Bottom Col Not Specified
  BottCol = 79
ENDIF    
IF TYPE("DispFunc") <> "C"
  ** User Defined Function Not Specified
  DispFunc = " "
ENDIF    
IF TYPE("LineLength") <> "N"
  ** Line Length Not Specified
  LineLength = BottCol - TopCol - 1
ENDIF  
IF TYPE("LineHigh") <> "L"
  ** Line highlight toggle Not Specified
  LineHigh = .T.
ENDIF  
IF TYPE("TabSize") <> "N"
  TabSize = 4
ENDIF    
IF TYPE("InitLine") <> "N"
  InitLine = 1
ENDIF  
IF TYPE("TabRight") <> "N"
  TabRight = 5
ENDIF  
IF TYPE("InitWLine") <> "N"
  InitWLine = 1
ENDIF  
IF TYPE("TabLeft") <> "N"
  TabLeft = 5  
ENDIF    

** Determine The Number Of Lines In String Based Upon Window Size
MaxDispLines = MLCOUNT(DispStr,LineLength,TabSize,.T.)
DispPageWidth  = BottCol - TopCol 
DispPageLength = BottRow - TopRow + 1

** Number Of columns offset for Tab and Shft-Tab
DispOffSet = 1

** Setup Starting Line And Block Identifiers
DispLine = InitLine
WindLine = InitWLine

** Get Highlight Color By Flipping Current Color along "/"

** Draw Current Page Based Upon Size Of Window
DO DispMemoPage 

** Start Up Display Loop
DO WHILE .T.
  ** Display Current Line, With or Without Highlight Based Upon Size Of Window
  ** Highlight Color Can Be Changed
  IF LineHigh
    SETCOLOR(HighColor)
  ENDIF  
  @ TopRow+WindLine-1,TopCol SAY SUBSTR(MEMOLINE(DispStr,LineLength,DispLine,TabSize,.T.),DispOffSet,DispPageWidth)
  @ TopRow+WindLine-1,TopCol SAY ""
  SETCOLOR(CurrentColor)
  ** Wait For KeyStroke
  INKEY(0)
  @ TopRow+WindLine-1,TopCol SAY SUBSTR(MEMOLINE(DispStr,LineLength,DispLine,TabSize,.T.),DispOffSet,DispPageWidth)
  @ TopRow+WindLine-1,TopCol SAY ""
  IF .NOT. EMPTY(DispFunc)
    ** Do user defined function
  ENDIF  
  ** Act Upon KeyStroke
  DO CASE
   ** If User Defined Func Present
    CASE LASTKEY() = 27 
      EXIT
    CASE LASTKEY() = 13
      IF WindLine = DispPageLength .AND. DispLine != MaxDispLines
        ** Scroll Window Area Up
        IF DispOffSet = 1
          SCROLL(TopRow,TopCol,BottRow,BottCol,1)
        ENDIF  
      ELSE
        ** Else, If Display Line Is Not At Bottom Of String
        IF DispLine != MaxDispLines
          ** Increment The Window Line Number
          WindLine = WindLine + 1
        ENDIF
      ENDIF
      ** If line number not at last line
      IF DispLine != MaxDispLines 
        ** Increment Display Line Number
        DispLine = DispLine + 1
      ENDIF
      IF DispOffSet != 1
        DispOffSet = 1
        DO DispMemoPage
      ENDIF
   ** If Down Arrow
     CASE LASTKEY() = 24
       ** If display window line number at bottom of window and not at last line
       IF WindLine = DispPageLength .AND. DispLine != MaxDispLines
         ** Scroll Window Area Up
         SCROLL(TopRow,TopCol,BottRow,BottCol,1)
       ELSE
         ** Else, If Display Line Is Not At Bottom Of String
         IF DispLine != MaxDispLines
           ** Increment The Window Line Number
           WindLine = WindLine + 1
         ENDIF
       ENDIF
       ** If line number not at last line
       IF DispLine != MaxDispLines 
         ** Increment Display Line Number
         DispLine = DispLine + 1
       ENDIF
       
   ** If Up Arrow
     CASE LASTKEY() = 5
       ** If display window line number at top of window and not at first line
       IF WindLine = 1 .AND. DispLine != 1
         ** Scroll Window Area Down
         SCROLL(TopRow,TopCol,BottRow,BottCol,-1)
       ELSE
         ** Else, If Display Line Is Not At Top Of String
         IF DispLine != 1
           ** Decrement The Window Line Number
           WindLine = WindLine - 1
         ENDIF
       ENDIF
       ** If line number not at first line
       IF DispLine != 1 
         ** Increment Display Line Number
         DispLine = DispLine - 1
       ENDIF
       
     ** If Page Down
     CASE LASTKEY() = 3
       ** If Display Line + Length Of Page Doesn't Exceed Last Display Line
       IF DispLine+DispPageLength <= MaxDispLines
         ** increment line number by number of lines per page
         DispLine = DispLine + DispPageLength
       ELSE
         ** else, increment line number to last display line
         DispLine = MaxDispLines
         WindLine = 1
       ENDIF
       ** redraw window
       DO DispMemoPage
       
     ** If Page Up   
     CASE LASTKEY() = 18
       ** If Display Line - Length Of Page Is Less Than First Display Line
       IF DispLine-DispPageLength >= 1
         ** decrement line number by number of lines per page
         DispLine = DispLine - DispPageLength
       ELSE
         ** else, decrement line number to last display line
         WindLine = 1
         DispLine = 1
       ENDIF
       ** redraw window
       DO DispMemoPage
       
     ** If Ctrl-Home
     CASE LASTKEY() = 29
       ** Move To First Line
       ** redraw window 
       WindLine = 1
       DispLine = 1
       DO DispMemoPage
       
     ** If Ctrl-End
     CASE LASTKEY() = 23
       ** Move To Last Line
       ** redraw window     
       WindLine = DispPageLength
       DispLine = MaxDispLines
       DO DispMemoPage
              
     ** If Ctrl-PgDn
     CASE LASTKEY() = 30
       ** Move To Last Window Line And Increment Display Line Appropriately
       IF DispLine + (DispPageLength - WindLine) > MaxDispLines
         WindLine = WindLine + (MaxDispLines-DispLine)
         DispLine = MaxDispLines
       ELSE
         DispLine = DispLine + (DispPageLength - WindLine)
         WindLine = DispPageLength
       ENDIF
       ** redraw window
       DO DispMemoPage     

     ** If Ctrl-PgUp
     CASE LASTKEY() = 31
       ** Move To First Window Line And Decrement Display Line Appropriately
       ** Redraw Window Page
       IF DispLine - (WindLine - 1) < 1
         DispLine = 1
         WindLine = 1
       ELSE
         DispLine = DispLine - (WindLine - 1)
         WindLine = 1
       ENDIF
       DO DispMemoPage

     ** If Tab          
     CASE LASTKEY() = 9
       IF DispOffSet + TabRight < LineLength
         DispOffSet = DispOffSet + TabRight
         DO DispMemoPage
       ENDIF       
     ** If Shft-Tab
     CASE LASTKEY() = 271
       IF DispOffSet - TabLeft > 0
         DispOffSet = DispOffSet - TabLeft
         DO DispMemoPage
       ENDIF
  ** End Of Acting Upon Keystroke
  ENDCASE      
  CLEAR TYPEAHEAD
** End Of Display Loop
ENDDO
RETURN(DispStr)

PROCEDURE DispMemoPage
PRIVATE InLine,CurrentLine
** Usage: Display String Page On Screen From Top To Bottom
@ TopRow,TopCol CLEAR TO BottRow,BottCol
InLine = DispLine - (WindLine-1)
FOR CurrentLine = 1 TO DispPageLength
  @ TopRow+CurrentLine-1,TopCol SAY SUBSTR(MEMOLINE(DispStr,LineLength,InLine,TabSize,.T.),DispOffSet,DispPageWidth)
  InLine = InLine + 1
  IF InLine > MaxDispLines
    EXIT
  ENDIF
NEXT

