/****
*   Program Name : ERRCODE.PRG                                                         
*
*   Authors      : Barry Ehret, Michael Abadjiev
*   Last Update  : 05/29/92                                                       
*
*   Purpose      : Return the error message for a given error code.
*   Language     : Clipper 5.01a
*
*   Functions    :
*       GetDosErr() --> CHARACTER
****/                


#define PROGRAMMER_ERROR  1000


STATIC DosErr := {} 


/****
*   Function GetDosErr() --> CHARACTER
*
*   Purpose: Given a DOS error code, return the corresponding
*            text error message. Note there are also user defined
*            error codes in this list.
****/

FUNCTION GetDosErr(arg)

    LOCAL nPtr, cMsg := "Unknown Error Code : 999"

    IF valtype(arg) <> "N"                           
        tone(440,1) ; tone(880,1)
        alert("Bad Parameter Function GetDosErr(arg)")
        RETURN GetDosErr(PROGRAMMER_ERROR)
    ENDIF

    IF len(DosErr) == 0     
        ErrCodeArray()
    ENDIF                                

    nPtr := ascan(DosErr,{|x| x[1] = arg})

    IF nPtr > 0
        cMsg := DosErr[nPtr,2]
    ENDIF

RETURN cMsg


****/
*   Function ErrCodeArray() --> NIL
*                             
*   Note: DosErr[..] is a static array containing error messages
*         corresponding to some of the DOS error numbers.
*         Messages may be edited or changed to null strings, if desired.
****/                                 

STATIC FUNCTION ErrCodeArray()

    DosErr := array(71)

    DosErr[001] := {001, "Invalid function number"               }
    DosErr[002] := {002, "File not found"                        }
    DosErr[003] := {003, "Path not found"                        }
    DosErr[004] := {004, "Too many open files"                   }
    DosErr[005] := {005, "Access denied"                         }
    DosErr[006] := {006, "Invalid handle"                        }
    DosErr[007] := {007, "Memory"                                }
    DosErr[008] := {008, "Insufficient memory"                   }
    DosErr[009] := {009, "Memory"                                }
    DosErr[010] := {010, "Invalid environment"                   }
    DosErr[011] := {011, "Invalid format"                        }
    DosErr[012] := {012, "Invalid access code"                   }
    DosErr[013] := {013, "Invalid data"                          }
    DosErr[014] := {015, "Invalid drive"                         }
    DosErr[015] := {016, "Cannot remove directory"               }
    DosErr[016] := {017, "Not same device"                       }
    DosErr[017] := {018, "No more files"                         }
    DosErr[018] := {019, "Write-protect"                         }
    DosErr[019] := {020, "Unknown unit"                          }
    DosErr[020] := {021, "Drive not ready"                       }
    DosErr[021] := {022,  "Unknown command"                      }
    DosErr[022] := {023,  "Data error (CRC)"                     }
    DosErr[023] := {024,  "Bad request"                          }
    DosErr[024] := {025,  "Seek error"                           }
    DosErr[025] := {026,  "Unknown media type"                   }
    DosErr[026] := {027,  "Sector not found"                     }
    DosErr[027] := {028,  "Printer out of paper"                 }
    DosErr[028] := {029,  "Write fault"                          }
    DosErr[029] := {030,  "Read fault"                           }
    DosErr[030] := {031,  "General failure"                      }
    DosErr[031] := {032,  "Sharing violation"                    }
    DosErr[032] := {033,  "Lock violation"                       }
    DosErr[033] := {034,  "Invalid disk change"                  }
    DosErr[034] := {035,  "FCB unavailable"                      }
    DosErr[035] := {036,  "Sharing buffer overflow"              }
    DosErr[036] := {050,  "Network request not supported"        }
    DosErr[037] := {051,  "Remote not listening"                 }
    DosErr[038] := {052,  "Duplicate name on network"            }
    DosErr[039] := {053,  "Network name not found"               }
    DosErr[040] := {054,  "Network busy"                         }
    DosErr[041] := {055,  "Network device no longer exists"      }
    DosErr[042] := {056,  "Network BIOS command limit exceeded"  }
    DosErr[043] := {057,  "Network adapter hardware error"       }
    DosErr[044] := {058,  "Incorrect response from network"      }
    DosErr[045] := {059,  "Unexpected network error"             }
    DosErr[046] := {060,  "Incompatible remote adapter"          }
    DosErr[047] := {061,  "Print queue full"                     }
    DosErr[048] := {062,  "Not enough space for print file"      }
    DosErr[049] := {063,  "Print file deleted"                   }
    DosErr[050] := {064,  "Network name deleted"                 }
    DosErr[051] := {065,  "Access denied"                        }
    DosErr[052] := {066,  "Network device type incorrect"        }
    DosErr[053] := {067,  "Network name not found"               }
    DosErr[054] := {068,  "Network name limit exceeded"          }
    DosErr[055] := {069,  "Network BIOS session limit exceeded"  }
    DosErr[056] := {070,  "Temporarily paused"                   }
    DosErr[057] := {071,  "Network request not accepted"         }
    DosErr[058] := {072,  "Print or disk redirection paused"     }
    DosErr[059] := {080,  "File already exists"                  }
    DosErr[060] := {082,  "Cannot make directory entry"          }
    DosErr[061] := {083,  "Fail on INT 24H"                      }
    DosErr[062] := {084,  "Too many redirections"                }
    DosErr[063] := {085,  "Duplicate redirection"                }
    DosErr[064] := {087,  "Invalid parameter"                    }
    DosErr[065] := {088,  "Network device fault"                 }
    DosErr[066] := {100,  "Corupted DBF file"                    }
    DosErr[067] := {101,  "Corupted NTX File"                    }
    DosErr[068] := {102,  "Missing or corupted DBT File"         }
    DosErr[069] := {103,  "Wrong index expression"               }
    DosErr[070] := {500,  " Invalid password !"                  }
    DosErr[071] := {1000, "Program ERROR - call SYSTEMS"         }
                        
RETURN nil


**** EOF: errcode.prg
