/****
*   Program Name: MEMORW.PRG 
*
*   Date Created: 03/10/93          
*   Time Created: 13:29:52
*   Author      : Michael Abadjiev
*   Language    : Clipper 5.0    
*   Compile     : clipper MEMORW.PRG /n /w /dTEST
*
*   -=- NOTE:   Replacement of MemoRead() and MemoWrit()
*/

#include "box.ch"

/*---------------------- Test Module --------------------------------------*/
//#define TEST
#ifdef TEST

FUNCTION TestModule()

    LOCAL cBuffer := "",                            ;
          i,j,                                      ;
          cScr := savescreen(0,0,maxrow(),maxcol())

    set cursor off
    set scoreboard off
    setcolor("W/B,W+/R")

    BEGIN SEQUENCE

    @ maxrow(),0 say padc("Wait",maxcol()+1) color "N*/W"
    IF !file("_TEST_")
        FOR j := 1 TO 120
            FOR i := 65 TO 105
                cBuffer+= chr(i) 
            NEXT
        NEXT                 

        // Write to file
        IF !memowrit("_Test_",cBuffer,.t.)
            BREAK
        ENDIF
    ELSE
        cBuffer := memoread("_TEST_",.t.)
        IF len(cBuffer) == 0
            BREAK
        ENDIF
    ENDIF                  
    dispbegin()
    dispbox(0,0,maxrow(),maxcol(),replicate("",9),"N/W")
    dispbox(0,0,maxrow(),maxcol(),B_SINGLE + " ","W/B")
    @ 0,2 say " Replacement of Clipper functions: MemoRead(),MemoWrit() - " ;
              color "GR+/B"
    @ row(), col() say "More Control " color "GR+*/B"
    @ maxrow(),2 say " Written by: Michael Abadjiev CIS: 71563,3312 " ;
              color "GB+/B"
    dispend()
    set cursor on
    cBuffer := MemoEdit( cBuffer,01,01,maxrow()-1,maxcol()-1,.t.)

    memowrit("_TEST_",cBuffer,.t.)

    END SEQUENCE

    restscreen(0,0,maxrow(),maxcol(),cScr)

RETURN nil

#endif

/*---------------------- End of Test Module -------------------------------*/


/****
*       Function: MemoRead(<cFile>,[<lDisplay>]) -->CHARACTER
*       Purpose : Replacement of MemoRead() - more control
*   Date Created: 03/10/93
*/

FUNCTION MemoRead(cFile, lDisplay)

   LOCAL nError, cResult := "", nSize, nHandle, nBytes

   lDisplay := IF(valtype(lDisplay) <> "L",.f.,lDisplay)

   BEGIN SEQUENCE

        IF valtype(cFile) <> "C"
            alert("ERROR: Function MemoRead(cFile)!;"+GetDosErr(1000))
            cResult := ""
            BREAK
        ENDIF

        nHandle := fopen(cFile)

        IF (nError := ferror()) <> 0
            IF(lDisplay,alert("ERROR: " + GetDosErr(nError)),nil)
            BREAK
        ENDIF

        IF (nSize := FSize(cFile)) == 0 
            IF(lDisplay,alert("ERROR: File: " + upper(cFile) + " just created!;"+;
                    "Nothing to read!"),nil)
            BREAK
        ENDIF
        IF nSize >= 64000
            IF(lDisplay,alert("ERROR: File: " + upper(cFile) + " too big!;"+;
                    "Clipper cannot hadle that file!"),nil)
            BREAK
        ENDIF
        cResult := space(nSize)            
        nBytes := len(cResult)
        IF fread(nHandle,@cResult,nBytes) <> nBytes
            cResult := "" 
            IF(lDisplay,alert("ERROR: Reading file: " + upper(cFile)),nil)
            BREAK
        ENDIF

    END SEQUENCE

    IF(nError == 0,fclose(nHandle),nil)

RETURN cResult


/****
*       Function: MemoWrit(<cFile>,<cVar>,[<lDisplay>]) -->LOGICAL
*       Purpose : Replacement of MemoWrit() - more control
*   Date Created: 03/10/93
*/


FUNCTION MemoWrit(cFile, cVar, lDisplay)

   LOCAL nError, lResult := .f., nSize, nHandle, nBytes

   lDisplay := IF(valtype(lDisplay) <> "L",.f.,lDisplay)

   BEGIN SEQUENCE

        IF valtype(cFile) <> "C"
            alert("ERROR: Function MemoWrit(cFile)!;"+GetDosErr(1000))
            BREAK
        ENDIF

        IF valtype(cVar) <> "C"
            alert("ERROR: Function MemoWrit(,cVar)!;"+GetDosErr(1000))
            BREAK
        ENDIF

        // File exist...
        nHandle := fopen(cFile)

        IF (nError := ferror()) == 0
            IF lDisplay
                IF  alert("WARNING: File:" + upper(cFile) + ;
                    " Already exist!;" + "Overwrite file?",{"No","Yes"}) <> 2
                    BREAK
                ENDIF
            ENDIF
        ENDIF

        IF(nError == 0,fclose(nHandle),nil)

        nHandle := fcreate(cFile)

        IF (nError := ferror()) <> 0
            IF(lDisplay,alert("ERROR: " + GetDosErr(nError)),nil)
            BREAK
        ENDIF  

        // Just for speed considerations....
        nBytes := len(cVar)
        IF fwrite(nHandle,@cVar,nBytes) <> nBytes
            IF(lDisplay,alert("ERROR: Reading file: " + upper(cFile)),nil)
            BREAK
        ENDIF

        // Finally evething is fine...
        lResult := .t.

    END SEQUENCE

    IF(nError == 0,fclose(nHandle),nil)

RETURN lResult
