*Copyright 1993 Robert Greenlee, 619-268-0112, CI$ 72677,517, Distribute Freely
*Example of printing in the background during a MemoEdit session. CL5.2c.
*Compile/Link   CLIPPER memopr         RTLINK  fi memopr 
#include "inkey.ch"     //          or BLINKER fi memopr 
#include "memoedit.ch"  //                                     9/30/93
#include "Getexit.ch"
PARAMETER cFile
cStr := 'Usually the name of a file to edit is supplied on the command line!'
if cFile != Nil ; cStr := memoread(cFile) ; else ; cFile := 'TEXT' ; endif
set printer to LPT1 ; nSpaces := nLMargin := 5 ; nPageLen := 60
nTop:=1 ; nBot:=23 ; nLeft:=0 ; nWrap:=(nRight:=79)-4 ; nTab:=5; aStk:={}
nFakeKey:=K_CTRL_Q; cFakeKey:=chr(nFakeKey) // pick a do nothing key
nLineCnt:=nPtr:=0; cPBuf:='' ; nRStrt:=1 ; nCStrt:=nRoff:=nCoff:=0
fpush(.t.) ; oldtext := cStr ; lDispBegin := .f. 
SET KEY K_F1 TO fHelp() ; SET KEY K_F10 to fF10()
//
while ! ( ( lkey:=lastkey() ) = K_CTRL_W .or. lkey = K_ESC)
  if lkey = K_ALT_P // start printing or add more to what's printing now
    nPtr := MAX(nPtr,1) ; cPBuf += strtran(cStr,chr(141),chr(13)) + CHR(12)
  elseif lkey = K_ALT_I .or. lkey = K_ALT_E // import/export
    DispEnd() ; cIFile:=SPAC(31)
    @ 24,2 SAY iif(lkey=K_ALT_I,'Insert','Export to')+' which file '
    oGet := ;
    getnew(row(),col(),{|cnew| iif(pcount()=0,cIFile,cIFile:=cnew)},"cIFile")
    oGet:Reader := {|oGet| oGReader(oGet)}
    ReadModal({oGet}) ; cIFile:=alltrim(cIFile)
    if lkey=K_ALT_I
      cStr := stuff(cStr,MLCtoPos(cStr,nwrap,nRStrt,nCStrt,nTab,.t.),0,;
              memoread(cIFile)) ; else ; memowrit(cIFile,cStr)
    endi
    DispBegin()
  else ; DispBegin() ; lDispBegin:=.t.
  end
  cStr:=memoedit(cStr,nTop+1,nLeft+2,nBot-1,nRight-1,.T.,"mFunc",;
                 nWrap,nTab,nRStrt,nCStrt,nRoff,nCoff)
enddo
//
cls ; setpos(24,0)
if ! lastkey()=K_ESC; qout('Writing file '+UPPE(cFile)+'.')
  memowrit(cFile,cStr)
endif
if oldtext == cStr ; qout('Text was not changed.') ; endif
return

FUNC mFunc
PARA mode,LINE,COL
key := lastkey() ; retval := 0
if mode = ME_INIT; clear
  @ 0,2 say 'F1=Help  Alt-P=Starts Background Printing'
  @ nTop,nLeft TO nBot,nRight DOUBLE  // draw box around edit window
  @ 24,2 say 'ESC=Abort  F10=Save'
//
elseif mode = ME_IDLE 
  fpush(.f.);@ 24,34 say 'Line:'+str(LINE,3)+'  Col: '+str(COL,2);fpop()
  if lDispBegin ; DispEnd() ; lDispBegin := .f. ; endif 
  fprint()
//
else
  if key = nFakeKey ; fprint() ; endif
  if key = K_ALT_P .or. key=K_ALT_I .or. key=K_ALT_E ; retval := K_CTRL_W
    nRStrt:=LINE; nCStrt:=COL; nRoff:=row()-nTop+1; nCoff:=col()-nLeft+2
    DispBegin() ; lDispBegin := .t.
  else
   if nextkey() = 0 ; keyboard(cFakeKey) ; endif
  endi
endif
return retval

FUNC fprint(lDoInkey)
set console off ; set print on; fpush(); @ 24,55 SAY space(8)
if nPtr > 0; setcolor('GR+/GB'); @ 24,55 SAY 'Printing'; endif
fpop()
while nextkey() = 0
  if (! nPtr=0) .and. isprinter()
    if nSpaces > 0 ; nSpaces-- ; ?? ' ' ; loop ; endif // do left margin
    if nLineCnt >= nPageLen ; EJECT ; nLineCnt := 0 ; loop ; endif
    c2P := subs(cPBuf,nPtr,1)
    ?? iif(c2P=CHR(10) .and. ++nLineCnt=nPageLen,'',c2P) // stop auto-eject
    if c2P=CHR(10); nSpaces := nLMargin ; endif
    if nPtr++ > LEN(cPBuf)  // all done?
      nPtr := 0 ; cPBUF := '' ; fpush(.f.) ; @ 24,55 say spac(8) ; fpop()
    endif
  endif
enddo
set print off ; set console on
return iif( pcount()=0, Nil, inkey() )

FUNC fpush(cursor_on)  // Saves row/col/cursor/color. Sets default color.
asize(aStk,len(aStk)+1)
aStk[LEN(aStk)] := { row(), col(), setcursor(), setcolor() }
setcolor( iif( iscolor(), 'BG+/B', 'GR/N' ) )
if ! pcount() = 0; setcursor( iif( cursor_on, 1, 0 ) ) ; endif
return Nil

FUNC fpop             // Restores row/col/cursor/color.
n:=len(aStk)
setpos(aStk[n,1],aStk[n,2]); setcursor(aStk[n,3]); setcolor(aStk[n,4])
asize(aStk,n-1)
return Nil

FUNC fHelp
setkey(K_F1,Nil) ; fpush(.f.); save screen
@ 0,0 clear to 24,79
TEXT
                            -- The F1 Help Screen --

     Program demonstrates background printing during a MemoEdit session,
     including during a GET/READ and display of pop-up help.

     Alt-P starts background printing of current text.
     F10 or Ctrl-W saves and exits, while ESC aborts without saving.
     Alt-I Inserts text from a file at the cursor position.
     Alt-E Exports the text to a file.

     Plus the usual MemoEdit commands:    Arrow Keys & Ctrl-Arrows.
     Ctrl-B reforms paragraph.            Ctrl-A moves left one word.
     Ctrl-Y deletes current line.         Ctrl-F moves right one word.
     Ctrl-T deletes word right.           Home moves to beginning of line.
     Ctrl-V/Ins toggles insert mode.      End moves to end of line.
     Ctrl-E moves up one line.            Ctrl-Home moves to window top.
     Ctrl-X moves down one line.          Ctrl-End moves to window bottom.
     Ctrl-S moves left one character.     Ctrl-PgUp moves to file top.
     Ctrl-D moves right one character.    Ctrl-PgDn moves to file bottom.

                            Touch any key to continue

 Copyright 1993 Robert Greenlee, 619-268-0112, CI$ 72677,517, Distribute Freely
ENDTEXT

fprint(.t.)
fpop() ; restore screen ; SET KEY K_F1 TO fHelp() ; keyboard(cFakeKey)
return Nil

FUNC fF10
keyboard(chr(K_CTRL_W))
return Nil
 
PROC oGReader( oG )  // Custom GetReader for Background Printing in GETS
if ! ( GetPreValidate( oG ) ) ; return ; endif
oG:setFocus()
while ( oG:exitState == GE_NOEXIT )
  if ( oG:typeOut ) ; oG:exitState := GE_ENTER ; endif
  while oG:exitState == GE_NOEXIT ; GetApplyKey(oG,fprint(.t.)) ; enddo
  if !GetPostValidate(oG) ; oG:exitState := GE_NOEXIT ; endif
enddo
oG:killFocus()
return
// EOF

