* PROGRAM: MEMOTEST.PRG
*  AUTHOR: K. E. Saffer
*    DATE: 04/02/87
*  
*  Demonstrates the usage of the MEMOLINE() function.
*  
*  Output of the memo field is to the screen or printer.

* establish standard working environment
*
SET BELL OFF
SET COLOR TO
SET CONFIRM ON
SET CONSOLE ON
SET DELETED ON
SET DELIMITER TO '[]'
SET DELIMITER ON
SET DEVICE TO SCREEN
SET ESCAPE ON
SET HEADING OFF
SET INTENSITY ON
SET MENU OFF
SET PRINT OFF
SET SAFETY OFF
SET TALK OFF

* Mlines used to hold the screen lines
Mlines = REPLICATE("=",79)

* open data file with memo field "memo"
USE MemoTest

* begin program loop
DO WHILE .T.
  CLEAR
  @ 01,00 SAY Mlines
  @ 02,23 SAY "MEMO DISPLAY - PRINT DEMONSTRATION"
  @ 03,00 SAY Mlines
  @ 23,00 SAY Mlines
  ScrnPrnt = " "
  @ 10,15 SAY "Output memo field to the screen or printer? (P/S)" GET ScrnPrnt PICTURE '!'
  READ
  
  IF AT(ScrnPrnt,"PS") = 0
    CLEAR
    CANCEL
  ENDIF

  IF ScrnPrnt = "S"
    * output to the screen
    CurrentLine = 1
    MaxLines = 19
    DO WHILE .T.
      * clear screen and position cursor
      @ 04,00 CLEAR
      @ 04,00 SAY ""
      ?? MEMOLINE(Memo,CurrentLine,MaxLines)
      WAIT "Press any key to continue..."
      CurrentLine = CurrentLine + MaxLines
      IF LEN(MEMOLINE(Memo,CurrentLine,MaxLines)) = 0
         * we are at the end of the memo, exit do while
         EXIT
      ENDIF
    ENDDO
  ENDIF

  IF ScrnPrnt = "P"
    * output to the printer
    CurrentLine = 1
    MaxLines = 55
    SET PRINT ON
    SET CONSOLE OFF
    DO WHILE .T.
      * print memo at 55 lines per page
      ?? MEMOLINE(Memo,CurrentLine,MaxLines)
      EJECT
      CurrentLine = CurrentLine + MaxLines
      IF LEN(MEMOLINE(Memo,CurrentLine,MaxLines)) = 0
        * we are at the end of the memo, exit do while
        SET PRINT OFF
        SET CONSOLE ON
        EXIT
      ENDIF
    ENDDO
  ENDIF
ENDDO
